/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.ObjectCollection;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import java.lang.reflect.Array;
import java.util.Arrays;

abstract class AbstractObjectCollection<KType>
implements ObjectCollection<KType> {
    AbstractObjectCollection() {
    }

    @Override
    public int removeAll(ObjectLookupContainer<? extends KType> c) {
        final ObjectLookupContainer<? extends KType> c2 = c;
        return this.removeAll(new ObjectPredicate<KType>(){

            @Override
            public boolean apply(KType k) {
                return c2.contains(k);
            }
        });
    }

    @Override
    public int retainAll(ObjectLookupContainer<? extends KType> c) {
        final ObjectLookupContainer<? extends KType> c2 = c;
        return this.removeAll(new ObjectPredicate<KType>(){

            @Override
            public boolean apply(KType k) {
                return !c2.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final ObjectPredicate<? super KType> predicate) {
        return this.removeAll(new ObjectPredicate<KType>(){

            @Override
            public boolean apply(KType value) {
                return !predicate.apply(value);
            }
        });
    }

    @Override
    public KType[] toArray(Class<? super KType> clazz) {
        int size = this.size();
        Object[] array = (Object[])Array.newInstance(clazz, size);
        int i = 0;
        for (ObjectCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        int i = 0;
        for (ObjectCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

