/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.tpcds;

import com.google.common.collect.ImmutableMap;
import java.sql.Date;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.hydromatic.tpcds.TpcdsColumn;
import net.hydromatic.tpcds.TpcdsEntity;
import net.hydromatic.tpcds.TpcdsTable;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.util.Bug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TpcdsSchema
extends AbstractSchema {
    private final double scaleFactor;
    private final int part;
    private final int partCount;
    private final ImmutableMap<String, Table> tableMap;
    private static final ImmutableMap<String, Integer> TABLE_ROW_COUNTS = ImmutableMap.builder().put((Object)"call_center", (Object)8).put((Object)"catalog_page", (Object)11718).put((Object)"catalog_returns", (Object)144067).put((Object)"catalog_sales", (Object)1441548).put((Object)"customer", (Object)100000).put((Object)"customer_address", (Object)50000).put((Object)"customer_demographics", (Object)1920800).put((Object)"date_dim", (Object)73049).put((Object)"household_demographics", (Object)7200).put((Object)"income_band", (Object)20).put((Object)"inventory", (Object)11745000).put((Object)"item", (Object)18000).put((Object)"promotion", (Object)300).put((Object)"reason", (Object)35).put((Object)"ship_mode", (Object)20).put((Object)"store", (Object)12).put((Object)"store_returns", (Object)287514).put((Object)"store_sales", (Object)2880404).put((Object)"time_dim", (Object)86400).put((Object)"warehouse", (Object)5).put((Object)"web_page", (Object)60).put((Object)"web_returns", (Object)71763).put((Object)"web_sales", (Object)719384).put((Object)"web_site", (Object)1).build();

    public TpcdsSchema(double scaleFactor, int part, int partCount) {
        this.scaleFactor = scaleFactor;
        this.part = part;
        this.partCount = partCount;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TpcdsTable tpcdsTable : TpcdsTable.getTables()) {
            builder.put((Object)tpcdsTable.getTableName().toUpperCase(), new TpcdsQueryableTable(tpcdsTable));
        }
        this.tableMap = builder.build();
    }

    protected Map<String, Table> getTableMap() {
        return this.tableMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TpcdsQueryableTable<E extends TpcdsEntity>
    extends AbstractQueryableTable {
        private final TpcdsTable<E> tpcdsTable;

        TpcdsQueryableTable(TpcdsTable<E> tpcdsTable) {
            super(Object[].class);
            this.tpcdsTable = tpcdsTable;
        }

        public Statistic getStatistic() {
            Bug.upgrade((String)"add row count estimate to TpcdsTable, and use it");
            Integer rowCount = (Integer)TABLE_ROW_COUNTS.get((Object)this.tpcdsTable.name);
            assert (rowCount != null) : this.tpcdsTable.name;
            return Statistics.of((double)rowCount.intValue(), Collections.emptyList());
        }

        public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            return new AbstractTableQueryable<Object[]>(queryProvider, schema, (QueryableTable)this, tableName){

                public Enumerator<Object[]> enumerator() {
                    final Enumerator iterator = Linq4j.iterableEnumerator((Iterable)TpcdsQueryableTable.this.tpcdsTable.createGenerator(TpcdsSchema.this.scaleFactor, TpcdsSchema.this.part, TpcdsSchema.this.partCount));
                    return new Enumerator<Object[]>(){

                        public Object[] current() {
                            List columns = TpcdsQueryableTable.this.tpcdsTable.getColumns();
                            Object[] objects = new Object[columns.size()];
                            int i = 0;
                            for (TpcdsColumn column : columns) {
                                objects[i++] = this.value(column, (TpcdsEntity)iterator.current());
                            }
                            return objects;
                        }

                        private Object value(TpcdsColumn<E> tpcdsColumn, E current) {
                            Class type = TpcdsQueryableTable.this.realType(tpcdsColumn);
                            if (type == String.class) {
                                return tpcdsColumn.getString(current);
                            }
                            if (type == Double.class) {
                                return tpcdsColumn.getDouble(current);
                            }
                            if (type == Date.class) {
                                return Date.valueOf(tpcdsColumn.getString(current));
                            }
                            return tpcdsColumn.getLong(current);
                        }

                        public boolean moveNext() {
                            return iterator.moveNext();
                        }

                        public void reset() {
                            iterator.reset();
                        }

                        public void close() {
                        }
                    };
                }
            };
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
            for (TpcdsColumn column : this.tpcdsTable.getColumns()) {
                builder.add(column.getColumnName().toUpperCase(), typeFactory.createJavaType(this.realType(column)));
            }
            return builder.build();
        }

        private Class<?> realType(TpcdsColumn<E> column) {
            if (column.getColumnName().endsWith("date")) {
                return Date.class;
            }
            return column.getType();
        }
    }
}

