/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.tpcds;

import java.util.Random;
import net.hydromatic.optiq.test.OptiqAssert;
import net.hydromatic.tpcds.query.Query;
import org.junit.Ignore;
import org.junit.Test;

public class TpcdsTest {
    public static final String TPCDS_MODEL = "{\n  version: '1.0',\n  defaultSchema: 'TPCDS',\n   schemas: [\n" + TpcdsTest.schema("TPCDS", "1.0") + ",\n" + TpcdsTest.schema("TPCDS_01", "0.01") + ",\n" + TpcdsTest.schema("TPCDS_5", "5.0") + "\n" + "   ]\n" + "}";

    private static String schema(String name, String scaleFactor) {
        return "     {\n       type: 'custom',\n       name: '" + name + "',\n" + "       factory: 'net.hydromatic.optiq.impl.tpcds.TpcdsSchemaFactory',\n" + "       operand: {\n" + "         columnPrefix: true,\n" + "         scale: " + scaleFactor + "\n" + "       }\n" + "     }";
    }

    private OptiqAssert.AssertThat with() {
        return OptiqAssert.that().withModel(TPCDS_MODEL).enable(OptiqAssert.ENABLE_SLOW);
    }

    @Test
    public void testCallCenter() {
        this.with().query("select * from tpcds.call_center").returnsUnordered(new String[0]);
    }

    @Ignore(value="add tests like this that count each table")
    @Test
    public void testLineItem() {
        this.with().query("select * from tpcds.lineitem").returnsCount(6001215);
    }

    @Ignore(value="add tests like this that count each table")
    @Test
    public void testCustomer5() {
        this.with().query("select * from tpcds_5.customer").returnsCount(750000);
    }

    @Test
    public void testQuery01() {
        this.checkQuery(1).runs();
    }

    @Ignore(value="takes too long to optimize")
    @Test
    public void testQuery72() {
        this.checkQuery(72).runs();
    }

    @Ignore(value="work in progress")
    @Test
    public void testQuery72Plan() {
        this.checkQuery(72).planContains("xx");
    }

    private OptiqAssert.AssertQuery checkQuery(int i) {
        Query query = Query.of((int)i);
        String sql = query.sql(-1, new Random(0L));
        switch (i) {
            case 72: {
                sql = sql.replace("+ 5", "+ interval '5' day");
            }
        }
        return this.with().query(sql.replaceAll("tpcds\\.", "tpcds_01."));
    }
}

