/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.tpcds;

import com.google.common.collect.ImmutableMap;
import java.sql.Date;
import java.util.List;
import java.util.Map;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.optiq.QueryableTable;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.impl.AbstractSchema;
import net.hydromatic.optiq.impl.AbstractTableQueryable;
import net.hydromatic.optiq.impl.java.AbstractQueryableTable;
import net.hydromatic.tpcds.TpcdsColumn;
import net.hydromatic.tpcds.TpcdsEntity;
import net.hydromatic.tpcds.TpcdsTable;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TpcdsSchema
extends AbstractSchema {
    private final double scaleFactor;
    private final int part;
    private final int partCount;
    private final ImmutableMap<String, Table> tableMap;

    public TpcdsSchema(double scaleFactor, int part, int partCount) {
        this.scaleFactor = scaleFactor;
        this.part = part;
        this.partCount = partCount;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        TpcdsTable[] tpcdsTableArray = TpcdsTable.getTables();
        int n = tpcdsTableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TpcdsTable tpcdsTable = tpcdsTableArray[n2];
            builder.put((Object)tpcdsTable.getTableName().toUpperCase(), new TpcdsQueryableTable(tpcdsTable));
            ++n2;
        }
        this.tableMap = builder.build();
    }

    protected Map<String, Table> getTableMap() {
        return this.tableMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TpcdsQueryableTable<E extends TpcdsEntity>
    extends AbstractQueryableTable {
        private final TpcdsTable<E> tpcdsTable;

        TpcdsQueryableTable(TpcdsTable<E> tpcdsTable) {
            super(Object[].class);
            this.tpcdsTable = tpcdsTable;
        }

        public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            return new AbstractTableQueryable<Object[]>(queryProvider, schema, (QueryableTable)this, tableName){

                public Enumerator<Object[]> enumerator() {
                    final Enumerator iterator = Linq4j.iterableEnumerator((Iterable)TpcdsQueryableTable.this.tpcdsTable.createGenerator(TpcdsSchema.this.scaleFactor, TpcdsSchema.this.part, TpcdsSchema.this.partCount));
                    return new Enumerator<Object[]>(){

                        public Object[] current() {
                            List columns = TpcdsQueryableTable.this.tpcdsTable.getColumns();
                            Object[] objects = new Object[columns.size()];
                            int i = 0;
                            for (TpcdsColumn column : columns) {
                                objects[i++] = this.value(column, (TpcdsEntity)iterator.current());
                            }
                            return objects;
                        }

                        private Object value(TpcdsColumn<E> tpcdsColumn, E current) {
                            Class type = TpcdsQueryableTable.this.realType(tpcdsColumn);
                            if (type == String.class) {
                                return tpcdsColumn.getString(current);
                            }
                            if (type == Double.class) {
                                return tpcdsColumn.getDouble(current);
                            }
                            if (type == Date.class) {
                                return Date.valueOf(tpcdsColumn.getString(current));
                            }
                            return tpcdsColumn.getLong(current);
                        }

                        public boolean moveNext() {
                            return iterator.moveNext();
                        }

                        public void reset() {
                            iterator.reset();
                        }

                        public void close() {
                        }
                    };
                }
            };
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
            for (TpcdsColumn column : this.tpcdsTable.getColumns()) {
                builder.add(column.getColumnName().toUpperCase(), typeFactory.createJavaType(this.realType(column)));
            }
            return builder.build();
        }

        private Class<?> realType(TpcdsColumn<E> column) {
            if (column.getColumnName().endsWith("date")) {
                return Date.class;
            }
            return column.getType();
        }
    }
}

