/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.tpch;

import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.optiq.test.OptiqAssert;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TpchTest {
    public static final String TPCH_MODEL = "{\n  version: '1.0',\n  defaultSchema: 'TPCH',\n   schemas: [\n" + TpchTest.schema("TPCH", "1.0") + ",\n" + TpchTest.schema("TPCH_01", "0.01") + ",\n" + TpchTest.schema("TPCH_5", "5.0") + "\n" + "   ]\n" + "}";
    static final String[] QUERIES = new String[]{"select\n  l_returnflag,\n  l_linestatus,\n  sum(l_quantity) as sum_qty,\n  sum(l_extendedprice) as sum_base_price,\n  sum(l_extendedprice * (1 - l_discount)) as sum_disc_price,\n  sum(l_extendedprice * (1 - l_discount) * (1 + l_tax)) as sum_charge,\n  avg(l_quantity) as avg_qty,\n  avg(l_extendedprice) as avg_price,\n  avg(l_discount) as avg_disc,\n  count(*) as count_order\nfrom\n  tpch.lineitem\n-- where\n--  l_shipdate <= date '1998-12-01' - interval '120' day (3)\ngroup by\n  l_returnflag,\n  l_linestatus\n\norder by\n  l_returnflag,\n  l_linestatus", "select\n  s.s_acctbal,\n  s.s_name,\n  n.n_name,\n  p.p_partkey,\n  p.p_mfgr,\n  s.s_address,\n  s.s_phone,\n  s.s_comment\nfrom\n  tpch.part p,\n  tpch.supplier s,\n  tpch.partsupp ps,\n  tpch.nation n,\n  tpch.region r\nwhere\n  p.p_partkey = ps.ps_partkey\n  and s.s_suppkey = ps.ps_suppkey\n  and p.p_size = 41\n  and p.p_type like '%NICKEL'\n  and s.s_nationkey = n.n_nationkey\n  and n.n_regionkey = r.r_regionkey\n  and r.r_name = 'EUROPE'\n  and ps.ps_supplycost = (\n\n    select\n      min(ps.ps_supplycost)\n\n    from\n      tpch.partsupp ps,\n      tpch.supplier s,\n      tpch.nation n,\n      tpch.region r\n    where\n      p.p_partkey = ps.ps_partkey\n      and s.s_suppkey = ps.ps_suppkey\n      and s.s_nationkey = n.n_nationkey\n      and n.n_regionkey = r.r_regionkey\n      and r.r_name = 'EUROPE'\n  )\n\norder by\n  s.s_acctbal desc,\n  n.n_name,\n  s.s_name,\n  p.p_partkey\nlimit 100", "select\n  l.l_orderkey,\n  sum(l.l_extendedprice * (1 - l.l_discount)) as revenue,\n  o.o_orderdate,\n  o.o_shippriority\n\nfrom\n  tpch.customer c,\n  tpch.orders o,\n  tpch.lineitem l\n\nwhere\n  c.c_mktsegment = 'HOUSEHOLD'\n  and c.c_custkey = o.o_custkey\n  and l.l_orderkey = o.o_orderkey\n--  and o.o_orderdate < date '1995-03-25'\n--  and l.l_shipdate > date '1995-03-25'\n\ngroup by\n  l.l_orderkey,\n  o.o_orderdate,\n  o.o_shippriority\norder by\n  revenue desc,\n  o.o_orderdate\nlimit 10", "select\n  o_orderpriority,\n  count(*) as order_count\nfrom\n  tpch.orders\n\nwhere\n--  o_orderdate >= date '1996-10-01'\n--  and o_orderdate < date '1996-10-01' + interval '3' month\n--  and \n  exists (\n    select\n      *\n    from\n      tpch.lineitem\n    where\n      l_orderkey = o_orderkey\n      and l_commitdate < l_receiptdate\n  )\ngroup by\n  o_orderpriority\norder by\n  o_orderpriority", "select\n  n.n_name,\n  sum(l.l_extendedprice * (1 - l.l_discount)) as revenue\n\nfrom\n  tpch.customer c,\n  tpch.orders o,\n  tpch.lineitem l,\n  tpch.supplier s,\n  tpch.nation n,\n  tpch.region r\n\nwhere\n  c.c_custkey = o.o_custkey\n  and l.l_orderkey = o.o_orderkey\n  and l.l_suppkey = s.s_suppkey\n  and c.c_nationkey = s.s_nationkey\n  and s.s_nationkey = n.n_nationkey\n  and n.n_regionkey = r.r_regionkey\n  and r.r_name = 'EUROPE'\n--  and o.o_orderdate >= date '1997-01-01'\n--  and o.o_orderdate < date '1997-01-01' + interval '1' year\ngroup by\n  n.n_name\n\norder by\n  revenue desc", "select\n  sum(l_extendedprice * l_discount) as revenue\nfrom\n  tpch.lineitem\nwhere\n--  l_shipdate >= date '1997-01-01'\n--  and l_shipdate < date '1997-01-01' + interval '1' year\n--  and\n  l_discount between 0.03 - 0.01 and 0.03 + 0.01\n  and l_quantity < 24", "select\n  supp_nation,\n  cust_nation,\n  l_year,\n  sum(volume) as revenue\nfrom\n  (\n    select\n      n1.n_name as supp_nation,\n      n2.n_name as cust_nation,\n      extract(year from l.l_shipdate) as l_year,\n      l.l_extendedprice * (1 - l.l_discount) as volume\n    from\n      tpch.supplier s,\n      tpch.lineitem l,\n      tpch.orders o,\n      tpch.customer c,\n      tpch.nation n1,\n      tpch.nation n2\n    where\n      s.s_suppkey = l.l_suppkey\n      and o.o_orderkey = l.l_orderkey\n      and c.c_custkey = o.o_custkey\n      and s.s_nationkey = n1.n_nationkey\n      and c.c_nationkey = n2.n_nationkey\n      and (\n        (n1.n_name = 'EGYPT' and n2.n_name = 'UNITED STATES')\n        or (n1.n_name = 'UNITED STATES' and n2.n_name = 'EGYPT')\n      )\n--      and l.l_shipdate between date '1995-01-01' and date '1996-12-31'\n  ) as shipping\ngroup by\n  supp_nation,\n  cust_nation,\n  l_year\norder by\n  supp_nation,\n  cust_nation,\n  l_year", "select\n  o_year,\n  sum(case\n    when nation = 'EGYPT' then volume\n    else 0\n  end) / sum(volume) as mkt_share\nfrom\n  (\n    select\n      extract(year from o.o_orderdate) as o_year,\n      l.l_extendedprice * (1 - l.l_discount) as volume,\n      n2.n_name as nation\n    from\n      tpch.part p,\n      tpch.supplier s,\n      tpch.lineitem l,\n      tpch.orders o,\n      tpch.customer c,\n      tpch.nation n1,\n      tpch.nation n2,\n      tpch.region r\n    where\n      p.p_partkey = l.l_partkey\n      and s.s_suppkey = l.l_suppkey\n      and l.l_orderkey = o.o_orderkey\n      and o.o_custkey = c.c_custkey\n      and c.c_nationkey = n1.n_nationkey\n      and n1.n_regionkey = r.r_regionkey\n      and r.r_name = 'MIDDLE EAST'\n      and s.s_nationkey = n2.n_nationkey\n      and o.o_orderdate between date '1995-01-01' and date '1996-12-31'\n      and p.p_type = 'PROMO BRUSHED COPPER'\n  ) as all_nations\ngroup by\n  o_year\norder by\n  o_year", "select\n  nation,\n  o_year,\n  sum(amount) as sum_profit\nfrom\n  (\n    select\n      n_name as nation,\n      extract(year from o_orderdate) as o_year,\n      l.l_extendedprice * (1 - l.l_discount) - ps.ps_supplycost * l.l_quantity as amount\n    from\n      tpch.part p,\n      tpch.supplier s,\n      tpch.lineitem l,\n      tpch.partsupp ps,\n      tpch.orders o,\n      tpch.nation n\n    where\n      s.s_suppkey = l.l_suppkey\n      and ps.ps_suppkey = l.l_suppkey\n      and ps.ps_partkey = l.l_partkey\n      and p.p_partkey = l.l_partkey\n      and o.o_orderkey = l.l_orderkey\n      and s.s_nationkey = n.n_nationkey\n      and p.p_name like '%yellow%'\n  ) as profit\ngroup by\n  nation,\n  o_year\norder by\n  nation,\n  o_year desc", "select\n  c.c_custkey,\n  c.c_name,\n  sum(l.l_extendedprice * (1 - l.l_discount)) as revenue,\n  c.c_acctbal,\n  n.n_name,\n  c.c_address,\n  c.c_phone,\n  c.c_comment\nfrom\n  tpch.customer c,\n  tpch.orders o,\n  tpch.lineitem l,\n  tpch.nation n\nwhere\n  c.c_custkey = o.o_custkey\n  and l.l_orderkey = o.o_orderkey\n  and o.o_orderdate >= date '1994-03-01'\n  and o.o_orderdate < date '1994-03-01' + interval '3' month\n  and l.l_returnflag = 'R'\n  and c.c_nationkey = n.n_nationkey\ngroup by\n  c.c_custkey,\n  c.c_name,\n  c.c_acctbal,\n  c.c_phone,\n  n.n_name,\n  c.c_address,\n  c.c_comment\norder by\n  revenue desc\nlimit 20", "select\n  ps.ps_partkey,\n  sum(ps.ps_supplycost * ps.ps_availqty) as \"value\"\nfrom\n  tpch.partsupp ps,\n  tpch.supplier s,\n  tpch.nation n\nwhere\n  ps.ps_suppkey = s.s_suppkey\n  and s.s_nationkey = n.n_nationkey\n  and n.n_name = 'JAPAN'\ngroup by\n  ps.ps_partkey having\n    sum(ps.ps_supplycost * ps.ps_availqty) > (\n      select\n        sum(ps.ps_supplycost * ps.ps_availqty) * 0.0001000000\n      from\n        tpch.partsupp ps,\n        tpch.supplier s,\n        tpch.nation n\n      where\n        ps.ps_suppkey = s.s_suppkey\n        and s.s_nationkey = n.n_nationkey\n        and n.n_name = 'JAPAN'\n    )\norder by\n  \"value\" desc", "select\n  l.l_shipmode,\n  sum(case\n    when o.o_orderpriority = '1-URGENT'\n      or o.o_orderpriority = '2-HIGH'\n      then 1\n    else 0\n  end) as high_line_count,\n  sum(case\n    when o.o_orderpriority <> '1-URGENT'\n      and o.o_orderpriority <> '2-HIGH'\n      then 1\n    else 0\n  end) as low_line_count\nfrom\n  tpch.orders o,\n  tpch.lineitem l\nwhere\n  o.o_orderkey = l.l_orderkey\n  and l.l_shipmode in ('TRUCK', 'REG AIR')\n  and l.l_commitdate < l.l_receiptdate\n  and l.l_shipdate < l.l_commitdate\n--  and l.l_receiptdate >= date '1994-01-01'\n--  and l.l_receiptdate < date '1994-01-01' + interval '1' year\ngroup by\n  l.l_shipmode\norder by\n  l.l_shipmode", "select\n  c_count,\n  count(*) as custdist\nfrom\n  (\n    select\n      c.c_custkey,\n      count(o.o_orderkey)\n    from\n      tpch.customer c \n      left outer join tpch.orders o \n        on c.c_custkey = o.o_custkey\n        and o.o_comment not like '%special%requests%'\n    group by\n      c.c_custkey\n  ) as orders (c_custkey, c_count)\ngroup by\n  c_count\norder by\n  custdist desc,\n  c_count desc", "select\n  100.00 * sum(case\n    when p.p_type like 'PROMO%'\n      then l.l_extendedprice * (1 - l.l_discount)\n    else 0\n  end) / sum(l.l_extendedprice * (1 - l.l_discount)) as promo_revenue\nfrom\n  tpch.lineitem l,\n  tpch.part p\nwhere\n  l.l_partkey = p.p_partkey\n  and l.l_shipdate >= date '1994-08-01'\n  and l.l_shipdate < date '1994-08-01' + interval '1' month", "with revenue0 (supplier_no, total_revenue) as (\n  select\n    l_suppkey,\n    sum(l_extendedprice * (1 - l_discount))\n  from\n    tpch.lineitem\n  where\n    l_shipdate >= date '1993-05-01'\n    and l_shipdate < date '1993-05-01' + interval '3' month\n  group by\n    l_suppkey)\nselect\n  s.s_suppkey,\n  s.s_name,\n  s.s_address,\n  s.s_phone,\n  r.total_revenue\nfrom\n  tpch.supplier s,\n  revenue0 r\nwhere\n  s.s_suppkey = r.supplier_no\n  and r.total_revenue = (\n    select\n      max(total_revenue)\n    from\n      revenue0\n  )\norder by\n  s.s_suppkey", "select\n  p.p_brand,\n  p.p_type,\n  p.p_size,\n  count(distinct ps.ps_suppkey) as supplier_cnt\nfrom\n  tpch.partsupp ps,\n  tpch.part p\nwhere\n  p.p_partkey = ps.ps_partkey\n  and p.p_brand <> 'Brand#21'\n  and p.p_type not like 'MEDIUM PLATED%'\n  and p.p_size in (38, 2, 8, 31, 44, 5, 14, 24)\n  and ps.ps_suppkey not in (\n    select\n      s_suppkey\n    from\n      tpch.supplier\n    where\n      s_comment like '%Customer%Complaints%'\n  )\ngroup by\n  p.p_brand,\n  p.p_type,\n  p.p_size\norder by\n  supplier_cnt desc,\n  p.p_brand,\n  p.p_type,\n  p.p_size", "select\n  sum(l.l_extendedprice) / 7.0 as avg_yearly\nfrom\n  tpch.lineitem l,\n  tpch.part p\nwhere\n  p.p_partkey = l.l_partkey\n  and p.p_brand = 'Brand#13'\n  and p.p_container = 'JUMBO CAN'\n  and l.l_quantity < (\n    select\n      0.2 * avg(l2.l_quantity)\n    from\n      tpch.lineitem l2\n    where\n      l2.l_partkey = p.p_partkey\n  )", "select\n  c.c_name,\n  c.c_custkey,\n  o.o_orderkey,\n  o.o_orderdate,\n  o.o_totalprice,\n  sum(l.l_quantity)\nfrom\n  tpch.customer c,\n  tpch.orders o,\n  tpch.lineitem l\nwhere\n  o.o_orderkey in (\n    select\n      l_orderkey\n    from\n      tpch.lineitem\n    group by\n      l_orderkey having\n        sum(l_quantity) > 313\n  )\n  and c.c_custkey = o.o_custkey\n  and o.o_orderkey = l.l_orderkey\ngroup by\n  c.c_name,\n  c.c_custkey,\n  o.o_orderkey,\n  o.o_orderdate,\n  o.o_totalprice\norder by\n  o.o_totalprice desc,\n  o.o_orderdate\nlimit 100", "select\n  sum(l.l_extendedprice* (1 - l.l_discount)) as revenue\nfrom\n  tpch.lineitem l,\n  tpch.part p\nwhere\n  (\n    p.p_partkey = l.l_partkey\n    and p.p_brand = 'Brand#41'\n    and p.p_container in ('SM CASE', 'SM BOX', 'SM PACK', 'SM PKG')\n    and l.l_quantity >= 2 and l.l_quantity <= 2 + 10\n    and p.p_size between 1 and 5\n    and l.l_shipmode in ('AIR', 'AIR REG')\n    and l.l_shipinstruct = 'DELIVER IN PERSON'\n  )\n  or\n  (\n    p.p_partkey = l.l_partkey\n    and p.p_brand = 'Brand#13'\n    and p.p_container in ('MED BAG', 'MED BOX', 'MED PKG', 'MED PACK')\n    and l.l_quantity >= 14 and l.l_quantity <= 14 + 10\n    and p.p_size between 1 and 10\n    and l.l_shipmode in ('AIR', 'AIR REG')\n    and l.l_shipinstruct = 'DELIVER IN PERSON'\n  )\n  or\n  (\n    p.p_partkey = l.l_partkey\n    and p.p_brand = 'Brand#55'\n    and p.p_container in ('LG CASE', 'LG BOX', 'LG PACK', 'LG PKG')\n    and l.l_quantity >= 23 and l.l_quantity <= 23 + 10\n    and p.p_size between 1 and 15\n    and l.l_shipmode in ('AIR', 'AIR REG')\n    and l.l_shipinstruct = 'DELIVER IN PERSON'\n  )", "select\n  s.s_name,\n  s.s_address\nfrom\n  tpch.supplier s,\n  tpch.nation n\nwhere\n  s.s_suppkey in (\n    select\n      ps.ps_suppkey\n    from\n      tpch.partsupp ps\n    where\n      ps. ps_partkey in (\n        select\n          p.p_partkey\n        from\n          tpch.part p\n        where\n          p.p_name like 'antique%'\n      )\n      and ps.ps_availqty > (\n        select\n          0.5 * sum(l.l_quantity)\n        from\n          tpch.lineitem l\n        where\n          l.l_partkey = ps.ps_partkey\n          and l.l_suppkey = ps.ps_suppkey\n          and l.l_shipdate >= date '1993-01-01'\n          and l.l_shipdate < date '1993-01-01' + interval '1' year\n      )\n  )\n  and s.s_nationkey = n.n_nationkey\n  and n.n_name = 'KENYA'\norder by\n  s.s_name", "select\n  s.s_name,\n  count(*) as numwait\nfrom\n  tpch.supplier s,\n  tpch.lineitem l1,\n  tpch.orders o,\n  tpch.nation n\nwhere\n  s.s_suppkey = l1.l_suppkey\n  and o.o_orderkey = l1.l_orderkey\n  and o.o_orderstatus = 'F'\n  and l1.l_receiptdate > l1.l_commitdate\n  and exists (\n    select\n      *\n    from\n      tpch.lineitem l2\n    where\n      l2.l_orderkey = l1.l_orderkey\n      and l2.l_suppkey <> l1.l_suppkey\n  )\n  and not exists (\n    select\n      *\n    from\n      tpch.lineitem l3\n    where\n      l3.l_orderkey = l1.l_orderkey\n      and l3.l_suppkey <> l1.l_suppkey\n      and l3.l_receiptdate > l3.l_commitdate\n  )\n  and s.s_nationkey = n.n_nationkey\n  and n.n_name = 'BRAZIL'\ngroup by\n  s.s_name\norder by\n  numwait desc,\n  s.s_name\nlimit 100", "select\n  cntrycode,\n  count(*) as numcust,\n  sum(c_acctbal) as totacctbal\nfrom\n  (\n    select\n      substring(c_phone from 1 for 2) as cntrycode,\n      c_acctbal\n    from\n      tpch.customer c\n    where\n      substring(c_phone from 1 for 2) in\n        ('24', '31', '11', '16', '21', '20', '34')\n      and c_acctbal > (\n        select\n          avg(c_acctbal)\n        from\n          tpch.customer\n        where\n          c_acctbal > 0.00\n          and substring(c_phone from 1 for 2) in\n            ('24', '31', '11', '16', '21', '20', '34')\n      )\n      and not exists (\n        select\n          *\n        from\n          tpch.orders o\n        where\n          o.o_custkey = c.c_custkey\n      )\n  ) as custsale\ngroup by\n  cntrycode\norder by\n  cntrycode"};

    private static String schema(String name, String scaleFactor) {
        return "     {\n       type: 'custom',\n       name: '" + name + "',\n" + "       factory: 'net.hydromatic.optiq.impl.tpch.TpchSchemaFactory',\n" + "       operand: {\n" + "         columnPrefix: true,\n" + "         scale: " + scaleFactor + "\n" + "       }\n" + "     }";
    }

    @Test
    public void testRegion() {
        this.with().query("select * from tpch.region").returnsUnordered(new String[]{"R_REGIONKEY=0; R_NAME=AFRICA; R_COMMENT=lar deposits. blithely final packages cajole. regular waters are final requests. regular accounts are according to ", "R_REGIONKEY=1; R_NAME=AMERICA; R_COMMENT=hs use ironic, even requests. s", "R_REGIONKEY=2; R_NAME=ASIA; R_COMMENT=ges. thinly even pinto beans ca", "R_REGIONKEY=3; R_NAME=EUROPE; R_COMMENT=ly final courts cajole furiously final excuse", "R_REGIONKEY=4; R_NAME=MIDDLE EAST; R_COMMENT=uickly special accounts cajole carefully blithely close requests. carefully final asymptotes haggle furiousl"});
    }

    @Test
    public void testLineItem() {
        this.with().query("select * from tpch.lineitem").returnsCount(6001215);
    }

    @Test
    public void testOrders() {
        this.with().query("select * from tpch.orders").returnsCount(1500000);
    }

    @Test
    public void testCustomer() {
        this.with().query("select * from tpch.customer").returnsCount(150000);
    }

    private OptiqAssert.AssertThat with() {
        return OptiqAssert.that().withModel(TPCH_MODEL).enable(OptiqAssert.ENABLE_SLOW);
    }

    @Test
    public void testCustomer5() {
        this.with().query("select * from tpch_5.customer").returnsCount(750000);
    }

    @Test
    public void testQuery01() {
        this.checkQuery(1);
    }

    @Ignore(value="CannotPlanException")
    @Test
    public void testQuery02() {
        this.checkQuery(2);
    }

    @Ignore(value="RelDecorrelator leaves a CorrelatorRel behind")
    @Test
    public void testQuery02Conversion() {
        this.query(2).convertMatches((Function1)new Function1<RelNode, Void>(){

            public Void apply(RelNode relNode) {
                String s = RelOptUtil.toString((RelNode)relNode);
                Assert.assertThat((Object)s, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"CorrelatorRel")));
                return null;
            }
        });
    }

    @Test
    public void testQuery03() {
        this.checkQuery(3);
    }

    @Ignore(value="NoSuchMethodException: SqlFunctions.lt(Date, Date)")
    @Test
    public void testQuery04() {
        this.checkQuery(4);
    }

    @Ignore(value="OutOfMemoryError")
    @Test
    public void testQuery05() {
        this.checkQuery(5);
    }

    @Test
    public void testQuery06() {
        this.checkQuery(6);
    }

    @Ignore(value="slow")
    @Test
    public void testQuery07() {
        this.checkQuery(7);
    }

    @Ignore(value="slow")
    @Test
    public void testQuery08() {
        this.checkQuery(8);
    }

    @Ignore(value="no method found")
    @Test
    public void testQuery09() {
        this.checkQuery(9);
    }

    @Test
    public void testQuery10() {
        this.checkQuery(10);
    }

    @Ignore(value="CannotPlanException")
    @Test
    public void testQuery11() {
        this.checkQuery(11);
    }

    @Ignore(value="NoSuchMethodException: SqlFunctions.lt(Date, Date)")
    @Test
    public void testQuery12() {
        this.checkQuery(12);
    }

    @Ignore(value="CannotPlanException")
    @Test
    public void testQuery13() {
        this.checkQuery(13);
    }

    @Test
    public void testQuery14() {
        this.checkQuery(14);
    }

    @Ignore(value="AssertionError")
    @Test
    public void testQuery15() {
        this.checkQuery(15);
    }

    @Test
    public void testQuery16() {
        this.checkQuery(16);
    }

    @Ignore(value="slow")
    @Test
    public void testQuery17() {
        this.checkQuery(17);
    }

    @Test
    public void testQuery18() {
        this.checkQuery(18);
    }

    @Test
    public void testQuery19() {
        this.checkQuery(19);
    }

    @Test
    public void testQuery20() {
        this.checkQuery(20);
    }

    @Ignore(value="slow")
    @Test
    public void testQuery21() {
        this.checkQuery(21);
    }

    @Ignore(value="IllegalArgumentException during decorrelation")
    @Test
    public void testQuery22() {
        this.checkQuery(22);
    }

    private void checkQuery(int i) {
        this.query(i).runs();
    }

    private OptiqAssert.AssertQuery query(int i) {
        return this.with().query(QUERIES[i - 1].replaceAll("tpch\\.", "tpch_01."));
    }
}

