/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.mongodb;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.hydromatic.optiq.impl.mongodb.MongoRel;
import net.hydromatic.optiq.impl.mongodb.MongoRules;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.util.JsonBuilder;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoFilterRel
extends FilterRelBase
implements MongoRel {
    public MongoFilterRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode condition) {
        super(cluster, traitSet, child, condition);
        assert (this.getConvention() == MongoRel.CONVENTION);
        assert (this.getConvention() == child.getConvention());
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return super.computeSelfCost(planner).multiplyBy(0.1);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new MongoFilterRel(this.getCluster(), traitSet, (RelNode)MongoFilterRel.sole(inputs), this.condition);
    }

    @Override
    public void implement(MongoRel.Implementor implementor) {
        implementor.visitChild(0, this.getChild());
        Translator translator = new Translator(MongoRules.mongoFieldNames(this.getRowType()));
        String match = translator.translateMatch(this.condition);
        implementor.add(null, match);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Translator {
        final JsonBuilder builder = new JsonBuilder();
        final Multimap<String, Pair<String, RexLiteral>> multimap = HashMultimap.create();
        final Map<String, RexLiteral> eqMap = new LinkedHashMap<String, RexLiteral>();
        private final List<String> fieldNames;

        Translator(List<String> fieldNames) {
            this.fieldNames = fieldNames;
        }

        private String translateMatch(RexNode condition) {
            Map map = this.builder.map();
            map.put("$match", this.translateOr(condition));
            return this.builder.toJsonString((Object)map);
        }

        private Object translateOr(RexNode condition) {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            for (RexNode node : RelOptUtil.disjunctions((RexNode)condition)) {
                list.add(this.translateAnd(node));
            }
            switch (list.size()) {
                case 1: {
                    return list.get(0);
                }
            }
            Map map = this.builder.map();
            map.put("$or", list);
            return map;
        }

        private Map<String, Object> translateAnd(RexNode node0) {
            this.eqMap.clear();
            this.multimap.clear();
            for (RexNode node : RelOptUtil.conjunctions((RexNode)node0)) {
                this.translateMatch2(node);
            }
            Map map = this.builder.map();
            for (Map.Entry<String, RexLiteral> entry : this.eqMap.entrySet()) {
                this.multimap.removeAll((Object)entry.getKey());
                map.put(entry.getKey(), Translator.literalToString(entry.getValue()));
            }
            for (Map.Entry<String, Object> entry : this.multimap.asMap().entrySet()) {
                Map map2 = this.builder.map();
                for (Pair s : (Collection)entry.getValue()) {
                    map2.put(s.left, Translator.literalToString((RexLiteral)s.right));
                }
                map.put(entry.getKey(), map2);
            }
            return map;
        }

        private static Object literalToString(RexLiteral literal) {
            return literal.getValue2();
        }

        private Void translateMatch2(RexNode node) {
            switch (node.getKind()) {
                case EQUALS: {
                    return this.translateBinary(null, null, (RexCall)node);
                }
                case LESS_THAN: {
                    return this.translateBinary("$lt", "$gt", (RexCall)node);
                }
                case LESS_THAN_OR_EQUAL: {
                    return this.translateBinary("$lte", "$gte", (RexCall)node);
                }
                case NOT_EQUALS: {
                    return this.translateBinary("$ne", "$ne", (RexCall)node);
                }
                case GREATER_THAN: {
                    return this.translateBinary("$gt", "$lt", (RexCall)node);
                }
                case GREATER_THAN_OR_EQUAL: {
                    return this.translateBinary("$gte", "$lte", (RexCall)node);
                }
            }
            throw new AssertionError((Object)("cannot translate " + node));
        }

        private Void translateBinary(String op, String rop, RexCall call) {
            RexNode right;
            RexNode left = (RexNode)call.operands.get(0);
            boolean b = this.translateBinary2(op, left, right = (RexNode)call.operands.get(1));
            if (b) {
                return null;
            }
            b = this.translateBinary2(rop, right, left);
            if (b) {
                return null;
            }
            throw new AssertionError((Object)("cannot translate op " + op + " call " + call));
        }

        private boolean translateBinary2(String op, RexNode left, RexNode right) {
            switch (right.getKind()) {
                case LITERAL: {
                    break;
                }
                default: {
                    return false;
                }
            }
            RexLiteral rightLiteral = (RexLiteral)right;
            switch (left.getKind()) {
                case INPUT_REF: {
                    RexInputRef left1 = (RexInputRef)left;
                    String name = this.fieldNames.get(left1.getIndex());
                    this.translateOp2(op, name, rightLiteral);
                    return true;
                }
                case CAST: {
                    return this.translateBinary2(op, (RexNode)((RexCall)left).operands.get(0), right);
                }
                case OTHER_FUNCTION: {
                    String itemName = MongoRules.isItem((RexCall)left);
                    if (itemName == null) break;
                    this.translateOp2(op, itemName, rightLiteral);
                    return true;
                }
            }
            return false;
        }

        private void translateOp2(String op, String name, RexLiteral right) {
            if (op == null) {
                this.eqMap.put(name, right);
            } else {
                this.multimap.put((Object)name, (Object)Pair.of((Object)op, (Object)right));
            }
        }
    }
}

