/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.mongodb;

import java.util.List;
import net.hydromatic.optiq.impl.mongodb.MongoRel;
import net.hydromatic.optiq.impl.mongodb.MongoRules;
import net.hydromatic.optiq.impl.mongodb.MongoTable;
import net.hydromatic.optiq.impl.mongodb.MongoToEnumerableConverterRule;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.TableAccessRelBase;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoTableScan
extends TableAccessRelBase
implements MongoRel {
    final MongoTable mongoTable;
    final RelDataType projectRowType;

    protected MongoTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, MongoTable mongoTable, RelDataType projectRowType) {
        super(cluster, traitSet, table);
        this.mongoTable = mongoTable;
        this.projectRowType = projectRowType;
        assert (mongoTable != null);
        assert (this.getConvention() == MongoRel.CONVENTION);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return this;
    }

    public RelDataType deriveRowType() {
        return this.projectRowType != null ? this.projectRowType : super.deriveRowType();
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        float f = this.projectRowType == null ? 1.0f : (float)this.projectRowType.getFieldCount() / 100.0f;
        return super.computeSelfCost(planner).multiplyBy(0.1 * (double)f);
    }

    public void register(RelOptPlanner planner) {
        planner.addRule((RelOptRule)MongoToEnumerableConverterRule.INSTANCE);
        for (RelOptRule rule : MongoRules.RULES) {
            planner.addRule(rule);
        }
    }

    @Override
    public void implement(MongoRel.Implementor implementor) {
        implementor.mongoTable = this.mongoTable;
        implementor.table = this.table;
    }
}

