/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.avatica;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.hydromatic.avatica.ColumnMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayImpl
implements Array {
    private final ColumnMetaData.AvaticaType elementType;
    private final Factory factory;
    private final List list;

    public ArrayImpl(List list, ColumnMetaData.AvaticaType elementType, Factory factory) {
        this.list = list;
        this.elementType = elementType;
        this.factory = factory;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.elementType.typeName;
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.elementType.type;
    }

    @Override
    public Object getArray() throws SQLException {
        return this.getArray(this.list);
    }

    protected Object getArray(List list) throws SQLException {
        int i = 0;
        switch (this.elementType.representation) {
            case PRIMITIVE_DOUBLE: {
                double[] doubles = new double[list.size()];
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    double v = (Double)iterator.next();
                    doubles[i++] = v;
                }
                return doubles;
            }
            case PRIMITIVE_FLOAT: {
                float[] floats = new float[list.size()];
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    float v = ((Float)iterator.next()).floatValue();
                    floats[i++] = v;
                }
                return floats;
            }
            case PRIMITIVE_INT: {
                int[] ints = new int[list.size()];
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    int v = (Integer)iterator.next();
                    ints[i++] = v;
                }
                return ints;
            }
            case PRIMITIVE_LONG: {
                long[] longs = new long[list.size()];
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    long v = (Long)iterator.next();
                    longs[i++] = v;
                }
                return longs;
            }
            case PRIMITIVE_SHORT: {
                short[] shorts = new short[list.size()];
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    short v = (Short)iterator.next();
                    shorts[i++] = v;
                }
                return shorts;
            }
            case PRIMITIVE_BOOLEAN: {
                boolean[] booleans = new boolean[list.size()];
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    boolean v = (Boolean)iterator.next();
                    booleans[i++] = v;
                }
                return booleans;
            }
            case PRIMITIVE_BYTE: {
                byte[] bytes = new byte[list.size()];
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    byte v = (Byte)iterator.next();
                    bytes[i++] = v;
                }
                return bytes;
            }
            case PRIMITIVE_CHAR: {
                char[] chars = new char[list.size()];
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    char v = ((Character)iterator.next()).charValue();
                    chars[i++] = v;
                }
                return chars;
            }
        }
        Object[] objects = list.toArray();
        switch (this.elementType.type) {
            case 2003: {
                ColumnMetaData.ArrayType arrayType = (ColumnMetaData.ArrayType)this.elementType;
                i = 0;
                while (i < objects.length) {
                    objects[i] = new ArrayImpl((List)objects[i], arrayType.component, this.factory);
                    ++i;
                }
                break;
            }
        }
        return objects;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        return this.getArray(this.list.subList((int)index, count));
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.factory.create(this.elementType, this.list);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void free() throws SQLException {
    }

    public static interface Factory {
        public ResultSet create(ColumnMetaData.AvaticaType var1, Iterable var2);
    }
}

