/*
 * Decompiled with CFR 0.152.
 */
package parquet.thrift;

import com.twitter.data.proto.tutorial.thrift.AddressBook;
import com.twitter.data.proto.tutorial.thrift.Name;
import com.twitter.data.proto.tutorial.thrift.Person;
import com.twitter.data.proto.tutorial.thrift.PhoneNumber;
import com.twitter.data.proto.tutorial.thrift.PhoneType;
import com.twitter.elephantbird.thrift.test.TestMap;
import com.twitter.elephantbird.thrift.test.TestName;
import com.twitter.elephantbird.thrift.test.TestNameList;
import com.twitter.elephantbird.thrift.test.TestNameSet;
import com.twitter.elephantbird.thrift.test.TestPerson;
import com.twitter.elephantbird.thrift.test.TestStructInMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.junit.Assert;
import org.junit.Test;
import parquet.Log;
import parquet.column.ColumnWriteStore;
import parquet.column.ParquetProperties;
import parquet.column.impl.ColumnWriteStoreV1;
import parquet.column.page.PageReadStore;
import parquet.column.page.PageWriteStore;
import parquet.column.page.mem.MemPageStore;
import parquet.io.ColumnIOFactory;
import parquet.io.MessageColumnIO;
import parquet.io.RecordReader;
import parquet.io.api.RecordConsumer;
import parquet.io.api.RecordMaterializer;
import parquet.schema.MessageType;
import parquet.thrift.ParquetWriteProtocol;
import parquet.thrift.TBaseRecordConverter;
import parquet.thrift.ThriftSchemaConverter;
import parquet.thrift.struct.ThriftType;
import thrift.test.OneOfEach;

public class TestParquetReadProtocol {
    private static final Log LOG = Log.getLog(TestParquetReadProtocol.class);

    @Test
    public void testList() throws TException {
        ArrayList<String> names = new ArrayList<String>();
        names.add("John");
        names.add("Jack");
        TestNameList o = new TestNameList("name", names);
        this.validate(o);
    }

    @Test
    public void testSet() throws TException {
        HashSet<String> names = new HashSet<String>();
        names.add("John");
        names.add("Jack");
        TestNameSet o = new TestNameSet("name", names);
        this.validate(o);
    }

    @Test
    public void testReadEmpty() throws Exception {
        AddressBook expected = new AddressBook();
        this.validate(expected);
    }

    @Test
    public void testOneOfEach() throws TException {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        bytes.add((byte)1);
        ArrayList<Short> shorts = new ArrayList<Short>();
        shorts.add((short)1);
        ArrayList<Long> longs = new ArrayList<Long>();
        longs.add(1L);
        OneOfEach a = new OneOfEach(true, false, 8, 16, 32, 64L, 1234.0, "string", "\u00e5", false, ByteBuffer.wrap("a".getBytes()), bytes, shorts, longs);
        this.validate(a);
    }

    @Test
    public void testRead() throws Exception {
        PhoneNumber phoneNumber = new PhoneNumber("5555555555");
        phoneNumber.type = PhoneType.MOBILE;
        List<Person> persons = Arrays.asList(new Person(new Name("john", "johson"), 1, "john@johnson.org", Arrays.asList(phoneNumber)), new Person(new Name("jack", "jackson"), 2, "jack@jackson.org", Arrays.asList(new PhoneNumber("5555555556"))));
        AddressBook expected = new AddressBook(persons);
        this.validate(expected);
    }

    @Test
    public void testMap() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        TestMap testMap = new TestMap("map_name", map);
        this.validate(testMap);
    }

    @Test
    public void testStructInMap() throws Exception {
        HashMap<String, TestPerson> map = new HashMap<String, TestPerson>();
        map.put("foo", new TestPerson(new TestName("john", "johnson"), new HashMap()));
        Map<String, Integer> stringToIntMap = Collections.singletonMap("bar", 10);
        TestStructInMap testMap = new TestStructInMap("map_name", map, stringToIntMap);
        this.validate(testMap);
    }

    private <T extends TBase<?, ?>> void validate(T expected) throws TException {
        Class<?> thriftClass = expected.getClass();
        MemPageStore memPageStore = new MemPageStore(1L);
        ThriftSchemaConverter schemaConverter = new ThriftSchemaConverter();
        MessageType schema = schemaConverter.convert(thriftClass);
        LOG.info((Object)schema);
        MessageColumnIO columnIO = new ColumnIOFactory(true).getColumnIO(schema);
        ColumnWriteStoreV1 columns = new ColumnWriteStoreV1((PageWriteStore)memPageStore, 10000, 10000, 10000, false, ParquetProperties.WriterVersion.PARQUET_1_0);
        RecordConsumer recordWriter = columnIO.getRecordWriter((ColumnWriteStore)columns);
        ThriftType.StructType thriftType = schemaConverter.toStructType(thriftClass);
        ParquetWriteProtocol parquetWriteProtocol = new ParquetWriteProtocol(recordWriter, columnIO, thriftType);
        expected.write((TProtocol)parquetWriteProtocol);
        columns.flush();
        TBaseRecordConverter converter = new TBaseRecordConverter(thriftClass, schema, thriftType);
        RecordReader recordReader = columnIO.getRecordReader((PageReadStore)memPageStore, (RecordMaterializer)converter);
        TBase result = (TBase)recordReader.read();
        Assert.assertEquals(expected, (Object)result);
    }
}

