/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.thrift;

import com.twitter.data.proto.tutorial.thrift.AddressBook;
import com.twitter.data.proto.tutorial.thrift.Name;
import com.twitter.data.proto.tutorial.thrift.Person;
import com.twitter.data.proto.tutorial.thrift.PhoneNumber;
import com.twitter.elephantbird.thrift.test.TestListInMap;
import com.twitter.elephantbird.thrift.test.TestMapInList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.junit.Assert;
import org.junit.Test;
import parquet.Log;
import parquet.column.statistics.BinaryStatistics;
import parquet.column.statistics.BooleanStatistics;
import parquet.column.statistics.DoubleStatistics;
import parquet.column.statistics.IntStatistics;
import parquet.column.statistics.LongStatistics;
import parquet.column.statistics.Statistics;
import parquet.example.data.Group;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.ParquetReader;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.example.GroupReadSupport;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.hadoop.thrift.ThriftToParquetFileWriter;
import parquet.hadoop.util.ContextUtil;
import parquet.io.api.Binary;
import parquet.schema.MessageType;
import parquet.thrift.test.RequiredPrimitiveFixture;
import parquet.thrift.test.TestListsInMap;

public class TestThriftToParquetFileWriter {
    private static final Log LOG = Log.getLog(TestThriftToParquetFileWriter.class);

    @Test
    public void testWriteFile() throws IOException, InterruptedException, TException {
        AddressBook a = new AddressBook(Arrays.asList(new Person(new Name("Bob", "Roberts"), 0, "bob.roberts@example.com", Arrays.asList(new PhoneNumber("1234567890")))));
        Path fileToCreate = this.createFile((TBase[])new AddressBook[]{a});
        ParquetReader<Group> reader = this.createRecordReader(fileToCreate);
        Group g = null;
        int i = 0;
        while ((g = (Group)reader.read()) != null) {
            Assert.assertEquals((long)a.persons.size(), (long)g.getFieldRepetitionCount("persons"));
            Assert.assertEquals((Object)((Person)a.persons.get((int)0)).email, (Object)g.getGroup("persons", 0).getGroup(0, 0).getString("email", 0));
            ++i;
        }
        Assert.assertEquals((String)"read 1 record", (long)1L, (long)i);
    }

    @Test
    public void testWriteStatistics() throws Exception {
        IntStatistics intStatsSmall = new IntStatistics();
        intStatsSmall.setMinMax(2, 100);
        LongStatistics longStatsSmall = new LongStatistics();
        longStatsSmall.setMinMax(-17L, 287L);
        DoubleStatistics doubleStatsSmall = new DoubleStatistics();
        doubleStatsSmall.setMinMax(-15.55, 9.63);
        BinaryStatistics binaryStatsSmall = new BinaryStatistics();
        binaryStatsSmall.setMinMax(Binary.fromString((String)"as"), Binary.fromString((String)"world"));
        BooleanStatistics boolStats = new BooleanStatistics();
        boolStats.setMinMax(false, true);
        Path p = this.createFile(new RequiredPrimitiveFixture[]{new RequiredPrimitiveFixture(false, 32, 32, 2, 90L, -15.55, "as"), new RequiredPrimitiveFixture(false, 100, 100, 100, 287L, -9.0, "world"), new RequiredPrimitiveFixture(true, 2, 2, 9, -17L, 9.63, "hello")});
        Configuration configuration = new Configuration();
        FileSystem fs = p.getFileSystem(configuration);
        FileStatus fileStatus = fs.getFileStatus(p);
        ParquetMetadata footer = ParquetFileReader.readFooter((Configuration)configuration, (Path)p);
        for (BlockMetaData bmd : footer.getBlocks()) {
            for (ColumnChunkMetaData cmd : bmd.getColumns()) {
                switch (cmd.getType()) {
                    case INT32: {
                        Assert.assertTrue((boolean)intStatsSmall.equals((Statistics)((IntStatistics)cmd.getStatistics())));
                        break;
                    }
                    case INT64: {
                        Assert.assertTrue((boolean)longStatsSmall.equals((Statistics)((LongStatistics)cmd.getStatistics())));
                        break;
                    }
                    case DOUBLE: {
                        Assert.assertTrue((boolean)doubleStatsSmall.equals((Statistics)((DoubleStatistics)cmd.getStatistics())));
                        break;
                    }
                    case BOOLEAN: {
                        Assert.assertTrue((boolean)boolStats.equals((Statistics)((BooleanStatistics)cmd.getStatistics())));
                        break;
                    }
                    case BINARY: {
                        if (cmd.getPath().toString() != "[test_string]") break;
                        Assert.assertTrue((boolean)binaryStatsSmall.equals((Statistics)((BinaryStatistics)cmd.getStatistics())));
                    }
                }
            }
        }
        IntStatistics intStatsLarge = new IntStatistics();
        intStatsLarge.setMinMax(-2147483647, Integer.MAX_VALUE);
        LongStatistics longStatsLarge = new LongStatistics();
        longStatsLarge.setMinMax(-9223372036854775807L, Long.MAX_VALUE);
        DoubleStatistics doubleStatsLarge = new DoubleStatistics();
        doubleStatsLarge.setMinMax(-1.7976931348623157E308, Double.MAX_VALUE);
        BinaryStatistics binaryStatsLarge = new BinaryStatistics();
        binaryStatsLarge.setMinMax(Binary.fromString((String)"some small string"), Binary.fromString((String)"some very large string here to test in this function"));
        Path p_large = this.createFile(new RequiredPrimitiveFixture[]{new RequiredPrimitiveFixture(false, 2, 32, -2147483647, -9223372036854775807L, -1.7976931348623157E308, "some small string"), new RequiredPrimitiveFixture(false, 100, 100, Integer.MAX_VALUE, Long.MAX_VALUE, Double.MAX_VALUE, "some very large string here to test in this function"), new RequiredPrimitiveFixture(true, 2, 2, 9, -17L, 9.63, "hello")});
        Configuration configuration_large = new Configuration();
        FileSystem fs_large = p_large.getFileSystem(configuration_large);
        FileStatus fileStatus_large = fs_large.getFileStatus(p_large);
        ParquetMetadata footer_large = ParquetFileReader.readFooter((Configuration)configuration_large, (Path)p_large);
        for (BlockMetaData bmd : footer_large.getBlocks()) {
            for (ColumnChunkMetaData cmd : bmd.getColumns()) {
                switch (cmd.getType()) {
                    case INT32: {
                        if (cmd.getPath().toString() != "[test_i32]") break;
                        Assert.assertTrue((boolean)intStatsLarge.equals((Statistics)((IntStatistics)cmd.getStatistics())));
                        break;
                    }
                    case INT64: {
                        Assert.assertTrue((boolean)longStatsLarge.equals((Statistics)((LongStatistics)cmd.getStatistics())));
                        break;
                    }
                    case DOUBLE: {
                        Assert.assertTrue((boolean)doubleStatsLarge.equals((Statistics)((DoubleStatistics)cmd.getStatistics())));
                        break;
                    }
                    case BOOLEAN: {
                        Assert.assertTrue((boolean)boolStats.equals((Statistics)((BooleanStatistics)cmd.getStatistics())));
                        break;
                    }
                    case BINARY: {
                        if (cmd.getPath().toString() != "[test_string]") break;
                        Assert.assertTrue((boolean)binaryStatsLarge.equals((Statistics)((BinaryStatistics)cmd.getStatistics())));
                    }
                }
            }
        }
    }

    @Test
    public void testWriteFileListOfMap() throws IOException, InterruptedException, TException {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("key11", "value11");
        map1.put("key12", "value12");
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("key21", "value21");
        TestMapInList listMap = new TestMapInList("listmap", Arrays.asList(map1, map2));
        Path fileToCreate = this.createFile((TBase[])new TestMapInList[]{listMap});
        ParquetReader<Group> reader = this.createRecordReader(fileToCreate);
        Group g = null;
        while ((g = (Group)reader.read()) != null) {
            Assert.assertEquals((long)listMap.names.size(), (long)g.getGroup("names", 0).getFieldRepetitionCount("names_tuple"));
            Assert.assertEquals((long)((Map)listMap.names.get(0)).size(), (long)g.getGroup("names", 0).getGroup("names_tuple", 0).getFieldRepetitionCount("map"));
            Assert.assertEquals((long)((Map)listMap.names.get(1)).size(), (long)g.getGroup("names", 0).getGroup("names_tuple", 1).getFieldRepetitionCount("map"));
        }
    }

    @Test
    public void testWriteFileMapOfList() throws IOException, InterruptedException, TException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("key", Arrays.asList("val1", "val2"));
        TestListInMap mapList = new TestListInMap("maplist", map);
        Path fileToCreate = this.createFile((TBase[])new TestListInMap[]{mapList});
        ParquetReader<Group> reader = this.createRecordReader(fileToCreate);
        Group g = null;
        while ((g = (Group)reader.read()) != null) {
            Assert.assertEquals((Object)"key", (Object)g.getGroup("names", 0).getGroup("map", 0).getBinary("key", 0).toStringUsingUTF8());
            Assert.assertEquals((long)((List)map.get("key")).size(), (long)g.getGroup("names", 0).getGroup("map", 0).getGroup("value", 0).getFieldRepetitionCount(0));
        }
    }

    @Test
    public void testWriteFileMapOfLists() throws IOException, InterruptedException, TException {
        HashMap<List<String>, List<String>> map = new HashMap<List<String>, List<String>>();
        map.put(Arrays.asList("key1", "key2"), Arrays.asList("val1", "val2"));
        TestListsInMap mapList = new TestListsInMap("maplists", map);
        Path fileToCreate = this.createFile(new TestListsInMap[]{mapList});
        ParquetReader<Group> reader = this.createRecordReader(fileToCreate);
        Group g = null;
        while ((g = (Group)reader.read()) != null) {
            Assert.assertEquals((Object)"key1", (Object)g.getGroup("names", 0).getGroup("map", 0).getGroup("key", 0).getBinary("key_tuple", 0).toStringUsingUTF8());
            Assert.assertEquals((Object)"key2", (Object)g.getGroup("names", 0).getGroup("map", 0).getGroup("key", 0).getBinary("key_tuple", 1).toStringUsingUTF8());
            Assert.assertEquals((Object)"val1", (Object)g.getGroup("names", 0).getGroup("map", 0).getGroup("value", 0).getBinary("value_tuple", 0).toStringUsingUTF8());
            Assert.assertEquals((Object)"val2", (Object)g.getGroup("names", 0).getGroup("map", 0).getGroup("value", 0).getBinary("value_tuple", 1).toStringUsingUTF8());
        }
    }

    private ParquetReader<Group> createRecordReader(Path parquetFilePath) throws IOException {
        Configuration configuration = new Configuration(true);
        GroupReadSupport readSupport = new GroupReadSupport();
        ParquetMetadata readFooter = ParquetFileReader.readFooter((Configuration)configuration, (Path)parquetFilePath);
        MessageType schema = readFooter.getFileMetaData().getSchema();
        readSupport.init(configuration, null, schema);
        return new ParquetReader(parquetFilePath, (ReadSupport)readSupport);
    }

    private <T extends TBase<?, ?>> Path createFile(T ... tObjs) throws IOException, InterruptedException, TException {
        Path fileToCreate = new Path("target/test/TestThriftToParquetFileWriter/" + tObjs[0].getClass() + ".parquet");
        LOG.info((Object)("File created: " + fileToCreate.toString()));
        Configuration conf = new Configuration();
        FileSystem fs = fileToCreate.getFileSystem(conf);
        if (fs.exists(fileToCreate)) {
            fs.delete(fileToCreate, true);
        }
        TCompactProtocol.Factory protocolFactory = new TCompactProtocol.Factory();
        TaskAttemptID taskId = new TaskAttemptID("local", 0, true, 0, 0);
        ThriftToParquetFileWriter w = new ThriftToParquetFileWriter(fileToCreate, ContextUtil.newTaskAttemptContext((Configuration)conf, (TaskAttemptID)taskId), (TProtocolFactory)protocolFactory, tObjs[0].getClass());
        for (T tObj : tObjs) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TProtocol protocol = protocolFactory.getProtocol((TTransport)new TIOStreamTransport((OutputStream)baos));
            tObj.write(protocol);
            w.write(new BytesWritable(baos.toByteArray()));
        }
        w.close();
        return fileToCreate;
    }
}

