/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.thrift;

import com.twitter.data.proto.tutorial.thrift.AddressBook;
import com.twitter.data.proto.tutorial.thrift.Name;
import com.twitter.data.proto.tutorial.thrift.Person;
import com.twitter.data.proto.tutorial.thrift.PhoneNumber;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.thrift.TBase;
import org.junit.Assert;
import org.junit.Test;
import parquet.Log;
import parquet.example.data.Group;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.hadoop.thrift.ParquetThriftInputFormat;
import parquet.hadoop.thrift.ParquetThriftOutputFormat;
import parquet.thrift.test.compat.StructV1;
import parquet.thrift.test.compat.StructV2;
import parquet.thrift.test.compat.StructV3;

public class TestInputOutputFormat {
    private static final Log LOG = Log.getLog(TestInputOutputFormat.class);

    public static AddressBook nextAddressbook(int i) {
        ArrayList<Person> persons = new ArrayList<Person>();
        for (int j = 0; j < i % 3; ++j) {
            ArrayList<PhoneNumber> phones = new ArrayList<PhoneNumber>();
            for (int k = 0; k < i % 4; ++k) {
                phones.add(new PhoneNumber("12345" + i));
            }
            persons.add(new Person(new Name("John" + i, "Roberts"), i, "John@example.com" + i, phones));
        }
        AddressBook a = new AddressBook(persons);
        return a;
    }

    @Test
    public void testReadWrite() throws Exception {
        Configuration conf = new Configuration();
        Path inputPath = new Path("src/test/java/parquet/hadoop/thrift/TestInputOutputFormat.java");
        Path parquetPath = new Path("target/test/thrift/TestInputOutputFormat/parquet");
        Path outputPath = new Path("target/test/thrift/TestInputOutputFormat/out");
        FileSystem fileSystem = parquetPath.getFileSystem(conf);
        fileSystem.delete(parquetPath, true);
        fileSystem.delete(outputPath, true);
        Job job = new Job(conf, "write");
        TextInputFormat.addInputPath((Job)job, (Path)inputPath);
        job.setInputFormatClass(TextInputFormat.class);
        job.setMapperClass(MyMapper.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(ParquetThriftOutputFormat.class);
        ParquetThriftOutputFormat.setCompression((Job)job, (CompressionCodecName)CompressionCodecName.GZIP);
        ParquetThriftOutputFormat.setOutputPath((Job)job, (Path)parquetPath);
        ParquetThriftOutputFormat.setThriftClass((Job)job, AddressBook.class);
        this.waitForJob(job);
        job = new Job(conf, "read");
        job.setInputFormatClass(ParquetThriftInputFormat.class);
        ParquetThriftInputFormat.setInputPaths((Job)job, (Path[])new Path[]{parquetPath});
        job.setMapperClass(MyMapper2.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(TextOutputFormat.class);
        TextOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        this.waitForJob(job);
        BufferedReader out = new BufferedReader(new FileReader(new File(outputPath.toString(), "part-m-00000")));
        String lineOut = null;
        int lineNumber = 0;
        while ((lineOut = out.readLine()) != null) {
            lineOut = lineOut.substring(lineOut.indexOf("\t") + 1);
            AddressBook a = TestInputOutputFormat.nextAddressbook(lineNumber);
            Assert.assertEquals((String)("line " + lineNumber), (Object)a.toString(), (Object)lineOut);
            ++lineNumber;
        }
        Assert.assertNull((String)("line " + lineNumber), (Object)out.readLine());
        out.close();
    }

    @Test
    public void testSchemaEvolution() throws Exception {
        Configuration conf = new Configuration();
        Path inputPath = new Path("target/test/thrift/schema_evolution/in");
        Path parquetPath = new Path("target/test/thrift/schema_evolution/parquet");
        Path outputPath = new Path("target/test/thrift/schema_evolution/out");
        FileSystem fileSystem = parquetPath.getFileSystem(conf);
        fileSystem.delete(inputPath, true);
        FSDataOutputStream in = fileSystem.create(inputPath);
        in.writeUTF("Alice\nBob\nCharles\n");
        in.close();
        fileSystem.delete(parquetPath, true);
        fileSystem.delete(outputPath, true);
        this.write(conf, inputPath, new Path(parquetPath, "V1"), SchemaEvolutionMapper1.class, StructV1.class);
        this.write(conf, inputPath, new Path(parquetPath, "V2"), SchemaEvolutionMapper2.class, StructV2.class);
        this.write(conf, inputPath, new Path(parquetPath, "V3"), SchemaEvolutionMapper3.class, StructV3.class);
        Job job = new Job(conf, "read");
        job.setInputFormatClass(ParquetThriftInputFormat.class);
        ParquetThriftInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(parquetPath, "*")});
        ParquetThriftInputFormat.setThriftClass((Configuration)job.getConfiguration(), StructV3.class);
        job.setMapperClass(SchemaEvolutionReadMapper.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(TextOutputFormat.class);
        TextOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        this.waitForJob(job);
        this.read(outputPath + "/part-m-00000", 3);
        this.read(outputPath + "/part-m-00001", 3);
        this.read(outputPath + "/part-m-00002", 3);
    }

    private void read(String outputPath, int expected) throws FileNotFoundException, IOException {
        BufferedReader out = new BufferedReader(new FileReader(new File(outputPath.toString())));
        String lineOut = null;
        int lineNumber = 0;
        while ((lineOut = out.readLine()) != null) {
            lineOut = lineOut.substring(lineOut.indexOf("\t") + 1);
            System.out.println(lineOut);
            ++lineNumber;
        }
        out.close();
        Assert.assertEquals((long)expected, (long)lineNumber);
    }

    private void write(Configuration conf, Path inputPath, Path parquetPath, Class<? extends Mapper> mapperClass, Class<? extends TBase<?, ?>> outputClass) throws IOException, Exception {
        Job job = new Job(conf, "write");
        TextInputFormat.addInputPath((Job)job, (Path)inputPath);
        job.setInputFormatClass(TextInputFormat.class);
        job.setMapperClass(mapperClass);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(ParquetThriftOutputFormat.class);
        ParquetThriftOutputFormat.setCompression((Job)job, (CompressionCodecName)CompressionCodecName.GZIP);
        ParquetThriftOutputFormat.setOutputPath((Job)job, (Path)parquetPath);
        ParquetThriftOutputFormat.setThriftClass((Job)job, outputClass);
        this.waitForJob(job);
    }

    private void waitForJob(Job job) throws Exception {
        job.submit();
        while (!job.isComplete()) {
            LOG.debug((Object)("waiting for job " + job.getJobName()));
            Thread.sleep(100L);
        }
        LOG.info((Object)("status for job " + job.getJobName() + ": " + (job.isSuccessful() ? "SUCCESS" : "FAILURE")));
        if (!job.isSuccessful()) {
            throw new RuntimeException("job failed " + job.getJobName());
        }
    }

    public static class SchemaEvolutionReadMapper
    extends Mapper<LongWritable, Text, Void, StructV3> {
        protected void map(LongWritable key, StructV3 value, Mapper.Context context) throws IOException, InterruptedException {
            context.write(null, (Object)new Text(value.toString()));
        }
    }

    public static class SchemaEvolutionMapper3
    extends Mapper<LongWritable, Text, Void, StructV3> {
        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            StructV3 s = new StructV3(value.toString() + 3);
            s.setAge("average");
            s.setGender("unavailable");
            context.write(null, (Object)s);
        }
    }

    public static class SchemaEvolutionMapper2
    extends Mapper<LongWritable, Text, Void, StructV2> {
        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            StructV2 s = new StructV2(value.toString() + 2);
            s.setAge("undetermined");
            context.write(null, (Object)s);
        }
    }

    public static class SchemaEvolutionMapper1
    extends Mapper<LongWritable, Text, Void, StructV1> {
        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            context.write(null, (Object)new StructV1(value.toString() + 1));
        }
    }

    public static class MyMapper2
    extends Mapper<Void, Group, LongWritable, Text> {
        protected void map(Void key, AddressBook value, Mapper.Context context) throws IOException, InterruptedException {
            context.write(null, (Object)new Text(value.toString()));
        }
    }

    public static class MyMapper
    extends Mapper<LongWritable, Text, Void, AddressBook> {
        public void run(Mapper.Context context) throws IOException, InterruptedException {
            for (int i = 0; i < 10; ++i) {
                AddressBook a = TestInputOutputFormat.nextAddressbook(i);
                context.write(null, (Object)a);
            }
        }
    }
}

