/*
 * Decompiled with CFR 0.152.
 */
package parquet.thrift.pig;

import com.twitter.elephantbird.pig.util.PigToThrift;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.data.Tuple;
import org.apache.thrift.TBase;
import parquet.hadoop.BadConfigurationException;
import parquet.hadoop.api.WriteSupport;
import parquet.hadoop.thrift.ThriftWriteSupport;
import parquet.io.api.RecordConsumer;

public class TupleToThriftWriteSupport
extends WriteSupport<Tuple> {
    private final String className;
    private ThriftWriteSupport<TBase<?, ?>> thriftWriteSupport;
    private PigToThrift<TBase<?, ?>> pigToThrift;

    public TupleToThriftWriteSupport(String className) {
        this.className = className;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        try {
            Class<TBase> clazz = configuration.getClassByName(this.className).asSubclass(TBase.class);
            this.thriftWriteSupport = new ThriftWriteSupport<TBase>(clazz);
            this.pigToThrift = new PigToThrift(clazz);
            return this.thriftWriteSupport.init(configuration);
        }
        catch (ClassNotFoundException e) {
            throw new BadConfigurationException("The thrift class name was not found: " + this.className, (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new BadConfigurationException("The thrift class name should extend TBase: " + this.className, (Throwable)e);
        }
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.thriftWriteSupport.prepareForWrite(recordConsumer);
    }

    public void write(Tuple t) {
        this.thriftWriteSupport.write(this.pigToThrift.getThriftObject(t));
    }
}

