/*
 * Decompiled with CFR 0.152.
 */
package parquet.thrift;

import java.util.ArrayList;
import java.util.List;
import parquet.schema.ConversionPatterns;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;
import parquet.schema.Types;
import parquet.thrift.projection.FieldProjectionFilter;
import parquet.thrift.projection.FieldsPath;
import parquet.thrift.projection.ThriftProjectionException;
import parquet.thrift.struct.ThriftField;
import parquet.thrift.struct.ThriftType;

public class ThriftSchemaConvertVisitor
implements ThriftType.TypeVisitor {
    FieldProjectionFilter fieldProjectionFilter;
    Type currentType;
    FieldsPath currentFieldPath = new FieldsPath();
    Type.Repetition currentRepetition = Type.Repetition.REPEATED;
    String currentName = "ParquetSchema";

    public ThriftSchemaConvertVisitor(FieldProjectionFilter fieldProjectionFilter) {
        this.fieldProjectionFilter = fieldProjectionFilter;
    }

    @Override
    public void visit(ThriftType.MapType mapType) {
        ThriftField mapKeyField = mapType.getKey();
        ThriftField mapValueField = mapType.getValue();
        String mapName = this.currentName;
        Type.Repetition mapRepetition = this.currentRepetition;
        this.currentFieldPath.push(mapKeyField);
        this.currentName = "key";
        this.currentRepetition = Type.Repetition.REQUIRED;
        mapKeyField.getType().accept(this);
        Type keyType = this.currentType;
        this.currentFieldPath.pop();
        this.currentFieldPath.push(mapValueField);
        this.currentName = "value";
        this.currentRepetition = Type.Repetition.OPTIONAL;
        mapValueField.getType().accept(this);
        Type valueType = this.currentType;
        this.currentFieldPath.pop();
        if (keyType == null && valueType == null) {
            this.currentType = null;
            return;
        }
        if (keyType == null && valueType != null) {
            throw new ThriftProjectionException("key of map is not specified in projection: " + this.currentFieldPath);
        }
        this.currentName = mapName;
        this.currentRepetition = mapRepetition;
        this.currentType = ConversionPatterns.mapType((Type.Repetition)this.currentRepetition, (String)this.currentName, (Type)keyType, (Type)valueType);
    }

    @Override
    public void visit(ThriftType.SetType setType) {
        ThriftField setElemField = setType.getValues();
        String setName = this.currentName;
        Type.Repetition setRepetition = this.currentRepetition;
        this.currentName = this.currentName + "_tuple";
        this.currentRepetition = Type.Repetition.REPEATED;
        setElemField.getType().accept(this);
        if (this.currentType == null) {
            return;
        }
        this.currentType = ConversionPatterns.listType((Type.Repetition)setRepetition, (String)setName, (Type)this.currentType);
    }

    @Override
    public void visit(ThriftType.ListType listType) {
        ThriftField setElemField = listType.getValues();
        String listName = this.currentName;
        Type.Repetition listRepetition = this.currentRepetition;
        this.currentName = this.currentName + "_tuple";
        this.currentRepetition = Type.Repetition.REPEATED;
        setElemField.getType().accept(this);
        if (this.currentType == null) {
            return;
        }
        this.currentType = ConversionPatterns.listType((Type.Repetition)listRepetition, (String)listName, (Type)this.currentType);
    }

    public MessageType getConvertedMessageType() {
        if (this.currentType == null) {
            return new MessageType(this.currentName, new ArrayList());
        }
        GroupType rootType = this.currentType.asGroupType();
        return new MessageType(this.currentName, rootType.getFields());
    }

    @Override
    public void visit(ThriftType.StructType structType) {
        List<ThriftField> fields = structType.getChildren();
        String oldName = this.currentName;
        Type.Repetition oldRepetition = this.currentRepetition;
        List<Type> types = this.getFieldsTypes(fields);
        this.currentName = oldName;
        this.currentRepetition = oldRepetition;
        this.currentType = types.size() > 0 ? new GroupType(this.currentRepetition, this.currentName, types) : null;
    }

    private List<Type> getFieldsTypes(List<ThriftField> fields) {
        ArrayList<Type> types = new ArrayList<Type>();
        for (int i = 0; i < fields.size(); ++i) {
            Type.Repetition rep;
            ThriftField field = fields.get(i);
            this.currentRepetition = rep = this.getRepetition(field);
            this.currentName = field.getName();
            this.currentFieldPath.push(field);
            field.getType().accept(this);
            if (this.currentType != null) {
                types.add(this.currentType.withId((int)field.getFieldId()));
            }
            this.currentFieldPath.pop();
        }
        return types;
    }

    private boolean isCurrentlyMatchedFilter() {
        if (!this.fieldProjectionFilter.isMatched(this.currentFieldPath)) {
            this.currentType = null;
            return false;
        }
        return true;
    }

    private void primitiveType(PrimitiveType.PrimitiveTypeName type) {
        this.primitiveType(type, null);
    }

    private void primitiveType(PrimitiveType.PrimitiveTypeName type, OriginalType orig) {
        if (this.isCurrentlyMatchedFilter()) {
            Types.PrimitiveBuilder b = Types.primitive((PrimitiveType.PrimitiveTypeName)type, (Type.Repetition)this.currentRepetition);
            if (orig != null) {
                b = (Types.PrimitiveBuilder)b.as(orig);
            }
            this.currentType = (Type)b.named(this.currentName);
        }
    }

    @Override
    public void visit(ThriftType.EnumType enumType) {
        this.primitiveType(PrimitiveType.PrimitiveTypeName.BINARY, OriginalType.ENUM);
    }

    @Override
    public void visit(ThriftType.BoolType boolType) {
        this.primitiveType(PrimitiveType.PrimitiveTypeName.BOOLEAN);
    }

    @Override
    public void visit(ThriftType.ByteType byteType) {
        this.primitiveType(PrimitiveType.PrimitiveTypeName.INT32);
    }

    @Override
    public void visit(ThriftType.DoubleType doubleType) {
        this.primitiveType(PrimitiveType.PrimitiveTypeName.DOUBLE);
    }

    @Override
    public void visit(ThriftType.I16Type i16Type) {
        this.primitiveType(PrimitiveType.PrimitiveTypeName.INT32);
    }

    @Override
    public void visit(ThriftType.I32Type i32Type) {
        this.primitiveType(PrimitiveType.PrimitiveTypeName.INT32);
    }

    @Override
    public void visit(ThriftType.I64Type i64Type) {
        this.primitiveType(PrimitiveType.PrimitiveTypeName.INT64);
    }

    @Override
    public void visit(ThriftType.StringType stringType) {
        this.primitiveType(PrimitiveType.PrimitiveTypeName.BINARY, OriginalType.UTF8);
    }

    private Type.Repetition getRepetition(ThriftField thriftField) {
        if (thriftField == null) {
            return Type.Repetition.OPTIONAL;
        }
        switch (thriftField.getRequirement()) {
            case REQUIRED: {
                return Type.Repetition.REQUIRED;
            }
            case OPTIONAL: {
                return Type.Repetition.OPTIONAL;
            }
            case DEFAULT: {
                return Type.Repetition.OPTIONAL;
            }
        }
        throw new IllegalArgumentException("unknown requirement type: " + (Object)((Object)thriftField.getRequirement()));
    }
}

