/*
 * Decompiled with CFR 0.152.
 */
package parquet.thrift;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import parquet.Log;
import parquet.hadoop.BadConfigurationException;
import parquet.thrift.struct.ThriftType;

public class ThriftMetaData {
    private static final Log LOG = Log.getLog(ThriftMetaData.class);
    private static final String THRIFT_CLASS = "thrift.class";
    private static final String THRIFT_DESCRIPTOR = "thrift.descriptor";
    private Class<?> thriftClass;
    private final String thriftClassName;
    private final ThriftType.StructType descriptor;

    public ThriftMetaData(String thriftClassName, ThriftType.StructType descriptor) {
        this.thriftClassName = thriftClassName;
        this.descriptor = descriptor;
    }

    public Class<?> getThriftClass() {
        if (this.thriftClass == null) {
            this.thriftClass = ThriftMetaData.getThriftClass(this.thriftClassName);
        }
        return this.thriftClass;
    }

    public static Class<?> getThriftClass(String thriftClassName) {
        try {
            Class<?> thriftClass = Class.forName(thriftClassName);
            return thriftClass;
        }
        catch (ClassNotFoundException e) {
            throw new BadConfigurationException("Could not instantiate thrift class " + thriftClassName, (Throwable)e);
        }
    }

    public ThriftType.StructType getDescriptor() {
        return this.descriptor;
    }

    public static ThriftMetaData fromExtraMetaData(Map<String, String> extraMetaData) {
        String thriftClassName = extraMetaData.get(THRIFT_CLASS);
        String thriftDescriptorString = extraMetaData.get(THRIFT_DESCRIPTOR);
        if (thriftClassName == null && thriftDescriptorString == null) {
            return null;
        }
        ThriftType.StructType descriptor = ThriftMetaData.parseDescriptor(thriftDescriptorString);
        return new ThriftMetaData(thriftClassName, descriptor);
    }

    private static ThriftType.StructType parseDescriptor(String json) {
        try {
            return (ThriftType.StructType)ThriftType.fromJSON(json);
        }
        catch (RuntimeException e) {
            throw new BadConfigurationException("Could not read the thrift descriptor " + json, (Throwable)e);
        }
    }

    public Map<String, String> toExtraMetaData() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(THRIFT_CLASS, this.getThriftClass().getName());
        map.put(THRIFT_DESCRIPTOR, this.descriptor.toJSON());
        return map;
    }

    public static Set<String> getThriftClassNames(Map<String, Set<String>> fileMetadata) {
        return fileMetadata.get(THRIFT_CLASS);
    }

    public String toString() {
        return "ThriftMetaData" + this.toExtraMetaData();
    }
}

