/*
 * Decompiled with CFR 0.152.
 */
package parquet.thrift.struct;

import org.junit.Assert;
import org.junit.Test;
import parquet.thrift.ThriftSchemaConverter;
import parquet.thrift.struct.CompatibilityChecker;
import parquet.thrift.struct.CompatibilityReport;
import parquet.thrift.struct.ThriftType;
import parquet.thrift.test.compat.AddRequiredStructV1;
import parquet.thrift.test.compat.DefaultStructV1;
import parquet.thrift.test.compat.ListStructV1;
import parquet.thrift.test.compat.ListStructV2;
import parquet.thrift.test.compat.MapAddRequiredStructV1;
import parquet.thrift.test.compat.MapStructV1;
import parquet.thrift.test.compat.MapStructV2;
import parquet.thrift.test.compat.MapValueStructV1;
import parquet.thrift.test.compat.MapValueStructV2;
import parquet.thrift.test.compat.OptionalStructV1;
import parquet.thrift.test.compat.RenameStructV1;
import parquet.thrift.test.compat.SetStructV1;
import parquet.thrift.test.compat.SetStructV2;
import parquet.thrift.test.compat.StructV1;
import parquet.thrift.test.compat.StructV2;
import parquet.thrift.test.compat.TypeChangeStructV1;

public class CompatibilityCheckerTest {
    @Test
    public void testAddOptionalField() {
        this.verifyCompatible(StructV1.class, StructV2.class, true);
    }

    @Test
    public void testRemoveOptionalField() {
        this.verifyCompatible(StructV2.class, StructV1.class, false);
    }

    @Test
    public void testRenameField() {
        this.verifyCompatible(StructV1.class, RenameStructV1.class, false);
    }

    @Test
    public void testTypeChange() {
        this.verifyCompatible(StructV1.class, TypeChangeStructV1.class, false);
    }

    @Test
    public void testReuirementChange() {
        this.verifyCompatible(StructV1.class, OptionalStructV1.class, true);
        this.verifyCompatible(StructV1.class, DefaultStructV1.class, true);
        this.verifyCompatible(OptionalStructV1.class, StructV1.class, false);
        this.verifyCompatible(DefaultStructV1.class, StructV1.class, false);
    }

    @Test
    public void testAddRequiredField() {
        this.verifyCompatible(StructV1.class, AddRequiredStructV1.class, false);
    }

    @Test
    public void testMap() {
        this.verifyCompatible(MapStructV1.class, MapStructV2.class, true);
        this.verifyCompatible(MapValueStructV1.class, MapValueStructV2.class, true);
        this.verifyCompatible(MapStructV2.class, MapStructV1.class, false);
        this.verifyCompatible(MapValueStructV2.class, MapValueStructV1.class, false);
        this.verifyCompatible(MapStructV2.class, MapAddRequiredStructV1.class, false);
    }

    @Test
    public void testSet() {
        this.verifyCompatible(SetStructV2.class, SetStructV1.class, false);
        this.verifyCompatible(SetStructV1.class, SetStructV2.class, true);
    }

    @Test
    public void testList() {
        this.verifyCompatible(ListStructV2.class, ListStructV1.class, false);
        this.verifyCompatible(ListStructV1.class, ListStructV2.class, true);
    }

    private ThriftType.StructType struct(Class thriftClass) {
        return new ThriftSchemaConverter().toStructType(thriftClass);
    }

    private void verifyCompatible(Class oldClass, Class newClass, boolean expectCompatible) {
        CompatibilityChecker checker = new CompatibilityChecker();
        CompatibilityReport report = checker.checkCompatibility(this.struct(oldClass), this.struct(newClass));
        System.out.println(report.messages);
        Assert.assertEquals((Object)expectCompatible, (Object)report.isCompatible());
    }
}

