/*
 * Decompiled with CFR 0.152.
 */
package parquet.thrift;

import com.twitter.data.proto.tutorial.thrift.AddressBook;
import com.twitter.data.proto.tutorial.thrift.Name;
import com.twitter.data.proto.tutorial.thrift.Person;
import com.twitter.data.proto.tutorial.thrift.PhoneNumber;
import com.twitter.data.proto.tutorial.thrift.PhoneType;
import com.twitter.elephantbird.thrift.test.TestMapInSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.junit.Assert;
import org.junit.Test;
import parquet.thrift.BufferedProtocolReadToWrite;
import parquet.thrift.DecodingSchemaMismatchException;
import parquet.thrift.FieldIgnoredHandler;
import parquet.thrift.ProtocolPipe;
import parquet.thrift.ProtocolReadToWrite;
import parquet.thrift.SkippableException;
import parquet.thrift.ThriftSchemaConverter;
import parquet.thrift.test.Phone;
import parquet.thrift.test.StructWithExtraField;
import parquet.thrift.test.StructWithIndexStartsFrom4;
import parquet.thrift.test.compat.NumberEnumWithMoreValue;
import parquet.thrift.test.compat.StructV3;
import parquet.thrift.test.compat.StructV4WithExtracStructField;
import parquet.thrift.test.compat.StructWithEnum;
import parquet.thrift.test.compat.StructWithMoreEnum;
import thrift.test.OneOfEach;

public class TestProtocolReadToWrite {
    @Test
    public void testOneOfEach() throws Exception {
        OneOfEach a = new OneOfEach(true, false, 8, 16, 32, 64L, 1234.0, "string", "\u00e5", false, ByteBuffer.wrap("a".getBytes()), new ArrayList(), new ArrayList(), new ArrayList());
        this.writeReadCompare((TBase<?, ?>)a);
    }

    @Test
    public void testWriteRead() throws Exception {
        ArrayList<Person> persons = new ArrayList<Person>();
        PhoneNumber phoneNumber = new PhoneNumber("555 999 9998");
        phoneNumber.type = PhoneType.HOME;
        persons.add(new Person(new Name("Bob", "Roberts"), 1, "bob@roberts.com", Arrays.asList(new PhoneNumber("555 999 9999"), phoneNumber)));
        persons.add(new Person(new Name("Dick", "Richardson"), 2, "dick@richardson.com", Arrays.asList(new PhoneNumber("555 999 9997"), new PhoneNumber("555 999 9996"))));
        AddressBook a = new AddressBook(persons);
        this.writeReadCompare((TBase<?, ?>)a);
    }

    @Test
    public void testEmptyStruct() throws Exception {
        AddressBook a = new AddressBook();
        this.writeReadCompare((TBase<?, ?>)a);
    }

    @Test
    public void testMapSet() throws Exception {
        HashSet set = new HashSet();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        set.add(map);
        TestMapInSet a = new TestMapInSet("top", set);
        this.writeReadCompare((TBase<?, ?>)a);
    }

    private void writeReadCompare(TBase<?, ?> a) throws TException, InstantiationException, IllegalAccessException {
        ProtocolPipe[] pipes;
        for (ProtocolPipe p : pipes = new ProtocolPipe[]{new ProtocolReadToWrite(), new BufferedProtocolReadToWrite(new ThriftSchemaConverter().toStructType(a.getClass()))}) {
            ByteArrayOutputStream in = new ByteArrayOutputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            a.write((TProtocol)this.protocol(in));
            p.readOne((TProtocol)this.protocol(new ByteArrayInputStream(in.toByteArray())), (TProtocol)this.protocol(out));
            TBase b = (TBase)a.getClass().newInstance();
            b.read((TProtocol)this.protocol(new ByteArrayInputStream(out.toByteArray())));
            Assert.assertEquals((String)p.getClass().getSimpleName(), a, (Object)b);
        }
    }

    @Test
    public void testIncompatibleSchemaRecord() throws Exception {
        CountingErrorHandler countingHandler = new CountingErrorHandler();
        BufferedProtocolReadToWrite p = new BufferedProtocolReadToWrite(new ThriftSchemaConverter().toStructType(AddressBook.class), (FieldIgnoredHandler)countingHandler);
        ByteArrayOutputStream in = new ByteArrayOutputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OneOfEach a = new OneOfEach(true, false, 8, 16, 32, 64L, 1234.0, "string", "\u00e5", false, ByteBuffer.wrap("a".getBytes()), new ArrayList(), new ArrayList(), new ArrayList());
        a.write((TProtocol)this.protocol(in));
        try {
            p.readOne((TProtocol)this.protocol(new ByteArrayInputStream(in.toByteArray())), (TProtocol)this.protocol(out));
        }
        catch (SkippableException e) {
            Throwable cause = e.getCause();
            Assert.assertTrue((boolean)(cause instanceof DecodingSchemaMismatchException));
            Assert.assertTrue((boolean)cause.getMessage().contains("the data type does not match the expected thrift structure"));
            Assert.assertTrue((boolean)cause.getMessage().contains("got BOOL"));
        }
        Assert.assertEquals((long)0L, (long)countingHandler.recordCountOfMissingFields);
        Assert.assertEquals((long)0L, (long)countingHandler.fieldIgnoredCount);
    }

    @Test
    public void testEnumMissingSchema() throws Exception {
        CountingErrorHandler countingHandler = new CountingErrorHandler();
        BufferedProtocolReadToWrite p = new BufferedProtocolReadToWrite(new ThriftSchemaConverter().toStructType(StructWithEnum.class), (FieldIgnoredHandler)countingHandler);
        ByteArrayOutputStream in = new ByteArrayOutputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StructWithMoreEnum enumDefinedInOldDefinition = new StructWithMoreEnum(NumberEnumWithMoreValue.THREE);
        StructWithMoreEnum extraEnumDefinedInNewDefinition = new StructWithMoreEnum(NumberEnumWithMoreValue.FOUR);
        enumDefinedInOldDefinition.write((TProtocol)this.protocol(in));
        extraEnumDefinedInNewDefinition.write((TProtocol)this.protocol(in));
        try {
            p.readOne((TProtocol)this.protocol(new ByteArrayInputStream(in.toByteArray())), (TProtocol)this.protocol(out));
        }
        catch (SkippableException e) {
            Throwable cause = e.getCause();
            Assert.assertTrue((boolean)(cause instanceof DecodingSchemaMismatchException));
            Assert.assertTrue((boolean)cause.getMessage().contains("can not find index 4 in enum"));
        }
        Assert.assertEquals((long)0L, (long)countingHandler.recordCountOfMissingFields);
        Assert.assertEquals((long)0L, (long)countingHandler.fieldIgnoredCount);
    }

    @Test
    public void testMissingFieldHandling() throws Exception {
        CountingErrorHandler countingHandler = new CountingErrorHandler(){

            @Override
            public void handleFieldIgnored(TField field) {
                Assert.assertEquals((long)field.id, (long)4L);
                ++this.fieldIgnoredCount;
            }
        };
        BufferedProtocolReadToWrite structForRead = new BufferedProtocolReadToWrite(new ThriftSchemaConverter().toStructType(StructV3.class), (FieldIgnoredHandler)countingHandler);
        ByteArrayOutputStream in = new ByteArrayOutputStream();
        StructV4WithExtracStructField dataWithNewSchema = new StructV4WithExtracStructField("name");
        dataWithNewSchema.setAge("10");
        dataWithNewSchema.setGender("male");
        StructV3 structV3 = new StructV3("name");
        structV3.setAge("10");
        dataWithNewSchema.setAddedStruct(structV3);
        dataWithNewSchema.write((TProtocol)this.protocol(in));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        structForRead.readOne((TProtocol)this.protocol(new ByteArrayInputStream(in.toByteArray())), (TProtocol)this.protocol(out));
        Assert.assertEquals((long)1L, (long)countingHandler.recordCountOfMissingFields);
        Assert.assertEquals((long)1L, (long)countingHandler.fieldIgnoredCount);
        StructV4WithExtracStructField b = (StructV4WithExtracStructField)StructV4WithExtracStructField.class.newInstance();
        b.read((TProtocol)this.protocol(new ByteArrayInputStream(out.toByteArray())));
        Assert.assertEquals((Object)dataWithNewSchema.getName(), (Object)b.getName());
        Assert.assertEquals((Object)dataWithNewSchema.getAge(), (Object)b.getAge());
        Assert.assertEquals((Object)dataWithNewSchema.getGender(), (Object)b.getGender());
        Assert.assertEquals(null, (Object)b.getAddedStruct());
    }

    @Test
    public void TestExtraFieldWhenFieldIndexIsNotStartFromZero() throws Exception {
        CountingErrorHandler countingHandler = new CountingErrorHandler(){

            @Override
            public void handleFieldIgnored(TField field) {
                Assert.assertEquals((long)3L, (long)field.id);
                ++this.fieldIgnoredCount;
            }
        };
        BufferedProtocolReadToWrite structForRead = new BufferedProtocolReadToWrite(new ThriftSchemaConverter().toStructType(StructWithIndexStartsFrom4.class), (FieldIgnoredHandler)countingHandler);
        ByteArrayOutputStream in = new ByteArrayOutputStream();
        StructWithExtraField dataWithNewExtraField = new StructWithExtraField(new Phone("111", "222"), new Phone("333", "444"));
        dataWithNewExtraField.write((TProtocol)this.protocol(in));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        structForRead.readOne((TProtocol)this.protocol(new ByteArrayInputStream(in.toByteArray())), (TProtocol)this.protocol(out));
        Assert.assertEquals((long)1L, (long)countingHandler.recordCountOfMissingFields);
        Assert.assertEquals((long)1L, (long)countingHandler.fieldIgnoredCount);
    }

    private TCompactProtocol protocol(OutputStream to) {
        return new TCompactProtocol((TTransport)new TIOStreamTransport(to));
    }

    private TCompactProtocol protocol(InputStream from) {
        return new TCompactProtocol((TTransport)new TIOStreamTransport(from));
    }

    class CountingErrorHandler
    extends FieldIgnoredHandler {
        int fieldIgnoredCount = 0;
        int recordCountOfMissingFields = 0;

        CountingErrorHandler() {
        }

        public void handleRecordHasFieldIgnored() {
            ++this.recordCountOfMissingFields;
        }

        public void handleFieldIgnored(TField field) {
            ++this.fieldIgnoredCount;
        }
    }
}

