/*
 * Decompiled with CFR 0.152.
 */
package parquet.thrift;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.thrift.TBase;
import parquet.Preconditions;
import parquet.filter2.compat.FilterCompat;
import parquet.hadoop.ParquetReader;
import parquet.hadoop.thrift.ThriftReadSupport;

public class ThriftParquetReader<T extends TBase<?, ?>>
extends ParquetReader<T> {
    @Deprecated
    public ThriftParquetReader(Path file, Class<T> thriftClass) throws IOException {
        super(file, new ThriftReadSupport<T>(thriftClass));
    }

    @Deprecated
    public ThriftParquetReader(Configuration conf, Path file, Class<T> thriftClass) throws IOException {
        super(conf, file, new ThriftReadSupport<T>(thriftClass));
    }

    @Deprecated
    public ThriftParquetReader(Path file) throws IOException {
        super(file, new ThriftReadSupport());
    }

    @Deprecated
    public ThriftParquetReader(Configuration conf, Path file) throws IOException {
        super(conf, file, new ThriftReadSupport());
    }

    public static <T extends TBase<?, ?>> Builder<T> build(Path file) {
        return new Builder(file);
    }

    public static class Builder<T extends TBase<?, ?>> {
        private final Path file;
        private Configuration conf;
        private FilterCompat.Filter filter;
        private Class<T> thriftClass;

        private Builder(Path file) {
            this.file = (Path)Preconditions.checkNotNull((Object)file, (String)"file");
            this.conf = new Configuration();
            this.filter = FilterCompat.NOOP;
            this.thriftClass = null;
        }

        public Builder<T> withConf(Configuration conf) {
            this.conf = (Configuration)Preconditions.checkNotNull((Object)conf, (String)"conf");
            return this;
        }

        public Builder<T> withFilter(FilterCompat.Filter filter) {
            this.filter = (FilterCompat.Filter)Preconditions.checkNotNull((Object)filter, (String)"filter");
            return this;
        }

        public Builder<T> withThriftClass(Class<T> thriftClass) {
            this.thriftClass = (Class)Preconditions.checkNotNull(thriftClass, (String)"thriftClass");
            return this;
        }

        public ParquetReader<T> build() throws IOException {
            ThriftReadSupport readSupport = this.thriftClass != null ? new ThriftReadSupport<T>(this.thriftClass) : new ThriftReadSupport();
            return ParquetReader.builder(readSupport, (Path)this.file).withConf(this.conf).withFilter(this.filter).build();
        }
    }
}

