/*
 * Decompiled with CFR 0.152.
 */
package parquet.thrift;

import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import parquet.io.ParquetDecodingException;
import parquet.schema.MessageType;
import parquet.thrift.ThriftReader;
import parquet.thrift.ThriftRecordConverter;
import parquet.thrift.struct.ThriftType;

public class TBaseRecordConverter<T extends TBase<?, ?>>
extends ThriftRecordConverter<T> {
    public TBaseRecordConverter(final Class<T> thriftClass, MessageType requestedParquetSchema, ThriftType.StructType thriftType) {
        super(new ThriftReader<T>(){

            @Override
            public T readOneRecord(TProtocol protocol) throws TException {
                try {
                    TBase thriftObject = (TBase)thriftClass.newInstance();
                    thriftObject.read(protocol);
                    return thriftObject;
                }
                catch (InstantiationException e) {
                    throw new ParquetDecodingException("Could not instantiate Thrift " + thriftClass, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new ParquetDecodingException("Thrift class or constructor not public " + thriftClass, (Throwable)e);
                }
            }
        }, thriftClass.getSimpleName(), requestedParquetSchema, thriftType);
    }
}

