/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.thrift;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import parquet.hadoop.BadConfigurationException;
import parquet.hadoop.api.WriteSupport;
import parquet.hadoop.thrift.TBaseWriteSupport;
import parquet.io.ColumnIOFactory;
import parquet.io.MessageColumnIO;
import parquet.io.ParquetEncodingException;
import parquet.io.api.RecordConsumer;
import parquet.schema.MessageType;
import parquet.thrift.BufferedProtocolReadToWrite;
import parquet.thrift.FieldIgnoredHandler;
import parquet.thrift.ParquetWriteProtocol;
import parquet.thrift.ProtocolPipe;
import parquet.thrift.ProtocolReadToWrite;
import parquet.thrift.ThriftSchemaConverter;
import parquet.thrift.struct.ThriftType;

public class ThriftBytesWriteSupport
extends WriteSupport<BytesWritable> {
    private static final String PARQUET_PROTOCOL_CLASS = "parquet.protocol.class";
    private final boolean buffered;
    private final TBaseWriteSupport<?> thriftWriteSupport = new TBaseWriteSupport();
    private ProtocolPipe readToWrite;
    private TProtocolFactory protocolFactory;
    private Class<? extends TBase<?, ?>> thriftClass;
    private MessageType schema;
    private ThriftType.StructType thriftStruct;
    private ParquetWriteProtocol parquetWriteProtocol;
    private final FieldIgnoredHandler errorHandler;

    public static <U extends TProtocol> void setTProtocolClass(Configuration conf, Class<U> tProtocolClass) {
        conf.set(PARQUET_PROTOCOL_CLASS, tProtocolClass.getName());
    }

    public static Class<TProtocolFactory> getTProtocolFactoryClass(Configuration conf) {
        String tProtocolClassName = conf.get(PARQUET_PROTOCOL_CLASS);
        if (tProtocolClassName == null) {
            throw new BadConfigurationException("the protocol class conf is missing in job conf at parquet.protocol.class");
        }
        try {
            Class<TProtocolFactory> tProtocolFactoryClass = Class.forName(tProtocolClassName + "$Factory");
            return tProtocolFactoryClass;
        }
        catch (ClassNotFoundException e) {
            throw new BadConfigurationException("the Factory for class " + tProtocolClassName + " in job conf at " + PARQUET_PROTOCOL_CLASS + " could not be found", (Throwable)e);
        }
    }

    public ThriftBytesWriteSupport() {
        this.buffered = true;
        this.errorHandler = null;
    }

    public ThriftBytesWriteSupport(TProtocolFactory protocolFactory, Class<? extends TBase<?, ?>> thriftClass, boolean buffered, FieldIgnoredHandler errorHandler) {
        this.protocolFactory = protocolFactory;
        this.thriftClass = thriftClass;
        this.buffered = buffered;
        this.errorHandler = errorHandler;
        if (!buffered && errorHandler != null) {
            throw new IllegalArgumentException("Only buffered protocol can use error handler for now");
        }
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        if (this.protocolFactory == null) {
            try {
                this.protocolFactory = ThriftBytesWriteSupport.getTProtocolFactoryClass(configuration).newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.thriftClass != null) {
            TBaseWriteSupport.setThriftClass(configuration, this.thriftClass);
        } else {
            this.thriftClass = TBaseWriteSupport.getThriftClass(configuration);
        }
        ThriftSchemaConverter thriftSchemaConverter = new ThriftSchemaConverter();
        this.thriftStruct = thriftSchemaConverter.toStructType(this.thriftClass);
        this.schema = thriftSchemaConverter.convert(this.thriftStruct);
        this.readToWrite = this.buffered ? new BufferedProtocolReadToWrite(this.thriftStruct, this.errorHandler) : new ProtocolReadToWrite();
        return this.thriftWriteSupport.init(configuration);
    }

    private TProtocol protocol(BytesWritable record) {
        TProtocol protocol = this.protocolFactory.getProtocol((TTransport)new TIOStreamTransport((InputStream)new ByteArrayInputStream(record.getBytes())));
        if (protocol instanceof TBinaryProtocol) {
            ((TBinaryProtocol)protocol).setReadLength(record.getLength());
        }
        return protocol;
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        MessageColumnIO columnIO = new ColumnIOFactory().getColumnIO(this.schema);
        this.parquetWriteProtocol = new ParquetWriteProtocol(recordConsumer, columnIO, this.thriftStruct);
        this.thriftWriteSupport.prepareForWrite(recordConsumer);
    }

    public void write(BytesWritable record) {
        try {
            this.readToWrite.readOne(this.protocol(record), this.parquetWriteProtocol);
        }
        catch (TException e) {
            throw new ParquetEncodingException((Throwable)e);
        }
    }
}

