/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.thrift;

import org.apache.hadoop.conf.Configuration;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import parquet.hadoop.thrift.AbstractThriftWriteSupport;
import parquet.io.ParquetEncodingException;
import parquet.thrift.ThriftSchemaConverter;
import parquet.thrift.struct.ThriftType;

public class TBaseWriteSupport<T extends TBase<?, ?>>
extends AbstractThriftWriteSupport<T> {
    public static <U extends TBase<?, ?>> void setThriftClass(Configuration configuration, Class<U> thriftClass) {
        AbstractThriftWriteSupport.setGenericThriftClass(configuration, thriftClass);
    }

    public static Class<? extends TBase<?, ?>> getThriftClass(Configuration configuration) {
        return AbstractThriftWriteSupport.getGenericThriftClass(configuration);
    }

    public TBaseWriteSupport() {
    }

    public TBaseWriteSupport(Class<T> thriftClass) {
        super(thriftClass);
    }

    @Override
    protected ThriftType.StructType getThriftStruct() {
        ThriftSchemaConverter thriftSchemaConverter = new ThriftSchemaConverter();
        return thriftSchemaConverter.toStructType(this.thriftClass);
    }

    public void write(T record) {
        try {
            record.write((TProtocol)this.parquetWriteProtocol);
        }
        catch (TException e) {
            throw new ParquetEncodingException((Throwable)e);
        }
    }
}

