/*
 * Decompiled with CFR 0.152.
 */
package parquet.thrift.projection.amend;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import parquet.thrift.ParquetProtocol;
import parquet.thrift.projection.amend.DefaultProtocolEventsGenerator;
import parquet.thrift.projection.amend.ReadFieldBeginProtocol;
import parquet.thrift.struct.ThriftField;
import parquet.thrift.struct.ThriftType;

class DefaultEventsVisitor
implements ThriftType.TypeVisitor {
    List<ParquetProtocol> dummyEvents = new ArrayList<ParquetProtocol>();

    DefaultEventsVisitor() {
    }

    @Override
    public void visit(ThriftType.MapType mapType) {
        this.dummyEvents.add(new ParquetProtocol("readMapBegin()"){

            @Override
            public TMap readMapBegin() throws TException {
                return new TMap();
            }
        });
        this.dummyEvents.add(new ParquetProtocol("readMapEnd()"){

            @Override
            public void readMapEnd() throws TException {
            }
        });
    }

    @Override
    public void visit(ThriftType.SetType setType) {
        this.dummyEvents.add(new ParquetProtocol("readSetBegin()"){

            @Override
            public TSet readSetBegin() throws TException {
                return new TSet();
            }
        });
        this.dummyEvents.add(new ParquetProtocol("readSetEnd()"){

            @Override
            public void readSetEnd() throws TException {
            }
        });
    }

    @Override
    public void visit(ThriftType.ListType listType) {
        this.dummyEvents.add(new ParquetProtocol("readListBegin()"){

            @Override
            public TList readListBegin() throws TException {
                return new TList();
            }
        });
        this.dummyEvents.add(new ParquetProtocol("readListEnd()"){

            @Override
            public void readListEnd() throws TException {
            }
        });
    }

    @Override
    public void visit(ThriftType.StructType structType) {
        this.dummyEvents.add(new StructBeginProtocol("struct"));
        List<ThriftField> children = structType.getChildren();
        for (ThriftField child : children) {
            this.dummyEvents.add(new ReadFieldBeginProtocol(child));
            child.getType().accept(this);
            this.dummyEvents.add(DefaultProtocolEventsGenerator.READ_FIELD_END);
        }
        this.dummyEvents.add(DefaultProtocolEventsGenerator.READ_FIELD_STOP);
        this.dummyEvents.add(DefaultProtocolEventsGenerator.READ_STRUCT_END);
    }

    @Override
    public void visit(ThriftType.EnumType enumType) {
        this.dummyEvents.add(new ParquetProtocol("readI32() enum"){

            @Override
            public int readI32() throws TException {
                return 0;
            }
        });
    }

    @Override
    public void visit(ThriftType.BoolType boolType) {
        this.dummyEvents.add(new ParquetProtocol("readBool()"){

            @Override
            public boolean readBool() throws TException {
                return false;
            }
        });
    }

    @Override
    public void visit(ThriftType.ByteType byteType) {
        this.dummyEvents.add(new ParquetProtocol("readByte() int"){

            @Override
            public byte readByte() throws TException {
                return 0;
            }
        });
    }

    @Override
    public void visit(ThriftType.DoubleType doubleType) {
        this.dummyEvents.add(new ParquetProtocol("readDouble()"){

            @Override
            public double readDouble() throws TException {
                return 0.0;
            }
        });
    }

    @Override
    public void visit(ThriftType.I16Type i16Type) {
        this.dummyEvents.add(new ParquetProtocol("readI16()"){

            @Override
            public short readI16() throws TException {
                return 0;
            }
        });
    }

    @Override
    public void visit(ThriftType.I32Type i32Type) {
        this.dummyEvents.add(new ParquetProtocol("readI32()"){

            @Override
            public int readI32() throws TException {
                return 0;
            }
        });
    }

    @Override
    public void visit(ThriftType.I64Type i64Type) {
        this.dummyEvents.add(new ParquetProtocol("readI64()"){

            @Override
            public long readI64() throws TException {
                return 0L;
            }
        });
    }

    @Override
    public void visit(ThriftType.StringType stringType) {
        this.dummyEvents.add(new StringProtocol(""));
    }

    public List<ParquetProtocol> getEvents() {
        return this.dummyEvents;
    }

    public static class StringProtocol
    extends ParquetProtocol {
        private final String str;

        public StringProtocol(String str) {
            super("readString() binary");
            this.str = str;
        }

        @Override
        public String readString() throws TException {
            return this.str;
        }

        @Override
        public ByteBuffer readBinary() throws TException {
            return ByteBuffer.wrap("str".getBytes());
        }
    }

    private static class StructBeginProtocol
    extends ParquetProtocol {
        private final String structName;

        public StructBeginProtocol(String structName) {
            super("readStructBegin()");
            this.structName = structName;
        }

        @Override
        public TStruct readStructBegin() throws TException {
            return new TStruct(this.structName);
        }
    }
}

