/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.thrift;

import com.twitter.elephantbird.pig.util.ThriftToPig;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import parquet.Log;
import parquet.hadoop.BadConfigurationException;
import parquet.hadoop.api.WriteSupport;
import parquet.io.ColumnIOFactory;
import parquet.io.MessageColumnIO;
import parquet.io.ParquetEncodingException;
import parquet.io.api.RecordConsumer;
import parquet.pig.PigMetaData;
import parquet.schema.MessageType;
import parquet.thrift.ParquetWriteProtocol;
import parquet.thrift.ThriftMetaData;
import parquet.thrift.ThriftSchemaConverter;
import parquet.thrift.struct.ThriftType;

public class ThriftWriteSupport<T extends TBase<?, ?>>
extends WriteSupport<T> {
    public static final String PARQUET_THRIFT_CLASS = "parquet.thrift.class";
    private static final Log LOG = Log.getLog(ThriftWriteSupport.class);
    private MessageType schema;
    private ThriftType.StructType thriftStruct;
    private ParquetWriteProtocol parquetWriteProtocol;
    private WriteSupport.WriteContext writeContext;

    public static <U extends TBase<?, ?>> void setThriftClass(Configuration configuration, Class<U> thriftClass) {
        configuration.set(PARQUET_THRIFT_CLASS, thriftClass.getName());
    }

    public static Class<? extends TBase<?, ?>> getThriftClass(Configuration configuration) {
        String thriftClassName = configuration.get(PARQUET_THRIFT_CLASS);
        if (thriftClassName == null) {
            throw new BadConfigurationException("the thrift class conf is missing in job conf at parquet.thrift.class");
        }
        try {
            Class<?> thriftClass = Class.forName(thriftClassName);
            return thriftClass;
        }
        catch (ClassNotFoundException e) {
            throw new BadConfigurationException("the class " + thriftClassName + " in job conf at " + PARQUET_THRIFT_CLASS + " could not be found", (Throwable)e);
        }
    }

    public ThriftWriteSupport() {
    }

    public ThriftWriteSupport(Class<T> thriftClass) {
        this.init(thriftClass);
    }

    private <S extends TBase<?, ?>> void init(Class<S> thriftClass) {
        ThriftSchemaConverter thriftSchemaConverter = new ThriftSchemaConverter();
        this.thriftStruct = thriftSchemaConverter.toStructType(thriftClass);
        this.schema = thriftSchemaConverter.convert(thriftClass);
        Map<String, String> extraMetaData = new ThriftMetaData(thriftClass.getName(), this.thriftStruct).toExtraMetaData();
        if (this.isPigLoaded()) {
            new PigMetaData(new ThriftToPig(thriftClass).toSchema()).addToMetaData(extraMetaData);
        }
        this.writeContext = new WriteSupport.WriteContext(this.schema, extraMetaData);
    }

    private boolean isPigLoaded() {
        try {
            Class.forName("org.apache.pig.impl.logicalLayer.schema.Schema");
            return true;
        }
        catch (ClassNotFoundException e) {
            LOG.info((Object)"Pig is not loaded, pig metadata will not be written");
            return false;
        }
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        if (this.writeContext == null) {
            this.init(ThriftWriteSupport.getThriftClass(configuration));
        }
        return this.writeContext;
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        MessageColumnIO columnIO = new ColumnIOFactory().getColumnIO(this.schema);
        this.parquetWriteProtocol = new ParquetWriteProtocol(recordConsumer, columnIO, this.thriftStruct);
    }

    public void write(T record) {
        try {
            record.write((TProtocol)this.parquetWriteProtocol);
        }
        catch (TException e) {
            throw new ParquetEncodingException((Throwable)e);
        }
    }
}

