/*
 * Decompiled with CFR 0.152.
 */
package parquet.thrift.projection;

import java.util.LinkedList;
import java.util.List;
import parquet.thrift.projection.FieldsPath;
import parquet.thrift.projection.PathGlobPattern;

public class FieldProjectionFilter {
    public static final String PATTERN_SEPARATOR = ";";
    List<PathGlobPattern> filterPatterns = new LinkedList<PathGlobPattern>();

    public FieldProjectionFilter() {
    }

    public FieldProjectionFilter(String filterDescStr) {
        String[] rawPatterns;
        if (filterDescStr == null || filterDescStr.isEmpty()) {
            return;
        }
        for (String rawPattern : rawPatterns = filterDescStr.split(PATTERN_SEPARATOR)) {
            this.filterPatterns.add(new PathGlobPattern(rawPattern));
        }
    }

    public boolean isMatched(FieldsPath path) {
        if (this.filterPatterns.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.filterPatterns.size(); ++i) {
            if (!this.matchPattern(path, this.filterPatterns.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean matchPattern(FieldsPath path, PathGlobPattern filterPattern) {
        return filterPattern.matches(path.toString());
    }
}

