/*
 * Decompiled with CFR 0.152.
 */
package parquet.thrift;

import java.nio.ByteBuffer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import parquet.Log;
import parquet.io.ColumnIO;
import parquet.io.GroupColumnIO;
import parquet.io.MessageColumnIO;
import parquet.io.ParquetEncodingException;
import parquet.io.PrimitiveColumnIO;
import parquet.io.api.Binary;
import parquet.io.api.RecordConsumer;
import parquet.thrift.ParquetProtocol;
import parquet.thrift.struct.ThriftField;
import parquet.thrift.struct.ThriftType;

public class ParquetWriteProtocol
extends ParquetProtocol {
    private static final Log LOG = Log.getLog(ParquetWriteProtocol.class);
    private final RecordConsumer recordConsumer;
    private TProtocol currentProtocol;

    private String toString(TStruct struct) {
        return "<TStruct name:" + struct.name + ">";
    }

    private String toString(TList list) {
        return "<TList elemType:" + list.elemType + " size:" + list.size + ">";
    }

    private String toString(TMap map) {
        return "<TMap keyType:" + map.keyType + " valueType:" + map.valueType + " size:" + map.size + ">";
    }

    public ParquetWriteProtocol(RecordConsumer recordConsumer, MessageColumnIO schema, ThriftType.StructType thriftType) {
        this.currentProtocol = new MessageWriteProtocol(schema, thriftType);
        this.recordConsumer = recordConsumer;
    }

    @Override
    public void writeMessageBegin(TMessage message) throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)("writeMessageBegin(" + message + ")"));
        }
        this.currentProtocol.writeMessageBegin(message);
    }

    @Override
    public void writeMessageEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"writeMessageEnd()");
        }
        this.currentProtocol.writeMessageEnd();
    }

    @Override
    public void writeStructBegin(TStruct struct) throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)("writeStructBegin(" + this.toString(struct) + ")"));
        }
        this.currentProtocol.writeStructBegin(struct);
    }

    @Override
    public void writeStructEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"writeStructEnd()");
        }
        this.currentProtocol.writeStructEnd();
    }

    @Override
    public void writeFieldBegin(TField field) throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)("writeFieldBegin(" + field + ")"));
        }
        this.currentProtocol.writeFieldBegin(field);
    }

    @Override
    public void writeFieldEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"writeFieldEnd()");
        }
        this.currentProtocol.writeFieldEnd();
    }

    @Override
    public void writeFieldStop() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"writeFieldStop()");
        }
        this.currentProtocol.writeFieldStop();
    }

    @Override
    public void writeMapBegin(TMap map) throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)("writeMapBegin(" + this.toString(map) + ")"));
        }
        this.currentProtocol.writeMapBegin(map);
    }

    @Override
    public void writeMapEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"writeMapEnd()");
        }
        this.currentProtocol.writeMapEnd();
    }

    @Override
    public void writeListBegin(TList list) throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)("writeListBegin(" + this.toString(list) + ")"));
        }
        this.currentProtocol.writeListBegin(list);
    }

    @Override
    public void writeListEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"writeListEnd()");
        }
        this.currentProtocol.writeListEnd();
    }

    @Override
    public void writeSetBegin(TSet set) throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)("writeSetBegin(" + set + ")"));
        }
        this.currentProtocol.writeSetBegin(set);
    }

    @Override
    public void writeSetEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"writeSetEnd()");
        }
        this.currentProtocol.writeSetEnd();
    }

    @Override
    public void writeBool(boolean b) throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)("writeBool(" + b + ")"));
        }
        this.currentProtocol.writeBool(b);
    }

    @Override
    public void writeByte(byte b) throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)("writeByte(" + b + ")"));
        }
        this.currentProtocol.writeByte(b);
    }

    @Override
    public void writeI16(short i16) throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)("writeI16(" + i16 + ")"));
        }
        this.currentProtocol.writeI16(i16);
    }

    @Override
    public void writeI32(int i32) throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)("writeI32(" + i32 + ")"));
        }
        this.currentProtocol.writeI32(i32);
    }

    @Override
    public void writeI64(long i64) throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)("writeI64(" + i64 + ")"));
        }
        this.currentProtocol.writeI64(i64);
    }

    @Override
    public void writeDouble(double dub) throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)("writeDouble(" + dub + ")"));
        }
        this.currentProtocol.writeDouble(dub);
    }

    @Override
    public void writeString(String str) throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)("writeString(" + str + ")"));
        }
        this.currentProtocol.writeString(str);
    }

    @Override
    public void writeBinary(ByteBuffer buf) throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)("writeBinary(" + buf + ")"));
        }
        this.currentProtocol.writeBinary(buf);
    }

    private void writeBinaryToRecordConsumer(ByteBuffer buf) {
        this.recordConsumer.addBinary(Binary.fromByteArray((byte[])buf.array(), (int)buf.position(), (int)(buf.limit() - buf.position())));
    }

    private void writeStringToRecordConsumer(String str) {
        this.recordConsumer.addBinary(Binary.fromString((String)str));
    }

    private TProtocol getProtocol(ThriftField field, ColumnIO columnIO, Events returnClause) {
        FieldBaseWriteProtocol p;
        ThriftType type = field.getType();
        switch (type.getType()) {
            default: {
                throw new UnsupportedOperationException("can't convert type of " + field);
            }
            case BOOL: 
            case BYTE: 
            case DOUBLE: 
            case I16: 
            case I32: 
            case I64: 
            case STRING: {
                p = new PrimitiveWriteProtocol((PrimitiveColumnIO)columnIO, returnClause);
                break;
            }
            case STRUCT: {
                p = new StructWriteProtocol((GroupColumnIO)columnIO, (ThriftType.StructType)type, returnClause);
                break;
            }
            case MAP: {
                p = new MapWriteProtocol((GroupColumnIO)columnIO, (ThriftType.MapType)type, returnClause);
                break;
            }
            case SET: {
                p = new ListWriteProtocol((GroupColumnIO)columnIO, ((ThriftType.SetType)type).getValues(), returnClause);
                break;
            }
            case LIST: {
                p = new ListWriteProtocol((GroupColumnIO)columnIO, ((ThriftType.ListType)type).getValues(), returnClause);
                break;
            }
            case ENUM: {
                p = new EnumWriteProtocol((PrimitiveColumnIO)columnIO, (ThriftType.EnumType)type, returnClause);
            }
        }
        return p;
    }

    class MessageWriteProtocol
    extends StructWriteProtocol {
        public MessageWriteProtocol(MessageColumnIO schema, ThriftType.StructType thriftType) {
            super((GroupColumnIO)schema, thriftType, null);
        }

        @Override
        public void writeStructBegin(TStruct struct) throws TException {
            ParquetWriteProtocol.this.recordConsumer.startMessage();
        }

        @Override
        public void writeStructEnd() throws TException {
            ParquetWriteProtocol.this.recordConsumer.endMessage();
        }
    }

    class StructWriteProtocol
    extends FieldBaseWriteProtocol {
        private final GroupColumnIO schema;
        private final ThriftType.StructType thriftType;
        private final TProtocol[] children;
        private ColumnIO currentType;
        private ColumnIO[] thriftFieldIdToParquetField;

        public StructWriteProtocol(GroupColumnIO schema, ThriftType.StructType thriftType, Events returnClause) {
            super(returnClause);
            if (schema == null) {
                throw new NullPointerException("schema");
            }
            this.thriftType = thriftType;
            int maxFieldId = 0;
            for (ThriftField field : thriftType.getChildren()) {
                maxFieldId = Math.max(maxFieldId, field.getFieldId());
            }
            this.thriftFieldIdToParquetField = new ColumnIO[maxFieldId + 1];
            for (int i = 0; i < thriftType.getChildren().size(); ++i) {
                this.thriftFieldIdToParquetField[thriftType.getChildren().get((int)i).getFieldId()] = schema.getChild(i);
            }
            for (ThriftField field : thriftType.getChildren()) {
            }
            this.schema = schema;
            this.children = new TProtocol[thriftType.getChildren().size()];
            for (int i = 0; i < this.children.length; ++i) {
                ThriftField field;
                field = thriftType.getChildren().get(i);
                ColumnIO columnIO = schema.getChild(field.getName());
                if (columnIO == null) {
                    throw new RuntimeException("Could not find " + field.getName() + " in " + schema);
                }
                try {
                    TProtocol p;
                    this.children[i] = p = ParquetWriteProtocol.this.getProtocol(field, columnIO, new Events(){

                        @Override
                        public void start() {
                        }

                        @Override
                        public void end() {
                            ParquetWriteProtocol.this.currentProtocol = StructWriteProtocol.this;
                        }
                    });
                    continue;
                }
                catch (RuntimeException e) {
                    throw new ParquetEncodingException("Could not create Protocol for " + field + " to " + columnIO, (Throwable)e);
                }
            }
        }

        @Override
        public void writeStructBegin(TStruct struct) throws TException {
            this.start();
            ParquetWriteProtocol.this.recordConsumer.startGroup();
        }

        @Override
        public void writeStructEnd() throws TException {
            ParquetWriteProtocol.this.recordConsumer.endGroup();
            this.end();
        }

        @Override
        public void writeFieldBegin(TField field) throws TException {
            if (field.type == 0) {
                return;
            }
            try {
                this.currentType = this.thriftFieldIdToParquetField[field.id];
                if (this.currentType == null) {
                    throw new ParquetEncodingException("field " + field.id + " was not found in " + this.thriftType + " and " + this.schema.getType());
                }
                int index = this.currentType.getIndex();
                ParquetWriteProtocol.this.recordConsumer.startField(this.currentType.getName(), index);
                ParquetWriteProtocol.this.currentProtocol = this.children[index];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ParquetEncodingException("field " + field.id + " was not found in " + this.thriftType + " and " + this.schema.getType());
            }
        }

        @Override
        public void writeFieldStop() throws TException {
        }

        @Override
        public void writeFieldEnd() throws TException {
            ParquetWriteProtocol.this.recordConsumer.endField(this.currentType.getName(), this.currentType.getIndex());
        }
    }

    class PrimitiveWriteProtocol
    extends FieldBaseWriteProtocol {
        public PrimitiveWriteProtocol(PrimitiveColumnIO columnIO, Events returnClause) {
            super(returnClause);
        }

        @Override
        public void writeBool(boolean b) throws TException {
            this.start();
            ParquetWriteProtocol.this.recordConsumer.addBoolean(b);
            this.end();
        }

        @Override
        public void writeByte(byte b) throws TException {
            this.start();
            ParquetWriteProtocol.this.recordConsumer.addInteger((int)b);
            this.end();
        }

        @Override
        public void writeI16(short i16) throws TException {
            this.start();
            ParquetWriteProtocol.this.recordConsumer.addInteger((int)i16);
            this.end();
        }

        @Override
        public void writeI32(int i32) throws TException {
            this.start();
            ParquetWriteProtocol.this.recordConsumer.addInteger(i32);
            this.end();
        }

        @Override
        public void writeI64(long i64) throws TException {
            this.start();
            ParquetWriteProtocol.this.recordConsumer.addLong(i64);
            this.end();
        }

        @Override
        public void writeDouble(double dub) throws TException {
            this.start();
            ParquetWriteProtocol.this.recordConsumer.addDouble(dub);
            this.end();
        }

        @Override
        public void writeString(String str) throws TException {
            this.start();
            ParquetWriteProtocol.this.writeStringToRecordConsumer(str);
            this.end();
        }

        @Override
        public void writeBinary(ByteBuffer buf) throws TException {
            this.start();
            ParquetWriteProtocol.this.writeBinaryToRecordConsumer(buf);
            this.end();
        }
    }

    class MapWriteProtocol
    extends FieldBaseWriteProtocol {
        private GroupColumnIO mapContent;
        private ColumnIO key;
        private ColumnIO value;
        private TProtocol keyProtocol;
        private TProtocol valueProtocol;
        private int countToConsume;

        public MapWriteProtocol(GroupColumnIO columnIO, ThriftType.MapType type, Events returnClause) {
            super(returnClause);
            this.mapContent = (GroupColumnIO)columnIO.getChild(0);
            this.key = this.mapContent.getChild(0);
            this.value = this.mapContent.getChild(1);
            this.keyProtocol = ParquetWriteProtocol.this.getProtocol(type.getKey(), this.key, new Events(){

                @Override
                public void start() {
                    ParquetWriteProtocol.this.recordConsumer.startGroup();
                    ParquetWriteProtocol.this.recordConsumer.startField(MapWriteProtocol.this.key.getName(), MapWriteProtocol.this.key.getIndex());
                }

                @Override
                public void end() {
                    ParquetWriteProtocol.this.recordConsumer.endField(MapWriteProtocol.this.key.getName(), MapWriteProtocol.this.key.getIndex());
                    ParquetWriteProtocol.this.currentProtocol = MapWriteProtocol.this.valueProtocol;
                }
            });
            this.valueProtocol = ParquetWriteProtocol.this.getProtocol(type.getValue(), this.value, new Events(){
                int consumed;

                @Override
                public void start() {
                    ParquetWriteProtocol.this.recordConsumer.startField(MapWriteProtocol.this.value.getName(), MapWriteProtocol.this.value.getIndex());
                }

                @Override
                public void end() {
                    ++this.consumed;
                    ParquetWriteProtocol.this.recordConsumer.endField(MapWriteProtocol.this.value.getName(), MapWriteProtocol.this.value.getIndex());
                    ParquetWriteProtocol.this.recordConsumer.endGroup();
                    if (this.consumed == MapWriteProtocol.this.countToConsume) {
                        ParquetWriteProtocol.this.currentProtocol = MapWriteProtocol.this;
                        this.consumed = 0;
                    } else {
                        ParquetWriteProtocol.this.currentProtocol = MapWriteProtocol.this.keyProtocol;
                    }
                }
            });
        }

        @Override
        public void writeMapBegin(TMap map) throws TException {
            this.start();
            ParquetWriteProtocol.this.recordConsumer.startGroup();
            this.countToConsume = map.size;
            if (this.countToConsume > 0) {
                ParquetWriteProtocol.this.recordConsumer.startField(this.mapContent.getType().getName(), 0);
                ParquetWriteProtocol.this.currentProtocol = this.keyProtocol;
            }
        }

        @Override
        public void writeMapEnd() throws TException {
            if (this.countToConsume > 0) {
                ParquetWriteProtocol.this.recordConsumer.endField(this.mapContent.getType().getName(), 0);
            }
            ParquetWriteProtocol.this.recordConsumer.endGroup();
            this.end();
        }
    }

    class ListWriteProtocol
    extends FieldBaseWriteProtocol {
        private ColumnIO listContent;
        private TProtocol contentProtocol;
        private int size;

        public ListWriteProtocol(GroupColumnIO columnIO, ThriftField values, Events returnClause) {
            super(returnClause);
            this.listContent = columnIO.getChild(0);
            this.contentProtocol = ParquetWriteProtocol.this.getProtocol(values, this.listContent, new Events(){
                int consumedRecords = 0;

                @Override
                public void start() {
                }

                @Override
                public void end() {
                    ++this.consumedRecords;
                    if (this.consumedRecords == ListWriteProtocol.this.size) {
                        ParquetWriteProtocol.this.currentProtocol = ListWriteProtocol.this;
                        this.consumedRecords = 0;
                    }
                }
            });
        }

        private void startListWrapper() {
            this.start();
            ParquetWriteProtocol.this.recordConsumer.startGroup();
            if (this.size > 0) {
                ParquetWriteProtocol.this.recordConsumer.startField(this.listContent.getType().getName(), 0);
                ParquetWriteProtocol.this.currentProtocol = this.contentProtocol;
            }
        }

        private void endListWrapper() {
            if (this.size > 0) {
                ParquetWriteProtocol.this.recordConsumer.endField(this.listContent.getType().getName(), 0);
            }
            ParquetWriteProtocol.this.recordConsumer.endGroup();
            this.end();
        }

        @Override
        public void writeListBegin(TList list) throws TException {
            this.size = list.size;
            this.startListWrapper();
        }

        @Override
        public void writeListEnd() throws TException {
            this.endListWrapper();
        }

        @Override
        public void writeSetBegin(TSet set) throws TException {
            this.size = set.size;
            this.startListWrapper();
        }

        @Override
        public void writeSetEnd() throws TException {
            this.endListWrapper();
        }
    }

    class EnumWriteProtocol
    extends FieldBaseWriteProtocol {
        private final ThriftType.EnumType type;
        private PrimitiveColumnIO columnIO;

        public EnumWriteProtocol(PrimitiveColumnIO columnIO, ThriftType.EnumType type, Events returnClause) {
            super(returnClause);
            this.columnIO = columnIO;
            this.type = type;
        }

        @Override
        public void writeI32(int i32) throws TException {
            this.start();
            ThriftType.EnumValue value = this.type.getEnumValueById(i32);
            if (value == null) {
                throw new ParquetEncodingException("Can not find enum value of index " + i32 + " for field:" + this.columnIO.toString());
            }
            ParquetWriteProtocol.this.recordConsumer.addBinary(Binary.fromString((String)value.getName()));
            this.end();
        }
    }

    abstract class FieldBaseWriteProtocol
    extends ParquetProtocol {
        private final Events returnClause;

        public FieldBaseWriteProtocol(Events returnClause) {
            this.returnClause = returnClause;
        }

        void start() {
            this.returnClause.start();
        }

        void end() {
            this.returnClause.end();
        }
    }

    static interface Events {
        public void start();

        public void end();
    }
}

