/*
 * Decompiled with CFR 0.152.
 */
package parquet.thrift;

import com.twitter.data.proto.tutorial.thrift.AddressBook;
import com.twitter.data.proto.tutorial.thrift.Name;
import com.twitter.data.proto.tutorial.thrift.Person;
import com.twitter.data.proto.tutorial.thrift.PhoneNumber;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.thrift.ThriftParquetReader;
import parquet.thrift.ThriftParquetWriter;

public class TestThriftParquetReaderWriter {
    @Test
    public void testWriteRead() throws IOException {
        Path f = new Path("target/test/TestThriftParquetReaderWriter");
        Configuration configuration = new Configuration();
        FileSystem fs = f.getFileSystem(configuration);
        if (fs.exists(f)) {
            fs.delete(f, true);
        }
        AddressBook original = new AddressBook(Arrays.asList(new Person(new Name("Bob", "Roberts"), 1, "bob@roberts.com", Arrays.asList(new PhoneNumber("5555555555")))));
        ThriftParquetWriter thriftParquetWriter = new ThriftParquetWriter(f, AddressBook.class, CompressionCodecName.UNCOMPRESSED);
        thriftParquetWriter.write((Object)original);
        thriftParquetWriter.close();
        ThriftParquetReader thriftParquetReader = new ThriftParquetReader(f, AddressBook.class);
        AddressBook read = (AddressBook)thriftParquetReader.read();
        Assert.assertEquals((Object)original, (Object)read);
        thriftParquetReader.close();
        thriftParquetReader = new ThriftParquetReader(f);
        read = (AddressBook)thriftParquetReader.read();
        Assert.assertEquals((Object)original, (Object)read);
        thriftParquetReader.close();
    }
}

