/*
 * Decompiled with CFR 0.152.
 */
package parquet.thrift.struct;

import parquet.thrift.struct.ThriftType;

public enum ThriftTypeID {
    STOP(0),
    VOID(1),
    BOOL(2, ThriftType.BoolType.class),
    BYTE(3, ThriftType.ByteType.class),
    DOUBLE(4, ThriftType.DoubleType.class),
    I16(6, ThriftType.I16Type.class),
    I32(8, ThriftType.I32Type.class),
    I64(10, ThriftType.I64Type.class),
    STRING(11, ThriftType.StringType.class),
    STRUCT(12, true, ThriftType.StructType.class),
    MAP(13, true, ThriftType.MapType.class),
    SET(14, true, ThriftType.SetType.class),
    LIST(15, true, ThriftType.ListType.class),
    ENUM(16, 8, ThriftType.EnumType.class);

    private static ThriftTypeID[] types;
    private final byte thriftType;
    private final boolean complex;
    private final Class<? extends ThriftType> clss;
    private final byte serializedThriftType;

    private ThriftTypeID(byte thriftType, Class<? extends ThriftType> clss) {
        this(thriftType, thriftType, clss);
    }

    private ThriftTypeID(byte thriftType, byte serializedThriftType, Class<? extends ThriftType> clss) {
        this(thriftType, serializedThriftType, false, clss);
    }

    private ThriftTypeID(byte thriftType) {
        this(thriftType, thriftType, false, null);
    }

    private ThriftTypeID(byte thriftType, boolean complex, Class<? extends ThriftType> clss) {
        this(thriftType, thriftType, complex, clss);
    }

    private ThriftTypeID(byte thriftType, byte serializedThriftType, boolean complex, Class<? extends ThriftType> clss) {
        this.thriftType = thriftType;
        this.serializedThriftType = serializedThriftType;
        this.complex = complex;
        this.clss = clss;
    }

    public byte getThriftType() {
        return this.thriftType;
    }

    public boolean isComplex() {
        return this.complex;
    }

    public Class<? extends ThriftType> getType() {
        return this.clss;
    }

    public static ThriftTypeID fromByte(byte type) {
        return types[type];
    }

    public byte getSerializedThriftType() {
        return this.serializedThriftType;
    }

    static {
        types = new ThriftTypeID[17];
        ThriftTypeID[] arr$ = ThriftTypeID.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ThriftTypeID t;
            ThriftTypeID.types[t.thriftType] = t = arr$[i$];
        }
    }
}

