/*
 * Decompiled with CFR 0.152.
 */
package parquet.thrift.struct;

import parquet.org.codehaus.jackson.annotate.JsonCreator;
import parquet.org.codehaus.jackson.annotate.JsonProperty;
import parquet.thrift.struct.JSON;
import parquet.thrift.struct.ThriftType;

public class ThriftField {
    private final String name;
    private final short fieldId;
    private final Requirement requirement;
    private final ThriftType type;

    @JsonCreator
    public ThriftField(@JsonProperty(value="name") String name, @JsonProperty(value="fieldId") short fieldId, @JsonProperty(value="requirement") Requirement requirement, @JsonProperty(value="type") ThriftType type) {
        this.name = name;
        this.fieldId = fieldId;
        this.requirement = requirement;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public short getFieldId() {
        return this.fieldId;
    }

    public ThriftType getType() {
        return this.type;
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public String toString() {
        return JSON.toJSON(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ThriftField)) {
            return false;
        }
        ThriftField that = (ThriftField)o;
        if (this.fieldId != that.fieldId) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.requirement != that.requirement) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.fieldId;
        result = 31 * result + this.requirement.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public static enum Requirement {
        REQUIRED(1),
        OPTIONAL(2),
        DEFAULT(3);

        private final byte requirement;

        private Requirement(byte requirement) {
            this.requirement = requirement;
        }

        public byte getRequirement() {
            return this.requirement;
        }

        public static Requirement fromType(byte fieldRequirementType) {
            for (Requirement req : Requirement.values()) {
                if (req.requirement != fieldRequirementType) continue;
                return req;
            }
            throw new RuntimeException("Unknown requirement " + fieldRequirementType);
        }
    }
}

