/*
 * Decompiled with CFR 0.152.
 */
package parquet.thrift.struct;

import parquet.thrift.struct.CompatibilityReport;
import parquet.thrift.struct.ThriftField;
import parquet.thrift.struct.ThriftType;

class CompatibleCheckerVisitor
implements ThriftType.TypeVisitor {
    ThriftType oldType;
    CompatibilityReport report = new CompatibilityReport();

    CompatibleCheckerVisitor(ThriftType.StructType oldType) {
        this.oldType = oldType;
    }

    public CompatibilityReport getReport() {
        return this.report;
    }

    @Override
    public void visit(ThriftType.MapType mapType) {
        ThriftType.MapType currentOldType = (ThriftType.MapType)this.oldType;
        ThriftField oldKeyField = currentOldType.getKey();
        ThriftField newKeyField = mapType.getKey();
        ThriftField newValueField = mapType.getValue();
        ThriftField oldValueField = currentOldType.getValue();
        this.checkField(oldKeyField, newKeyField);
        this.checkField(oldValueField, newValueField);
        this.oldType = currentOldType;
    }

    @Override
    public void visit(ThriftType.SetType setType) {
        ThriftType.SetType currentOldType = (ThriftType.SetType)this.oldType;
        ThriftField oldField = currentOldType.getValues();
        ThriftField newField = setType.getValues();
        this.checkField(oldField, newField);
        this.oldType = currentOldType;
    }

    @Override
    public void visit(ThriftType.ListType listType) {
        ThriftType.ListType currentOldType = (ThriftType.ListType)this.oldType;
        ThriftField oldField = currentOldType.getValues();
        ThriftField newField = listType.getValues();
        this.checkField(oldField, newField);
        this.oldType = currentOldType;
    }

    public void fail(String message) {
        this.report.fail(message);
    }

    private void checkField(ThriftField oldField, ThriftField newField) {
        if (!newField.getType().getType().equals((Object)oldField.getType().getType())) {
            this.fail("type is not compatible: " + oldField.getName() + " " + (Object)((Object)oldField.getType().getType()) + " vs " + (Object)((Object)newField.getType().getType()));
            return;
        }
        if (!newField.getName().equals(oldField.getName())) {
            this.fail("field names are different: " + oldField.getName() + " vs " + newField.getName());
            return;
        }
        if (this.firstIsMoreRestirctive(newField.getRequirement(), oldField.getRequirement())) {
            this.fail("new field is more restrictive: " + newField.getName());
            return;
        }
        this.oldType = oldField.getType();
        newField.getType().accept(this);
    }

    private boolean firstIsMoreRestirctive(ThriftField.Requirement firstReq, ThriftField.Requirement secReq) {
        return firstReq == ThriftField.Requirement.REQUIRED && secReq != ThriftField.Requirement.REQUIRED;
    }

    @Override
    public void visit(ThriftType.StructType newStruct) {
        ThriftType.StructType currentOldType = (ThriftType.StructType)this.oldType;
        short oldMaxId = 0;
        for (ThriftField oldField : currentOldType.getChildren()) {
            ThriftField newField;
            short fieldId = oldField.getFieldId();
            if (fieldId > oldMaxId) {
                oldMaxId = fieldId;
            }
            if ((newField = newStruct.getChildById(fieldId)) == null) {
                this.fail("can not find index in new Struct: " + fieldId + " in " + newStruct);
                return;
            }
            this.checkField(oldField, newField);
        }
        for (ThriftField newField : newStruct.getChildren()) {
            if (newField.getRequirement() != ThriftField.Requirement.REQUIRED) continue;
            short newFieldId = newField.getFieldId();
            if (newFieldId > oldMaxId) {
                this.fail("new required field " + newField.getName() + " is added");
                return;
            }
            if (newFieldId >= oldMaxId || currentOldType.getChildById(newFieldId) != null) continue;
            this.fail("new required field " + newField.getName() + " is added");
            return;
        }
        this.oldType = currentOldType;
    }

    @Override
    public void visit(ThriftType.EnumType enumType) {
    }

    @Override
    public void visit(ThriftType.BoolType boolType) {
    }

    @Override
    public void visit(ThriftType.ByteType byteType) {
    }

    @Override
    public void visit(ThriftType.DoubleType doubleType) {
    }

    @Override
    public void visit(ThriftType.I16Type i16Type) {
    }

    @Override
    public void visit(ThriftType.I32Type i32Type) {
    }

    @Override
    public void visit(ThriftType.I64Type i64Type) {
    }

    @Override
    public void visit(ThriftType.StringType stringType) {
    }
}

