/*
 * Decompiled with CFR 0.152.
 */
package parquet.thrift.pig;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.pig.StoreFunc;
import org.apache.pig.data.Tuple;
import parquet.hadoop.ParquetOutputFormat;
import parquet.hadoop.api.WriteSupport;
import parquet.io.ParquetEncodingException;
import parquet.thrift.pig.TupleToThriftWriteSupport;

public class ParquetThriftStorer
extends StoreFunc {
    private RecordWriter<Void, Tuple> recordWriter;
    private String className;

    public ParquetThriftStorer(String[] params) {
        if (params == null || params.length != 1) {
            throw new IllegalArgumentException("required the thrift class name in parameter. Got " + Arrays.toString(params) + " instead");
        }
        this.className = params[0];
    }

    public OutputFormat<Void, Tuple> getOutputFormat() throws IOException {
        return new ParquetOutputFormat((WriteSupport)new TupleToThriftWriteSupport(this.className));
    }

    public void prepareToWrite(RecordWriter recordWriter) throws IOException {
        this.recordWriter = recordWriter;
    }

    public void putNext(Tuple tuple) throws IOException {
        try {
            this.recordWriter.write(null, (Object)tuple);
        }
        catch (InterruptedException e) {
            throw new ParquetEncodingException("Interrupted while writing", (Throwable)e);
        }
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(location));
    }
}

