/*
 * Decompiled with CFR 0.152.
 */
package parquet.scrooge;

import com.twitter.scrooge.ThriftStructCodec;
import com.twitter.scrooge.ThriftStructFieldInfo;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import parquet.scrooge.ScroogeSchemaConversionException;
import parquet.thrift.struct.ThriftField;
import parquet.thrift.struct.ThriftType;
import parquet.thrift.struct.ThriftTypeID;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.reflect.Manifest;

public class ScroogeStructConverter {
    public ThriftType.StructType convert(Class scroogeClass) {
        return this.convertStructFromClass(scroogeClass);
    }

    private Class getCompanionClass(Class klass) {
        try {
            return Class.forName(klass.getName() + "$");
        }
        catch (ClassNotFoundException e) {
            throw new ScroogeSchemaConversionException("Can not find companion object for scrooge class " + klass, e);
        }
    }

    private ThriftType.StructType convertStructFromClass(Class klass) {
        return this.convertCompanionClassToStruct(this.getCompanionClass(klass));
    }

    private ThriftType.StructType convertCompanionClassToStruct(Class<?> companionClass) {
        ThriftStructCodec companionObject = null;
        try {
            companionObject = (ThriftStructCodec)companionClass.getField("MODULE$").get(null);
        }
        catch (ReflectiveOperationException e) {
            throw new ScroogeSchemaConversionException("Can not get ThriftStructCodec from companion object of " + companionClass.getName(), e);
        }
        LinkedList<ThriftField> children = new LinkedList<ThriftField>();
        java.lang.Iterable<ThriftStructFieldInfo> scroogeFields = this.getFieldInfos(companionObject);
        for (ThriftStructFieldInfo field : scroogeFields) {
            children.add(this.toThriftField(field));
        }
        return new ThriftType.StructType(children);
    }

    private java.lang.Iterable<ThriftStructFieldInfo> getFieldInfos(ThriftStructCodec c) {
        Class<?> klass = c.getClass();
        if (this.isUnion(klass)) {
            return this.getFieldInfosForUnion(klass);
        }
        try {
            Object r = klass.getMethod("fieldInfos", new Class[0]).invoke((Object)c, new Object[0]);
            java.lang.Iterable a = JavaConversions$.MODULE$.asJavaIterable((Iterable)r);
            return a;
        }
        catch (ReflectiveOperationException e) {
            throw new ScroogeSchemaConversionException("can not get field Info from: " + c.toString(), e);
        }
    }

    private java.lang.Iterable<ThriftStructFieldInfo> getFieldInfosForUnion(Class klass) {
        ArrayList<ThriftStructFieldInfo> fields = new ArrayList<ThriftStructFieldInfo>();
        for (Field f : klass.getDeclaredFields()) {
            if (!f.getType().equals(Manifest.class)) continue;
            Class unionClass = (Class)((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0];
            Class companionUnionClass = this.getCompanionClass(unionClass);
            try {
                Object companionUnionObj = companionUnionClass.getField("MODULE$").get(null);
                ThriftStructFieldInfo info = (ThriftStructFieldInfo)companionUnionClass.getMethod("fieldInfo", new Class[0]).invoke(companionUnionObj, new Object[0]);
                fields.add(info);
            }
            catch (ReflectiveOperationException e) {
                throw new ScroogeSchemaConversionException("can not find fiedInfo for " + unionClass, e);
            }
        }
        return fields;
    }

    private boolean isUnion(Class klass) {
        for (Field f : klass.getDeclaredFields()) {
            if (!f.getName().equals("Union")) continue;
            return true;
        }
        return false;
    }

    private ThriftField.Requirement getRequirementType(ThriftStructFieldInfo f) {
        if (f.isOptional() && !f.isRequired()) {
            return ThriftField.Requirement.OPTIONAL;
        }
        if (f.isRequired() && !f.isOptional()) {
            return ThriftField.Requirement.REQUIRED;
        }
        if (!f.isOptional() && !f.isRequired()) {
            return ThriftField.Requirement.DEFAULT;
        }
        throw new ScroogeSchemaConversionException("can not determine requirement type for : " + f.toString() + ", isOptional=" + f.isOptional() + ", isRequired=" + f.isRequired());
    }

    public ThriftField toThriftField(ThriftStructFieldInfo scroogeField) {
        ThriftType.BoolType thriftType;
        ThriftField.Requirement requirement = this.getRequirementType(scroogeField);
        String fieldName = scroogeField.tfield().name;
        short fieldId = scroogeField.tfield().id;
        byte thriftTypeByte = scroogeField.tfield().type;
        ThriftTypeID typeId = ThriftTypeID.fromByte((byte)thriftTypeByte);
        switch (typeId) {
            case BOOL: {
                thriftType = new ThriftType.BoolType();
                break;
            }
            case BYTE: {
                thriftType = new ThriftType.ByteType();
                break;
            }
            case DOUBLE: {
                thriftType = new ThriftType.DoubleType();
                break;
            }
            case I16: {
                thriftType = new ThriftType.I16Type();
                break;
            }
            case I32: {
                thriftType = new ThriftType.I32Type();
                break;
            }
            case I64: {
                thriftType = new ThriftType.I64Type();
                break;
            }
            case STRING: {
                thriftType = new ThriftType.StringType();
                break;
            }
            case STRUCT: {
                thriftType = this.convertStructTypeField(scroogeField);
                break;
            }
            case MAP: {
                thriftType = this.convertMapTypeField(scroogeField, requirement);
                break;
            }
            case SET: {
                thriftType = this.convertSetTypeField(scroogeField, requirement);
                break;
            }
            case LIST: {
                thriftType = this.convertListTypeField(scroogeField, requirement);
                break;
            }
            case ENUM: {
                thriftType = this.convertEnumTypeField(scroogeField);
                break;
            }
            default: {
                throw new IllegalArgumentException("can't convert type " + typeId);
            }
        }
        return new ThriftField(fieldName, fieldId, requirement, (ThriftType)thriftType);
    }

    private ThriftType convertSetTypeField(ThriftStructFieldInfo f, ThriftField.Requirement requirement) {
        ThriftType elementType = this.convertClassToThriftType(((Manifest)f.valueManifest().get()).runtimeClass());
        ThriftField elementField = this.generateFieldWithoutId(f.tfield().name, requirement, elementType);
        return new ThriftType.SetType(elementField);
    }

    private ThriftType convertListTypeField(ThriftStructFieldInfo f, ThriftField.Requirement requirement) {
        ThriftType elementType = this.convertClassToThriftType(((Manifest)f.valueManifest().get()).runtimeClass());
        ThriftField elementField = this.generateFieldWithoutId(f.tfield().name, requirement, elementType);
        return new ThriftType.ListType(elementField);
    }

    private ThriftType convertMapTypeField(ThriftStructFieldInfo f, ThriftField.Requirement requirement) {
        ThriftType keyType = this.convertClassToThriftType(((Manifest)f.keyManifest().get()).runtimeClass());
        ThriftField keyField = this.generateFieldWithoutId(f.tfield().name + "_map_key", requirement, keyType);
        ThriftType valueType = this.convertClassToThriftType(((Manifest)f.valueManifest().get()).runtimeClass());
        ThriftField valueField = this.generateFieldWithoutId(f.tfield().name + "_map_value", requirement, valueType);
        return new ThriftType.MapType(keyField, valueField);
    }

    private ThriftField generateFieldWithoutId(String fieldName, ThriftField.Requirement requirement, ThriftType thriftType) {
        return new ThriftField(fieldName, 1, requirement, thriftType);
    }

    private ThriftType convertClassToThriftType(Class typeClass) {
        if (typeClass == Boolean.TYPE) {
            return new ThriftType.BoolType();
        }
        if (typeClass == Byte.TYPE) {
            return new ThriftType.ByteType();
        }
        if (typeClass == Double.TYPE) {
            return new ThriftType.DoubleType();
        }
        if (typeClass == Short.TYPE) {
            return new ThriftType.I16Type();
        }
        if (typeClass == Integer.TYPE) {
            return new ThriftType.I32Type();
        }
        if (typeClass == Long.TYPE) {
            return new ThriftType.I64Type();
        }
        if (typeClass == String.class) {
            return new ThriftType.StringType();
        }
        return this.convertStructFromClass(typeClass);
    }

    private ThriftType convertStructTypeField(ThriftStructFieldInfo f) {
        return this.convertStructFromClass(f.manifest().runtimeClass());
    }

    private List getEnumList(String enumName) throws ClassNotFoundException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, InvocationTargetException {
        enumName = enumName + "$";
        Class<?> companionObjectClass = Class.forName(enumName);
        Object cObject = companionObjectClass.getField("MODULE$").get(null);
        Method listMethod = companionObjectClass.getMethod("list", new Class[0]);
        Object result = listMethod.invoke(cObject, null);
        return JavaConversions.asJavaList((Seq)((Seq)result));
    }

    public ThriftType convertEnumTypeField(ThriftStructFieldInfo f) {
        ArrayList<ThriftType.EnumValue> enumValues = new ArrayList<ThriftType.EnumValue>();
        String enumName = f.manifest().runtimeClass().getName();
        try {
            List enumCollection = this.getEnumList(enumName);
            for (Object enumObj : enumCollection) {
                ScroogeEnumDesc enumDesc = ScroogeEnumDesc.getEnumDesc(enumObj);
                enumValues.add(new ThriftType.EnumValue(enumDesc.id, enumDesc.originalName));
            }
            return new ThriftType.EnumType(enumValues);
        }
        catch (ReflectiveOperationException e) {
            throw new ScroogeSchemaConversionException("Can not convert enum field " + f, e);
        }
    }

    private static class ScroogeEnumDesc {
        private int id;
        private String name;
        private String originalName;

        private ScroogeEnumDesc() {
        }

        public static ScroogeEnumDesc getEnumDesc(Object rawScroogeEnum) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            Class<?> enumClass = rawScroogeEnum.getClass();
            Method valueMethod = enumClass.getMethod("value", new Class[0]);
            Method nameMethod = enumClass.getMethod("name", new Class[0]);
            Method originalNameMethod = enumClass.getMethod("originalName", new Class[0]);
            ScroogeEnumDesc result = new ScroogeEnumDesc();
            result.id = (Integer)valueMethod.invoke(rawScroogeEnum, null);
            result.name = (String)nameMethod.invoke(rawScroogeEnum, null);
            result.originalName = (String)originalNameMethod.invoke(rawScroogeEnum, null);
            return result;
        }
    }
}

