/*
 * Decompiled with CFR 0.152.
 */
package parquet.scrooge;

import cascading.flow.FlowProcess;
import cascading.tap.Tap;
import com.twitter.scrooge.ThriftStruct;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import parquet.cascading.ParquetValueScheme;
import parquet.filter2.predicate.FilterPredicate;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.ParquetOutputFormat;
import parquet.hadoop.mapred.DeprecatedParquetInputFormat;
import parquet.hadoop.mapred.DeprecatedParquetOutputFormat;
import parquet.hadoop.thrift.ThriftReadSupport;
import parquet.scrooge.ScroogeReadSupport;
import parquet.scrooge.ScroogeRecordConverter;
import parquet.scrooge.ScroogeWriteSupport;

public class ParquetScroogeScheme<T extends ThriftStruct>
extends ParquetValueScheme<T> {
    private static final long serialVersionUID = -8332274507341448397L;

    public ParquetScroogeScheme(Class<T> klass) {
        this(new ParquetValueScheme.Config().withRecordClass(klass));
    }

    public ParquetScroogeScheme(FilterPredicate filterPredicate, Class<T> klass) {
        this(new ParquetValueScheme.Config().withFilterPredicate(filterPredicate).withRecordClass(klass));
    }

    public ParquetScroogeScheme(ParquetValueScheme.Config<T> config) {
        super(config);
    }

    public void sinkConfInit(FlowProcess<JobConf> fp, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf jobConf) {
        jobConf.setOutputFormat(DeprecatedParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((JobConf)jobConf, ScroogeWriteSupport.class);
        ScroogeWriteSupport.setScroogeClass((Configuration)jobConf, this.config.getKlass());
    }

    public void sourceConfInit(FlowProcess<JobConf> fp, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf jobConf) {
        super.sourceConfInit(fp, tap, jobConf);
        jobConf.setInputFormat(DeprecatedParquetInputFormat.class);
        ParquetInputFormat.setReadSupportClass((JobConf)jobConf, ScroogeReadSupport.class);
        ThriftReadSupport.setRecordConverterClass((JobConf)jobConf, ScroogeRecordConverter.class);
    }
}

