/*
 * Decompiled with CFR 0.152.
 */
package parquet.proto;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageOrBuilder;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import parquet.proto.TestUtils;
import parquet.proto.test.TestProtobuf;

public class ProtoRecordConverterTest {
    @Test
    public void testSimple() throws Exception {
        TestProtobuf.SchemaConverterAllDatatypes.Builder data = TestProtobuf.SchemaConverterAllDatatypes.newBuilder();
        data.setOptionalBool(true);
        data.setOptionalBytes(ByteString.copyFrom((String)"someText", (String)"UTF-8"));
        data.setOptionalDouble(0.577);
        data.setOptionalFloat(3.1415f);
        data.setOptionalEnum(TestProtobuf.SchemaConverterAllDatatypes.TestEnum.FIRST);
        data.setOptionalFixed32(1000000);
        data.setOptionalFixed64(2000000000L);
        data.setOptionalInt32(3000000);
        data.setOptionalInt64(4000000000L);
        data.setOptionalSFixed32(5000000);
        data.setOptionalSFixed64(6000000000L);
        data.setOptionalSInt32(56000000);
        data.setOptionalSInt64(7000000000L);
        data.setOptionalString("Good Will Hunting");
        data.setOptionalUInt32(8000000);
        data.setOptionalUInt64(9000000000L);
        TestProtobuf.SchemaConverterAllDatatypes dataBuilt = data.build();
        data.clear();
        List result = TestUtils.testData((MessageOrBuilder[])new TestProtobuf.SchemaConverterAllDatatypes[]{dataBuilt});
    }

    @Test
    public void testAllTypes() throws Exception {
        TestProtobuf.SchemaConverterAllDatatypes.Builder data = TestProtobuf.SchemaConverterAllDatatypes.newBuilder();
        data.setOptionalBool(true);
        data.setOptionalBytes(ByteString.copyFrom((String)"someText", (String)"UTF-8"));
        data.setOptionalDouble(0.577);
        data.setOptionalFloat(3.1415f);
        data.setOptionalEnum(TestProtobuf.SchemaConverterAllDatatypes.TestEnum.FIRST);
        data.setOptionalFixed32(1000000);
        data.setOptionalFixed64(2000000000L);
        data.setOptionalInt32(3000000);
        data.setOptionalInt64(4000000000L);
        data.setOptionalSFixed32(5000000);
        data.setOptionalSFixed64(6000000000L);
        data.setOptionalSInt32(56000000);
        data.setOptionalSInt64(7000000000L);
        data.setOptionalString("Good Will Hunting");
        data.setOptionalUInt32(8000000);
        data.setOptionalUInt64(9000000000L);
        data.getOptionalMessageBuilder().setSomeId(1984);
        data.getPbGroupBuilder().setGroupInt(1492);
        TestProtobuf.SchemaConverterAllDatatypes dataBuilt = data.build();
        data.clear();
        List result = TestUtils.testData((MessageOrBuilder[])new TestProtobuf.SchemaConverterAllDatatypes[]{dataBuilt});
        TestProtobuf.SchemaConverterAllDatatypes o = (TestProtobuf.SchemaConverterAllDatatypes)result.get(0);
        Assert.assertEquals((Object)"Good Will Hunting", (Object)o.getOptionalString());
        Assert.assertEquals((Object)true, (Object)o.getOptionalBool());
        Assert.assertEquals((Object)ByteString.copyFrom((String)"someText", (String)"UTF-8"), (Object)o.getOptionalBytes());
        Assert.assertEquals((double)0.577, (double)o.getOptionalDouble(), (double)1.0E-5);
        Assert.assertEquals((double)3.1415f, (double)o.getOptionalFloat(), (double)1.0E-5);
        Assert.assertEquals((Object)((Object)TestProtobuf.SchemaConverterAllDatatypes.TestEnum.FIRST), (Object)((Object)o.getOptionalEnum()));
        Assert.assertEquals((long)1000000L, (long)o.getOptionalFixed32());
        Assert.assertEquals((long)2000000000L, (long)o.getOptionalFixed64());
        Assert.assertEquals((long)3000000L, (long)o.getOptionalInt32());
        Assert.assertEquals((long)4000000000L, (long)o.getOptionalInt64());
        Assert.assertEquals((long)5000000L, (long)o.getOptionalSFixed32());
        Assert.assertEquals((long)6000000000L, (long)o.getOptionalSFixed64());
        Assert.assertEquals((long)56000000L, (long)o.getOptionalSInt32());
        Assert.assertEquals((long)7000000000L, (long)o.getOptionalSInt64());
        Assert.assertEquals((long)8000000L, (long)o.getOptionalUInt32());
        Assert.assertEquals((long)9000000000L, (long)o.getOptionalUInt64());
        Assert.assertEquals((long)1984L, (long)o.getOptionalMessage().getSomeId());
        Assert.assertEquals((long)1492L, (long)o.getPbGroup().getGroupInt());
    }

    @Test
    public void testAllTypesMultiple() throws Exception {
        int count = 100;
        MessageOrBuilder[] input = new TestProtobuf.SchemaConverterAllDatatypes[count];
        for (int i = 0; i < count; ++i) {
            TestProtobuf.SchemaConverterAllDatatypes.Builder d = TestProtobuf.SchemaConverterAllDatatypes.newBuilder();
            if (i % 2 != 0) {
                d.setOptionalBool(true);
            }
            if (i % 3 != 0) {
                d.setOptionalBytes(ByteString.copyFrom((String)("someText " + i), (String)"UTF-8"));
            }
            if (i % 4 != 0) {
                d.setOptionalDouble(0.577 * (double)i);
            }
            if (i % 5 != 0) {
                d.setOptionalFloat(3.1415f * (float)i);
            }
            if (i % 6 != 0) {
                d.setOptionalEnum(TestProtobuf.SchemaConverterAllDatatypes.TestEnum.FIRST);
            }
            if (i % 7 != 0) {
                d.setOptionalFixed32(1000 * i * 1);
            }
            if (i % 8 != 0) {
                d.setOptionalFixed64(1000 * i * 1000 * 2);
            }
            if (i % 9 != 0) {
                d.setOptionalInt32(1000 * i * 3);
            }
            if (i % 2 != 1) {
                d.setOptionalSFixed32(1000 * i * 5);
            }
            if (i % 3 != 1) {
                d.setOptionalSFixed64(1000 * i * 1000 * 6);
            }
            if (i % 4 != 1) {
                d.setOptionalSInt32(1000 * i * 56);
            }
            if (i % 5 != 1) {
                d.setOptionalSInt64(1000 * i * 1000 * 7);
            }
            if (i % 6 != 1) {
                d.setOptionalString("Good Will Hunting " + i);
            }
            if (i % 7 != 1) {
                d.setOptionalUInt32(1000 * i * 8);
            }
            if (i % 8 != 1) {
                d.setOptionalUInt64(1000 * i * 1000 * 9);
            }
            if (i % 9 != 1) {
                d.getOptionalMessageBuilder().setSomeId(1984 * i);
            }
            if (i % 2 != 1) {
                d.getPbGroupBuilder().setGroupInt(1492 * i);
            }
            if (i % 3 != 1) {
                d.setOptionalInt64(1000 * i * 1000 * 4);
            }
            input[i] = d.build();
        }
        List result = TestUtils.testData((MessageOrBuilder[])input);
        Assert.assertEquals((Object)"Good Will Hunting 0", (Object)((TestProtobuf.SchemaConverterAllDatatypes)result.get(0)).getOptionalString());
        Assert.assertEquals((Object)"Good Will Hunting 90", (Object)((TestProtobuf.SchemaConverterAllDatatypes)result.get(90)).getOptionalString());
    }

    @Test
    public void testDefaults() throws Exception {
        TestProtobuf.SchemaConverterAllDatatypes.Builder data = TestProtobuf.SchemaConverterAllDatatypes.newBuilder();
        List result = TestUtils.testData((MessageOrBuilder[])new TestProtobuf.SchemaConverterAllDatatypes[]{data.build()});
        TestProtobuf.SchemaConverterAllDatatypes message = (TestProtobuf.SchemaConverterAllDatatypes)result.get(0);
        Assert.assertEquals((Object)"", (Object)message.getOptionalString());
        Assert.assertEquals((Object)false, (Object)message.getOptionalBool());
        Assert.assertEquals((long)0L, (long)message.getOptionalFixed32());
    }

    @Test
    public void testRepeatedMessages() throws Exception {
        TestProtobuf.TopMessage.Builder top = TestProtobuf.TopMessage.newBuilder();
        top.addInnerBuilder().setOne("First inner");
        top.addInnerBuilder().setTwo("Second inner");
        top.addInnerBuilder().setThree("Third inner");
        TestProtobuf.TopMessage result = (TestProtobuf.TopMessage)TestUtils.testData((MessageOrBuilder[])new TestProtobuf.TopMessage[]{top.build()}).get(0);
        Assert.assertEquals((long)3L, (long)result.getInnerCount());
        TestProtobuf.InnerMessage first = result.getInner(0);
        TestProtobuf.InnerMessage second = result.getInner(1);
        TestProtobuf.InnerMessage third = result.getInner(2);
        Assert.assertEquals((Object)"First inner", (Object)first.getOne());
        Assert.assertFalse((boolean)first.hasTwo());
        Assert.assertFalse((boolean)first.hasThree());
        Assert.assertEquals((Object)"Second inner", (Object)second.getTwo());
        Assert.assertFalse((boolean)second.hasOne());
        Assert.assertFalse((boolean)second.hasThree());
        Assert.assertEquals((Object)"Third inner", (Object)third.getThree());
        Assert.assertFalse((boolean)third.hasOne());
        Assert.assertFalse((boolean)third.hasTwo());
    }

    @Test
    public void testRepeatedInt() throws Exception {
        TestProtobuf.RepeatedIntMessage.Builder top = TestProtobuf.RepeatedIntMessage.newBuilder();
        top.addRepeatedInt(1);
        top.addRepeatedInt(2);
        top.addRepeatedInt(3);
        TestProtobuf.RepeatedIntMessage result = (TestProtobuf.RepeatedIntMessage)TestUtils.testData((MessageOrBuilder[])new TestProtobuf.RepeatedIntMessage[]{top.build()}).get(0);
        Assert.assertEquals((long)3L, (long)result.getRepeatedIntCount());
        Assert.assertEquals((long)1L, (long)result.getRepeatedInt(0));
        Assert.assertEquals((long)2L, (long)result.getRepeatedInt(1));
        Assert.assertEquals((long)3L, (long)result.getRepeatedInt(2));
    }

    @Test
    public void testLargeProtobufferFieldId() throws Exception {
        TestProtobuf.HighIndexMessage.Builder builder = TestProtobuf.HighIndexMessage.newBuilder();
        builder.addRepeatedInt(1);
        builder.addRepeatedInt(2);
        TestUtils.testData((MessageOrBuilder[])new TestProtobuf.HighIndexMessage[]{builder.build()});
    }
}

