/*
 * Decompiled with CFR 0.152.
 */
package parquet.proto.utils;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import parquet.proto.ProtoParquetInputFormat;
import parquet.proto.utils.WriteUsingMR;

public class ReadUsingMR {
    private static List<Message> outputMessages;
    Configuration conf = new Configuration();
    private String projection;

    public void setRequestedProjection(String projection) {
        this.projection = projection;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> read(Path parquetPath) throws Exception {
        Class<ReadUsingMR> clazz = ReadUsingMR.class;
        synchronized (ReadUsingMR.class) {
            outputMessages = new ArrayList<Message>();
            Job job = new Job(this.conf, "read");
            job.setInputFormatClass(ProtoParquetInputFormat.class);
            ProtoParquetInputFormat.setInputPaths((Job)job, (Path[])new Path[]{parquetPath});
            if (this.projection != null) {
                ProtoParquetInputFormat.setRequestedProjection((Job)job, (String)this.projection);
            }
            job.setMapperClass(ReadingMapper.class);
            job.setNumReduceTasks(0);
            job.setOutputFormatClass(NullOutputFormat.class);
            WriteUsingMR.waitForJob(job);
            List<Message> result = Collections.unmodifiableList(outputMessages);
            outputMessages = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    public static class ReadingMapper
    extends Mapper<Void, MessageOrBuilder, LongWritable, Message> {
        protected void map(Void key, MessageOrBuilder value, Mapper.Context context) throws IOException, InterruptedException {
            Message clone = ((Message.Builder)value).build();
            outputMessages.add(clone);
        }
    }
}

