/*
 * Decompiled with CFR 0.152.
 */
package parquet.proto;

import com.google.protobuf.Message;
import org.junit.Assert;
import org.junit.Test;
import parquet.proto.ProtoSchemaConverter;
import parquet.proto.test.TestProtobuf;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;

public class ProtoSchemaConverterTest {
    private void testConversion(Class<? extends Message> pbClass, String parquetSchemaString) throws Exception {
        ProtoSchemaConverter protoSchemaConverter = new ProtoSchemaConverter();
        MessageType schema = protoSchemaConverter.convert(pbClass);
        MessageType expectedMT = MessageTypeParser.parseMessageType((String)parquetSchemaString);
        Assert.assertEquals((Object)expectedMT.toString(), (Object)schema.toString());
    }

    @Test
    public void testConvertAllDatatypes() throws Exception {
        String expectedSchema = "message TestProtobuf.SchemaConverterAllDatatypes {\n  optional double optionalDouble = 1;\n  optional float optionalFloat = 2;\n  optional int32 optionalInt32 = 3;\n  optional int64 optionalInt64 = 4;\n  optional int32 optionalUInt32 = 5;\n  optional int64 optionalUInt64 = 6;\n  optional int32 optionalSInt32 = 7;\n  optional int64 optionalSInt64 = 8;\n  optional int32 optionalFixed32 = 9;\n  optional int64 optionalFixed64 = 10;\n  optional int32 optionalSFixed32 = 11;\n  optional int64 optionalSFixed64 = 12;\n  optional boolean optionalBool = 13;\n  optional binary optionalString (UTF8) = 14;\n  optional binary optionalBytes = 15;\n  optional group optionalMessage = 16 {\n    optional int32 someId = 3;\n  }\n  optional group pbgroup = 17 {\n    optional int32 groupInt = 2;\n  }\n optional binary optionalEnum (ENUM)  = 18;}";
        this.testConversion(TestProtobuf.SchemaConverterAllDatatypes.class, expectedSchema);
    }

    @Test
    public void testConvertRepetition() throws Exception {
        String expectedSchema = "message TestProtobuf.SchemaConverterRepetition {\n  optional int32 optionalPrimitive = 1;\n  required int32 requiredPrimitive = 2;\n  repeated int32 repeatedPrimitive = 3;\n  optional group optionalMessage = 7 {\n    optional int32 someId = 3;\n  }\n  required group requiredMessage = 8 {    optional int32 someId= 3;\n  }\n  repeated group repeatedMessage = 9 {    optional int32 someId = 3;\n  }\n}";
        this.testConversion(TestProtobuf.SchemaConverterRepetition.class, expectedSchema);
    }
}

