/*
 * Decompiled with CFR 0.152.
 */
package parquet.proto;

import com.google.protobuf.Message;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;
import parquet.Log;
import parquet.proto.test.TestProtobuf;
import parquet.proto.utils.ReadUsingMR;
import parquet.proto.utils.WriteUsingMR;

public class ProtoInputOutputFormatTest {
    private static final Log LOG = Log.getLog(ProtoInputOutputFormatTest.class);

    @Test
    public void testInputOutput() throws Exception {
        TestProtobuf.IOFormatMessage.Builder msg = TestProtobuf.IOFormatMessage.newBuilder();
        msg.setOptionalDouble(666.0);
        msg.addRepeatedString("Msg1");
        msg.addRepeatedString("Msg2");
        msg.getMsgBuilder().setSomeId(323);
        TestProtobuf.IOFormatMessage input = msg.build();
        List<Message> result = ProtoInputOutputFormatTest.runMRJobs(new Message[]{input});
        Assert.assertEquals((long)1L, (long)result.size());
        TestProtobuf.IOFormatMessage output = (TestProtobuf.IOFormatMessage)result.get(0);
        Assert.assertEquals((double)666.0, (double)output.getOptionalDouble(), (double)1.0E-5);
        Assert.assertEquals((long)323L, (long)output.getMsg().getSomeId());
        Assert.assertEquals((Object)"Msg1", (Object)output.getRepeatedString(0));
        Assert.assertEquals((Object)"Msg2", (Object)output.getRepeatedString(1));
        Assert.assertEquals((Object)input, (Object)output);
    }

    @Test
    public void testProjection() throws Exception {
        TestProtobuf.Document.Builder writtenDocument = TestProtobuf.Document.newBuilder();
        writtenDocument.setDocId(12345L);
        writtenDocument.addNameBuilder().setUrl("http://goout.cz/");
        Path outputPath = new WriteUsingMR().write(new Message[]{writtenDocument.build()});
        ReadUsingMR reader = new ReadUsingMR();
        String projection = "message Document {required int64 DocId; }";
        reader.setRequestedProjection(projection);
        List<Message> output = reader.read(outputPath);
        TestProtobuf.Document readDocument = (TestProtobuf.Document)output.get(0);
        Assert.assertTrue((boolean)readDocument.hasDocId());
        Assert.assertTrue((String)"Found data outside projection.", (readDocument.getNameCount() == 0 ? 1 : 0) != 0);
    }

    public static List<Message> runMRJobs(Message ... messages) throws Exception {
        Path outputPath = new WriteUsingMR().write(messages);
        List<Message> result = new ReadUsingMR().read(outputPath);
        return result;
    }
}

