/*
 * Decompiled with CFR 0.152.
 */
package parquet.proto;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import org.apache.hadoop.conf.Configuration;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import parquet.io.api.Binary;
import parquet.io.api.RecordConsumer;
import parquet.proto.ProtoWriteSupport;
import parquet.proto.test.TestProtobuf;

public class ProtoWriteSupportTest {
    private <T extends Message> ProtoWriteSupport<T> createReadConsumerInstance(Class<T> cls, RecordConsumer readConsumerMock) {
        ProtoWriteSupport support = new ProtoWriteSupport(cls);
        support.init(new Configuration());
        support.prepareForWrite(readConsumerMock);
        return support;
    }

    @Test
    public void testSimplestMessage() throws Exception {
        RecordConsumer readConsumerMock = (RecordConsumer)Mockito.mock(RecordConsumer.class);
        ProtoWriteSupport<TestProtobuf.InnerMessage> instance = this.createReadConsumerInstance(TestProtobuf.InnerMessage.class, readConsumerMock);
        TestProtobuf.InnerMessage.Builder msg = TestProtobuf.InnerMessage.newBuilder();
        msg.setOne("oneValue");
        instance.write((MessageOrBuilder)msg.build());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{readConsumerMock});
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).startMessage();
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).startField("one", 0);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).addBinary(Binary.fromByteArray((byte[])"oneValue".getBytes()));
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).endField("one", 0);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).endMessage();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{readConsumerMock});
    }

    @Test
    public void testRepeatedIntMessage() throws Exception {
        RecordConsumer readConsumerMock = (RecordConsumer)Mockito.mock(RecordConsumer.class);
        ProtoWriteSupport<TestProtobuf.RepeatedIntMessage> instance = this.createReadConsumerInstance(TestProtobuf.RepeatedIntMessage.class, readConsumerMock);
        TestProtobuf.RepeatedIntMessage.Builder msg = TestProtobuf.RepeatedIntMessage.newBuilder();
        msg.addRepeatedInt(1323);
        msg.addRepeatedInt(54469);
        instance.write((MessageOrBuilder)msg.build());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{readConsumerMock});
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).startMessage();
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).startField("repeatedInt", 0);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).addInteger(1323);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).addInteger(54469);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).endField("repeatedInt", 0);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).endMessage();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{readConsumerMock});
    }

    @Test
    public void testRepeatedInnerMessageMessage_message() throws Exception {
        RecordConsumer readConsumerMock = (RecordConsumer)Mockito.mock(RecordConsumer.class);
        ProtoWriteSupport<TestProtobuf.TopMessage> instance = this.createReadConsumerInstance(TestProtobuf.TopMessage.class, readConsumerMock);
        TestProtobuf.TopMessage.Builder msg = TestProtobuf.TopMessage.newBuilder();
        msg.addInnerBuilder().setOne("one").setTwo("two");
        instance.write((MessageOrBuilder)msg.build());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{readConsumerMock});
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).startMessage();
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).startField("inner", 0);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).startGroup();
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).startField("one", 0);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).addBinary(Binary.fromByteArray((byte[])"one".getBytes()));
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).endField("one", 0);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).startField("two", 1);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).addBinary(Binary.fromByteArray((byte[])"two".getBytes()));
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).endField("two", 1);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).endGroup();
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).endField("inner", 0);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).endMessage();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{readConsumerMock});
    }

    @Test
    public void testRepeatedInnerMessageMessage_scalar() throws Exception {
        RecordConsumer readConsumerMock = (RecordConsumer)Mockito.mock(RecordConsumer.class);
        ProtoWriteSupport<TestProtobuf.TopMessage> instance = this.createReadConsumerInstance(TestProtobuf.TopMessage.class, readConsumerMock);
        TestProtobuf.TopMessage.Builder msg = TestProtobuf.TopMessage.newBuilder();
        msg.addInnerBuilder().setOne("one");
        msg.addInnerBuilder().setTwo("two");
        instance.write((MessageOrBuilder)msg.build());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{readConsumerMock});
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).startMessage();
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).startField("inner", 0);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).startGroup();
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).startField("one", 0);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).addBinary(Binary.fromByteArray((byte[])"one".getBytes()));
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).endField("one", 0);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).endGroup();
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).startGroup();
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).startField("two", 1);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).addBinary(Binary.fromByteArray((byte[])"two".getBytes()));
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).endField("two", 1);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).endGroup();
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).endField("inner", 0);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).endMessage();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{readConsumerMock});
    }

    @Test
    public void testOptionalInnerMessage() throws Exception {
        RecordConsumer readConsumerMock = (RecordConsumer)Mockito.mock(RecordConsumer.class);
        ProtoWriteSupport<TestProtobuf.MessageA> instance = this.createReadConsumerInstance(TestProtobuf.MessageA.class, readConsumerMock);
        TestProtobuf.MessageA.Builder msg = TestProtobuf.MessageA.newBuilder();
        msg.getInnerBuilder().setOne("one");
        instance.write((MessageOrBuilder)msg.build());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{readConsumerMock});
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).startMessage();
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).startField("inner", 0);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).startGroup();
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).startField("one", 0);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).addBinary(Binary.fromByteArray((byte[])"one".getBytes()));
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).endField("one", 0);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).endGroup();
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).endField("inner", 0);
        ((RecordConsumer)inOrder.verify((Object)readConsumerMock)).endMessage();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{readConsumerMock});
    }
}

