/*
 * Decompiled with CFR 0.152.
 */
package parquet.proto;

import com.google.protobuf.Message;
import org.junit.Assert;
import org.junit.Test;
import parquet.proto.ProtoSchemaConverter;
import parquet.proto.test.TestProtobuf;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;

public class ProtoSchemaConverterTest {
    private void testConversion(Class<? extends Message> pbClass, String parquetSchemaString) throws Exception {
        ProtoSchemaConverter protoSchemaConverter = new ProtoSchemaConverter();
        MessageType schema = protoSchemaConverter.convert(pbClass);
        MessageType expectedMT = MessageTypeParser.parseMessageType((String)parquetSchemaString);
        Assert.assertEquals((Object)expectedMT.toString(), (Object)schema.toString());
    }

    @Test
    public void testConvertAllDatatypes() throws Exception {
        String expectedSchema = "message TestProtobuf.SchemaConverterAllDatatypes {\n  optional double optionalDouble;\n  optional float optionalFloat;\n  optional int32 optionalInt32;\n  optional int64 optionalInt64;\n  optional int32 optionalUInt32;\n  optional int64 optionalUInt64;\n  optional int32 optionalSInt32;\n  optional int64 optionalSInt64;\n  optional int32 optionalFixed32;\n  optional int64 optionalFixed64;\n  optional int32 optionalSFixed32;\n  optional int64 optionalSFixed64;\n  optional boolean optionalBool;\n  optional binary optionalString (UTF8);\n  optional binary optionalBytes;\n  optional group optionalMessage {\n    optional int32 someId;\n  }\n  optional group pbgroup {\n    optional int32 groupInt;\n  }\n optional binary optionalEnum (ENUM);}";
        this.testConversion(TestProtobuf.SchemaConverterAllDatatypes.class, expectedSchema);
    }

    @Test
    public void testConvertRepetition() throws Exception {
        String expectedSchema = "message TestProtobuf.SchemaConverterRepetition {\n  optional int32 optionalPrimitive;\n  required int32 requiredPrimitive;\n  repeated int32 repeatedPrimitive;\n  optional group optionalMessage {\n    optional int32 someId;\n  }\n  required group requiredMessage {    optional int32 someId;\n  }\n  repeated group repeatedMessage {    optional int32 someId;\n  }\n}";
        this.testConversion(TestProtobuf.SchemaConverterRepetition.class, expectedSchema);
    }
}

