/*
 * Decompiled with CFR 0.152.
 */
package parquet.proto;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import parquet.proto.ProtoParquetReader;
import parquet.proto.ProtoParquetWriter;

public class TestUtils {
    public static Path someTemporaryFilePath() throws IOException {
        File tmp = File.createTempFile("ParquetProtobuf_unitTest", ".tmp");
        tmp.deleteOnExit();
        tmp.delete();
        return new Path(tmp.getPath());
    }

    public static <T extends MessageOrBuilder> List<T> writeAndRead(T ... records) throws IOException {
        Class<? extends Message> cls = TestUtils.inferRecordsClass(records);
        Path file = TestUtils.writeMessages(cls, records);
        return TestUtils.readMessages(file);
    }

    public static Class<? extends Message> inferRecordsClass(MessageOrBuilder[] records) {
        Class<?> cls = null;
        for (MessageOrBuilder record : records) {
            Class<?> recordClass;
            if (record instanceof Message.Builder) {
                recordClass = ((Message.Builder)record).build().getClass();
            } else if (record instanceof Message) {
                recordClass = ((Message)record).getClass();
            } else {
                throw new RuntimeException("Illegal class " + record);
            }
            if (cls == null) {
                cls = recordClass;
                continue;
            }
            if (cls.equals(recordClass)) continue;
            throw new RuntimeException("Class mismatch :" + cls + " and " + recordClass);
        }
        return cls;
    }

    public static <T extends MessageOrBuilder> List<T> testData(T ... messages) throws IOException {
        TestUtils.checkSameBuilderInstance(messages);
        List<MessageOrBuilder> input = TestUtils.cloneList(messages);
        List output = TestUtils.writeAndRead(messages);
        List<Message> outputAsMessages = TestUtils.asMessages(output);
        Assert.assertEquals((String)"The protocol buffers are not same:\n", TestUtils.asMessages(input), outputAsMessages);
        return outputAsMessages;
    }

    private static List<MessageOrBuilder> cloneList(MessageOrBuilder[] messages) {
        ArrayList<MessageOrBuilder> result = new ArrayList<MessageOrBuilder>();
        for (MessageOrBuilder mob : messages) {
            result.add((MessageOrBuilder)TestUtils.asMessage(mob));
        }
        return result;
    }

    public static List<Message> asMessages(List<MessageOrBuilder> mobs) {
        ArrayList<Message> result = new ArrayList<Message>();
        for (MessageOrBuilder messageOrBuilder : mobs) {
            result.add(TestUtils.asMessage(messageOrBuilder));
        }
        return result;
    }

    public static Message asMessage(MessageOrBuilder mob) {
        Message message = mob instanceof Message.Builder ? ((Message.Builder)mob).build() : (Message)mob;
        return message;
    }

    private static void checkSameBuilderInstance(MessageOrBuilder[] messages) {
        for (int i = 0; i < messages.length; ++i) {
            MessageOrBuilder firstMessage = messages[i];
            boolean isBuilder = firstMessage instanceof Message.Builder;
            if (!isBuilder) continue;
            for (int j = 0; j < messages.length; ++j) {
                boolean isSame;
                MessageOrBuilder secondMessage = messages[j];
                if (i == j) continue;
                boolean bl = isSame = secondMessage == firstMessage;
                if (!isSame) continue;
                Assert.fail((String)("Data contains two references to same instance." + secondMessage));
            }
        }
    }

    public static <T extends MessageOrBuilder> List<T> readMessages(Path file) throws IOException {
        ProtoParquetReader reader = new ProtoParquetReader(file);
        ArrayList<Message.Builder> result = new ArrayList<Message.Builder>();
        boolean hasNext = true;
        while (hasNext) {
            MessageOrBuilder item = (MessageOrBuilder)reader.read();
            if (item == null) {
                hasNext = false;
                continue;
            }
            Assert.assertNotNull((Object)item);
            result.add(TestUtils.asMessage(item).toBuilder());
        }
        reader.close();
        return result;
    }

    public static Path writeMessages(MessageOrBuilder ... records) throws IOException {
        return TestUtils.writeMessages(TestUtils.inferRecordsClass(records), records);
    }

    public static Path writeMessages(Class<? extends Message> cls, MessageOrBuilder ... records) throws IOException {
        Path file = TestUtils.someTemporaryFilePath();
        ProtoParquetWriter writer = new ProtoParquetWriter(file, cls);
        for (MessageOrBuilder record : records) {
            writer.write((Object)record);
        }
        writer.close();
        return file;
    }
}

