/*
 * Decompiled with CFR 0.152.
 */
package parquet.pig.convert;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.NonSpillableDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import parquet.column.Dictionary;
import parquet.io.ParquetDecodingException;
import parquet.io.api.Binary;
import parquet.io.api.Converter;
import parquet.io.api.GroupConverter;
import parquet.io.api.PrimitiveConverter;
import parquet.pig.TupleConversionException;
import parquet.pig.convert.MapConverter;
import parquet.pig.convert.ParentValueContainer;
import parquet.schema.GroupType;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;

public class TupleConverter
extends GroupConverter {
    private static final TupleFactory TF = TupleFactory.getInstance();
    private final int schemaSize;
    protected Tuple currentTuple;
    private final Converter[] converters;
    private final GroupType parquetSchema;
    private final boolean elephantBirdCompatible;
    private static final Integer I32_ZERO = 0;
    private static final Long I64_ZERO = 0L;
    private static final Float FLOAT_ZERO = Float.valueOf(0.0f);
    private static final Double DOUBLE_ZERO = 0.0;

    public TupleConverter(GroupType parquetSchema, Schema pigSchema, boolean elephantBirdCompatible, boolean columnIndexAccess) {
        this.parquetSchema = parquetSchema;
        this.elephantBirdCompatible = elephantBirdCompatible;
        try {
            this.schemaSize = Math.max(parquetSchema.getFieldCount(), pigSchema.getFields().size());
            this.converters = new Converter[this.schemaSize];
            int c = 0;
            for (int i = 0; i < this.schemaSize; ++i) {
                Type type;
                Schema.FieldSchema field = pigSchema.getField(i);
                if (!parquetSchema.containsField(field.alias) && !columnIndexAccess || (type = this.getType(columnIndexAccess, field.alias, i)) == null) continue;
                final int index = i;
                this.converters[c++] = TupleConverter.newConverter(field, type, new ParentValueContainer(){

                    @Override
                    void add(Object value) {
                        TupleConverter.this.set(index, value);
                    }
                }, elephantBirdCompatible, columnIndexAccess);
            }
        }
        catch (FrontendException e) {
            throw new ParquetDecodingException("can not initialize pig converter from:\n" + parquetSchema + "\n" + pigSchema, (Throwable)e);
        }
    }

    private Type getType(boolean columnIndexAccess, String alias, int index) {
        if (columnIndexAccess) {
            if (index < this.parquetSchema.getFieldCount()) {
                return this.parquetSchema.getType(index);
            }
        } else {
            return this.parquetSchema.getType(this.parquetSchema.getFieldIndex(alias));
        }
        return null;
    }

    static Converter newConverter(Schema.FieldSchema pigField, Type type, final ParentValueContainer parent, boolean elephantBirdCompatible, boolean columnIndexAccess) {
        try {
            switch (pigField.type) {
                case 120: {
                    return new BagConverter(type.asGroupType(), pigField, parent, elephantBirdCompatible, columnIndexAccess);
                }
                case 100: {
                    return new MapConverter(type.asGroupType(), pigField, parent, elephantBirdCompatible, columnIndexAccess);
                }
                case 110: {
                    return new TupleConverter(type.asGroupType(), pigField.schema, elephantBirdCompatible, columnIndexAccess){

                        @Override
                        public void end() {
                            super.end();
                            parent.add(this.currentTuple);
                        }
                    };
                }
                case 55: {
                    return new FieldStringConverter(parent, type.getOriginalType() == OriginalType.UTF8);
                }
                case 50: {
                    return new FieldByteArrayConverter(parent);
                }
                case 10: {
                    return new FieldIntegerConverter(parent);
                }
                case 5: {
                    if (elephantBirdCompatible) {
                        return new FieldIntegerConverter(parent);
                    }
                    return new FieldBooleanConverter(parent);
                }
                case 20: {
                    return new FieldFloatConverter(parent);
                }
                case 25: {
                    return new FieldDoubleConverter(parent);
                }
                case 15: {
                    return new FieldLongConverter(parent);
                }
            }
            throw new TupleConversionException("unsupported pig type: " + pigField);
        }
        catch (FrontendException e) {
            throw new TupleConversionException("error while preparing converter for:\n" + pigField + "\n" + type, e);
        }
        catch (RuntimeException e) {
            throw new TupleConversionException("error while preparing converter for:\n" + pigField + "\n" + type, e);
        }
    }

    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    public final void start() {
        this.currentTuple = TF.newTuple(this.schemaSize);
        if (this.elephantBirdCompatible) {
            try {
                int i = 0;
                for (Type field : this.parquetSchema.getFields()) {
                    if (field.isPrimitive() && field.isRepetition(Type.Repetition.OPTIONAL)) {
                        PrimitiveType primitiveType = field.asPrimitiveType();
                        switch (primitiveType.getPrimitiveTypeName()) {
                            case INT32: {
                                this.currentTuple.set(i, (Object)I32_ZERO);
                                break;
                            }
                            case INT64: {
                                this.currentTuple.set(i, (Object)I64_ZERO);
                                break;
                            }
                            case FLOAT: {
                                this.currentTuple.set(i, (Object)FLOAT_ZERO);
                                break;
                            }
                            case DOUBLE: {
                                this.currentTuple.set(i, (Object)DOUBLE_ZERO);
                                break;
                            }
                            case BOOLEAN: {
                                this.currentTuple.set(i, (Object)I32_ZERO);
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (ExecException e) {
                throw new RuntimeException(e);
            }
        }
    }

    final void set(int fieldIndex, Object value) {
        try {
            this.currentTuple.set(fieldIndex, value);
        }
        catch (ExecException e) {
            throw new TupleConversionException("Could not set " + value + " to current tuple " + this.currentTuple + " at " + fieldIndex, e);
        }
    }

    public void end() {
    }

    public final Tuple getCurrentTuple() {
        return this.currentTuple;
    }

    static class BagConverter
    extends GroupConverter {
        private final List<Tuple> buffer = new ArrayList<Tuple>();
        private final Converter child;
        private final ParentValueContainer parent;

        BagConverter(GroupType parquetSchema, Schema.FieldSchema pigSchema, ParentValueContainer parent, boolean numbersDefaultToZero, boolean columnIndexAccess) throws FrontendException {
            Schema.FieldSchema pigField;
            ParentValueContainer childsParent;
            this.parent = parent;
            if (parquetSchema.getFieldCount() != 1) {
                throw new IllegalArgumentException("bags have only one field. " + parquetSchema + " size = " + parquetSchema.getFieldCount());
            }
            Type nestedType = parquetSchema.getType(0);
            if (nestedType.isPrimitive() || nestedType.getOriginalType() == OriginalType.MAP || nestedType.getOriginalType() == OriginalType.LIST) {
                childsParent = new ParentValueContainer(){

                    @Override
                    void add(Object value) {
                        BagConverter.this.buffer.add(TF.newTuple(value));
                    }
                };
                pigField = pigSchema.schema.getField((int)0).schema.getField(0);
            } else {
                childsParent = new ParentValueContainer(){

                    @Override
                    void add(Object value) {
                        BagConverter.this.buffer.add((Tuple)value);
                    }
                };
                pigField = pigSchema.schema.getField(0);
            }
            this.child = TupleConverter.newConverter(pigField, nestedType, childsParent, numbersDefaultToZero, columnIndexAccess);
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex != 0) {
                throw new IllegalArgumentException("bags have only one field. can't reach " + fieldIndex);
            }
            return this.child;
        }

        public final void start() {
            this.buffer.clear();
        }

        public void end() {
            this.parent.add(new NonSpillableDataBag(new ArrayList<Tuple>(this.buffer)));
        }
    }

    static final class FieldBooleanConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        public FieldBooleanConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public final void addBoolean(boolean value) {
            this.parent.add(value);
        }

        public final void addInt(int value) {
            this.parent.add(value != 0);
        }

        public void addLong(long value) {
            this.parent.add(value != 0L);
        }

        public void addFloat(float value) {
            this.parent.add(value != 0.0f);
        }

        public void addDouble(double value) {
            this.parent.add(value != 0.0);
        }

        public void addBinary(Binary value) {
            this.parent.add(Boolean.parseBoolean(value.toStringUsingUTF8()));
        }
    }

    static final class FieldIntegerConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        public FieldIntegerConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public final void addBoolean(boolean value) {
            this.parent.add(value ? 1 : 0);
        }

        public final void addInt(int value) {
            this.parent.add(value);
        }

        public void addLong(long value) {
            this.parent.add((int)value);
        }

        public void addFloat(float value) {
            this.parent.add((int)value);
        }

        public void addDouble(double value) {
            this.parent.add((int)value);
        }

        public void addBinary(Binary value) {
            this.parent.add(Integer.parseInt(value.toStringUsingUTF8()));
        }
    }

    static final class FieldLongConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        public FieldLongConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public final void addLong(long value) {
            this.parent.add(value);
        }

        public void addInt(int value) {
            this.parent.add(value);
        }

        public void addFloat(float value) {
            this.parent.add((long)value);
        }

        public void addDouble(double value) {
            this.parent.add((long)value);
        }

        public void addBoolean(boolean value) {
            this.parent.add(value ? 1L : 0L);
        }

        public void addBinary(Binary value) {
            this.parent.add(Long.parseLong(value.toStringUsingUTF8()));
        }
    }

    static final class FieldFloatConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        public FieldFloatConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public final void addFloat(float value) {
            this.parent.add(Float.valueOf(value));
        }

        public void addLong(long value) {
            this.parent.add(Float.valueOf(value));
        }

        public void addInt(int value) {
            this.parent.add(Float.valueOf(value));
        }

        public void addDouble(double value) {
            this.parent.add(Float.valueOf((float)value));
        }

        public void addBoolean(boolean value) {
            this.parent.add(Float.valueOf(value ? 1.0f : 0.0f));
        }

        public void addBinary(Binary value) {
            this.parent.add(Float.valueOf(Float.parseFloat(value.toStringUsingUTF8())));
        }
    }

    static final class FieldDoubleConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        public FieldDoubleConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public final void addDouble(double value) {
            this.parent.add(value);
        }

        public void addLong(long value) {
            this.parent.add(value);
        }

        public void addInt(int value) {
            this.parent.add(value);
        }

        public void addFloat(float value) {
            this.parent.add(value);
        }

        public void addBoolean(boolean value) {
            this.parent.add(value ? 1.0 : 0.0);
        }

        public void addBinary(Binary value) {
            this.parent.add(Double.parseDouble(value.toStringUsingUTF8()));
        }
    }

    static final class FieldByteArrayConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        public FieldByteArrayConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public final void addBinary(Binary value) {
            this.parent.add(new DataByteArray(value.getBytes()));
        }
    }

    static final class FieldStringConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;
        private boolean dictionarySupport;
        private String[] dict;

        public FieldStringConverter(ParentValueContainer parent, boolean dictionarySupport) {
            this.parent = parent;
            this.dictionarySupport = dictionarySupport;
        }

        public final void addBinary(Binary value) {
            this.parent.add(value.toStringUsingUTF8());
        }

        public boolean hasDictionarySupport() {
            return this.dictionarySupport;
        }

        public void setDictionary(Dictionary dictionary) {
            this.dict = new String[dictionary.getMaxId() + 1];
            for (int i = 0; i <= dictionary.getMaxId(); ++i) {
                this.dict[i] = dictionary.decodeToBinary(i).toStringUsingUTF8();
            }
        }

        public void addValueFromDictionary(int dictionaryId) {
            this.parent.add(this.dict[dictionaryId]);
        }

        public void addLong(long value) {
            this.parent.add(Long.toString(value));
        }

        public void addInt(int value) {
            this.parent.add(Integer.toString(value));
        }

        public void addFloat(float value) {
            this.parent.add(Float.toString(value));
        }

        public void addDouble(double value) {
            this.parent.add(Double.toString(value));
        }

        public void addBoolean(boolean value) {
            this.parent.add(Boolean.toString(value));
        }
    }
}

