/*
 * Decompiled with CFR 0.152.
 */
package parquet.pig;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.Utils;
import org.junit.Assert;
import org.junit.Test;
import parquet.pig.PigSchemaConverter;
import parquet.pig.TupleReadSupport;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;
import parquet.schema.Type;

public class TestPigSchemaConverter {
    private final PigSchemaConverter pigSchemaConverter = new PigSchemaConverter();

    private void testPigConversion(String pigSchemaString) throws Exception {
        Schema pigSchema = Utils.getSchemaFromString((String)pigSchemaString);
        MessageType parquetSchema = this.pigSchemaConverter.convert(pigSchema);
        Schema convertedSchema = this.pigSchemaConverter.convert(parquetSchema);
        Assert.assertEquals((Object)pigSchema, (Object)convertedSchema);
    }

    @Test
    public void testSimpleBag() throws Exception {
        this.testPigConversion("b:{t:(a:int)}");
    }

    @Test
    public void testMultiBag() throws Exception {
        this.testPigConversion("x:int, b:{t:(a:int,b:chararray)}");
    }

    @Test
    public void testMapSimple() throws Exception {
        this.testPigConversion("b:[(c:int)]");
    }

    @Test
    public void testMapTuple() throws Exception {
        this.testPigConversion("a:chararray, b:[(c:chararray, d:chararray)]");
    }

    @Test
    public void testMapOfList() throws Exception {
        this.testPigConversion("a:map[{bag: (a:int)}]");
    }

    private void testConversion(String pigSchemaString, String schemaString) throws Exception {
        Schema pigSchema = Utils.getSchemaFromString((String)pigSchemaString);
        MessageType schema = this.pigSchemaConverter.convert(pigSchema);
        MessageType expectedMT = MessageTypeParser.parseMessageType((String)schemaString);
        Assert.assertEquals((String)("converting " + pigSchemaString + " to " + schemaString), (Object)expectedMT, (Object)schema);
        MessageType filtered = this.pigSchemaConverter.filter(schema, pigSchema, null);
        Assert.assertEquals((String)("converting " + pigSchemaString + " to " + schemaString + " and filtering"), (Object)schema.toString(), (Object)filtered.toString());
    }

    @Test
    public void testTupleBag() throws Exception {
        this.testConversion("a:chararray, b:{t:(c:chararray, d:chararray)}", "message pig_schema {\n  optional binary a;\n  optional group b {\n    repeated group t {\n      optional binary c;\n      optional binary d;\n    }\n  }\n}\n");
    }

    @Test
    public void testTupleBagWithAnonymousInnerField() throws Exception {
        this.testConversion("a:chararray, b:{(c:chararray, d:chararray)}", "message pig_schema {\n  optional binary a;\n  optional group b {\n    repeated group bag {\n      optional binary c;\n      optional binary d;\n    }\n  }\n}\n");
    }

    @Test
    public void testMap() throws Exception {
        this.testConversion("a:chararray, b:[(c:chararray, d:chararray)]", "message pig_schema {\n  optional binary a;\n  optional group b {\n    repeated group map {\n      required binary key;\n      optional group value {\n        optional binary c;\n        optional binary d;\n      }\n    }\n  }\n}\n");
    }

    @Test
    public void testMap2() throws Exception {
        this.testConversion("a:map[int]", "message pig_schema {\n  optional group a {\n    repeated group map {\n      required binary key;\n      optional int32 value;    }\n  }\n}\n");
    }

    @Test
    public void testMap3() throws Exception {
        this.testConversion("a:map[map[int]]", "message pig_schema {\n  optional group a {\n    repeated group map {\n      required binary key;\n      optional group value {\n        repeated group map {\n          required binary key;\n          optional int32 value;\n        }\n      }\n    }\n  }\n}\n");
    }

    @Test
    public void testMap4() throws Exception {
        this.testConversion("a:map[bag{(a:int)}]", "message pig_schema {\n  optional group a {\n    repeated group map {\n      required binary key;\n      optional group value {\n        repeated group bag {\n          optional int32 a;\n        }\n      }\n    }\n  }\n}\n");
    }

    private void testFixedConversion(String schemaString, String pigSchemaString) throws Exception {
        Schema expectedPigSchema = Utils.getSchemaFromString((String)pigSchemaString);
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)schemaString);
        Schema pigSchema = this.pigSchemaConverter.convert(parquetSchema);
        Assert.assertEquals((String)("converting " + schemaString + " to " + pigSchemaString), (Object)expectedPigSchema, (Object)pigSchema);
    }

    @Test
    public void testMapWithFixed() throws Exception {
        this.testFixedConversion("message pig_schema {\n  optional binary a;\n  optional group b (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required binary key;\n      optional group value {\n        optional fixed_len_byte_array(5) c;\n        optional fixed_len_byte_array(7) d;\n      }\n    }\n  }\n}\n", "a:bytearray, b:[(c:bytearray, d:bytearray)]");
    }

    @Test
    public void testAnnonymousField() throws Exception {
        this.testConversion("a:chararray, int", "message pig_schema {\n  optional binary a;\n  optional int32 val_0;\n}\n");
    }

    @Test
    public void testSchemaEvolution() {
        LinkedHashMap<String, LinkedHashSet<String>> map = new LinkedHashMap<String, LinkedHashSet<String>>();
        map.put("pig.schema", new LinkedHashSet<String>(Arrays.asList("a:int, b:int, c:int, d:int, e:int, f:int", "aa:int, aaa:int, b:int, c:int, ee:int")));
        Schema result = TupleReadSupport.getPigSchemaFromMultipleFiles((MessageType)new MessageType("empty", new Type[0]), map);
        Assert.assertEquals((Object)"a: int,b: int,c: int,d: int,e: int,f: int,aa: int,aaa: int,ee: int", (Object)PigSchemaConverter.pigSchemaToString((Schema)result));
    }
}

