/*
 * Decompiled with CFR 0.152.
 */
package parquet.pig;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.pig.ResourceSchema;
import org.apache.pig.StoreMetadata;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.parser.ParserException;
import org.junit.Assert;
import parquet.Log;
import parquet.hadoop.util.ContextUtil;
import parquet.pig.ParquetLoader;
import parquet.pig.ParquetStorer;

public class PerfTest2 {
    static final int COLUMN_COUNT = 50;
    private static final long ROW_COUNT = 100000L;
    private static Configuration conf = new Configuration();
    private static int jobid = 0;

    public static void main(String[] args) throws Exception {
        StringBuilder results = new StringBuilder();
        String out = "target/PerfTest2";
        File outDir = new File(out);
        if (outDir.exists()) {
            PerfTest2.clean(outDir);
        }
        PerfTest2.write(out);
        for (int i = 0; i < 2; ++i) {
            PerfTest2.load(out, 1, results);
            PerfTest2.load(out, 2, results);
            PerfTest2.load(out, 3, results);
            PerfTest2.load(out, 4, results);
            PerfTest2.load(out, 5, results);
            PerfTest2.load(out, 10, results);
            PerfTest2.load(out, 20, results);
            PerfTest2.load(out, 50, results);
            results.append("\n");
        }
        System.out.println(results);
    }

    public static void write(String out) throws IOException, ParserException, InterruptedException, ExecException {
        StringBuilder schemaString = new StringBuilder("a0: chararray");
        for (int i = 1; i < 50; ++i) {
            schemaString.append(", a" + i + ": chararray");
        }
        String location = out;
        String schema = schemaString.toString();
        ParquetStorer storer = new ParquetStorer();
        Job job = new Job(conf);
        storer.setStoreFuncUDFContextSignature("sig");
        String absPath = storer.relToAbsPathForStoreLocation(location, new Path(new File(".").getAbsoluteFile().toURI()));
        storer.setStoreLocation(absPath, job);
        storer.checkSchema(new ResourceSchema(Utils.getSchemaFromString((String)schema)));
        OutputFormat outputFormat = storer.getOutputFormat();
        JobContext jobContext = ContextUtil.newJobContext((Configuration)ContextUtil.getConfiguration((JobContext)job), (JobID)new JobID("jt", jobid++));
        outputFormat.checkOutputSpecs(jobContext);
        if (schema != null) {
            ResourceSchema resourceSchema = new ResourceSchema(Utils.getSchemaFromString((String)schema));
            storer.checkSchema(resourceSchema);
            if (storer instanceof StoreMetadata) {
                ((StoreMetadata)storer).storeSchema(resourceSchema, absPath, job);
            }
        }
        TaskAttemptContext taskAttemptContext = ContextUtil.newTaskAttemptContext((Configuration)ContextUtil.getConfiguration((JobContext)job), (TaskAttemptID)new TaskAttemptID("jt", jobid, true, 1, 0));
        RecordWriter recordWriter = outputFormat.getRecordWriter(taskAttemptContext);
        storer.prepareToWrite(recordWriter);
        int i = 0;
        while ((long)i < 100000L) {
            Tuple tuple = TupleFactory.getInstance().newTuple(50);
            for (int j = 0; j < 50; ++j) {
                tuple.set(j, (Object)("a" + i + "_" + j));
            }
            storer.putNext(tuple);
            ++i;
        }
        recordWriter.close(taskAttemptContext);
        OutputCommitter outputCommitter = outputFormat.getOutputCommitter(taskAttemptContext);
        outputCommitter.commitTask(taskAttemptContext);
        outputCommitter.commitJob(jobContext);
    }

    static void clean(File outDir) {
        if (outDir.isDirectory()) {
            File[] listFiles;
            for (File file : listFiles = outDir.listFiles()) {
                PerfTest2.clean(file);
            }
        }
        outDir.delete();
    }

    static void load(String out, int colsToLoad, StringBuilder results) throws Exception {
        StringBuilder schemaString = new StringBuilder("a0: chararray");
        for (int i = 1; i < colsToLoad; ++i) {
            schemaString.append(", a" + i + ": chararray");
        }
        long t0 = System.currentTimeMillis();
        Job job = new Job(conf);
        int loadjobId = jobid++;
        ParquetLoader loadFunc = new ParquetLoader(schemaString.toString());
        loadFunc.setUDFContextSignature("sigLoader" + loadjobId);
        String absPath = loadFunc.relativeToAbsolutePath(out, new Path(new File(".").getAbsoluteFile().toURI()));
        loadFunc.setLocation(absPath, job);
        InputFormat inputFormat = loadFunc.getInputFormat();
        JobContext jobContext = ContextUtil.newJobContext((Configuration)ContextUtil.getConfiguration((JobContext)job), (JobID)new JobID("jt", loadjobId));
        List splits = inputFormat.getSplits(jobContext);
        int i = 0;
        int taskid = 0;
        for (InputSplit split : splits) {
            Tuple t;
            TaskAttemptContext taskAttemptContext = ContextUtil.newTaskAttemptContext((Configuration)ContextUtil.getConfiguration((JobContext)job), (TaskAttemptID)new TaskAttemptID("jt", loadjobId, true, taskid++, 0));
            RecordReader recordReader = inputFormat.createRecordReader(split, taskAttemptContext);
            loadFunc.prepareToRead(recordReader, null);
            recordReader.initialize(split, taskAttemptContext);
            while ((t = loadFunc.getNext()) != null) {
                if (Log.DEBUG) {
                    System.out.println(t);
                }
                ++i;
            }
        }
        Assert.assertEquals((long)100000L, (long)i);
        long t1 = System.currentTimeMillis();
        results.append(t1 - t0 + " ms to read " + colsToLoad + " columns\n");
    }
}

