/*
 * Decompiled with CFR 0.152.
 */
package parquet.pig;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.executionengine.ExecJob;
import org.apache.pig.builtin.mock.Storage;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.junit.Assert;
import org.junit.Test;
import parquet.pig.ParquetLoader;
import parquet.pig.ParquetStorer;

public class TestParquetStorer {
    @Test
    public void testStorer() throws ExecException, Exception {
        String out = "target/out";
        int rows = 1000;
        Properties props = new Properties();
        props.setProperty("parquet.compression", "uncompressed");
        props.setProperty("parquet.page.size", "1000");
        PigServer pigServer = new PigServer(ExecType.LOCAL, props);
        Storage.Data data = Storage.resetData((PigServer)pigServer);
        ArrayList<Tuple> list = new ArrayList<Tuple>();
        for (int i = 0; i < rows; ++i) {
            list.add(Storage.tuple((Object[])new Object[]{"a" + i}));
        }
        data.set("in", "a:chararray", list);
        pigServer.setBatchOn();
        pigServer.registerQuery("A = LOAD 'in' USING mock.Storage();");
        pigServer.deleteFile(out);
        pigServer.registerQuery("Store A into '" + out + "' using " + ParquetStorer.class.getName() + "();");
        if (((ExecJob)pigServer.executeBatch().get(0)).getStatus() != ExecJob.JOB_STATUS.COMPLETED) {
            throw new RuntimeException("Job failed", ((ExecJob)pigServer.executeBatch().get(0)).getException());
        }
        pigServer.registerQuery("B = LOAD '" + out + "' USING " + ParquetLoader.class.getName() + "();");
        pigServer.registerQuery("Store B into 'out' using mock.Storage();");
        if (((ExecJob)pigServer.executeBatch().get(0)).getStatus() != ExecJob.JOB_STATUS.COMPLETED) {
            throw new RuntimeException("Job failed", ((ExecJob)pigServer.executeBatch().get(0)).getException());
        }
        List result = data.get("out");
        Assert.assertEquals((long)rows, (long)result.size());
        int i = 0;
        for (Tuple tuple : result) {
            Assert.assertEquals((Object)("a" + i), (Object)tuple.get(0));
            ++i;
        }
    }

    @Test
    public void testMultipleSchema() throws ExecException, Exception {
        int bi;
        int ai;
        String out = "target/out";
        int rows = 1000;
        Properties props = new Properties();
        props.setProperty("parquet.compression", "uncompressed");
        props.setProperty("parquet.page.size", "1000");
        PigServer pigServer = new PigServer(ExecType.LOCAL, props);
        Storage.Data data = Storage.resetData((PigServer)pigServer);
        ArrayList<Tuple> list1 = new ArrayList<Tuple>();
        for (int i = 0; i < rows; ++i) {
            list1.add(Storage.tuple((Object[])new Object[]{"a" + i}));
        }
        ArrayList<Tuple> list2 = new ArrayList<Tuple>();
        for (int i = 0; i < rows; ++i) {
            list2.add(Storage.tuple((Object[])new Object[]{"b" + i}));
        }
        data.set("a", "a:chararray", list1);
        data.set("b", "b:chararray", list2);
        pigServer.setBatchOn();
        pigServer.registerQuery("A = LOAD 'a' USING mock.Storage();");
        pigServer.registerQuery("B = LOAD 'b' USING mock.Storage();");
        pigServer.deleteFile(out);
        pigServer.registerQuery("Store A into '" + out + "/a' using " + ParquetStorer.class.getName() + "();");
        pigServer.registerQuery("Store B into '" + out + "/b' using " + ParquetStorer.class.getName() + "();");
        if (((ExecJob)pigServer.executeBatch().get(0)).getStatus() != ExecJob.JOB_STATUS.COMPLETED) {
            throw new RuntimeException("Job failed", ((ExecJob)pigServer.executeBatch().get(0)).getException());
        }
        pigServer.registerQuery("B = LOAD '" + out + "/*' USING " + ParquetLoader.class.getName() + "();");
        pigServer.registerQuery("Store B into 'out' using mock.Storage();");
        if (((ExecJob)pigServer.executeBatch().get(0)).getStatus() != ExecJob.JOB_STATUS.COMPLETED) {
            throw new RuntimeException("Job failed", ((ExecJob)pigServer.executeBatch().get(0)).getException());
        }
        List result = data.get("out");
        Schema schema = data.getSchema("out");
        Assert.assertEquals((long)2L, (long)schema.size());
        if ("a".equals(schema.getField((int)0).alias)) {
            ai = 0;
            bi = 1;
            Assert.assertEquals((Object)"a", (Object)schema.getField((int)0).alias);
            Assert.assertEquals((Object)"b", (Object)schema.getField((int)1).alias);
        } else {
            ai = 1;
            bi = 0;
            Assert.assertEquals((Object)"b", (Object)schema.getField((int)0).alias);
            Assert.assertEquals((Object)"a", (Object)schema.getField((int)1).alias);
        }
        Assert.assertEquals((long)(rows * 2), (long)result.size());
        int a = 0;
        int b = 0;
        for (Tuple tuple : result) {
            String fa = (String)tuple.get(ai);
            String fb = (String)tuple.get(bi);
            if (fa != null) {
                Assert.assertEquals((Object)("a" + a), (Object)fa);
                ++a;
            }
            if (fb == null) continue;
            Assert.assertEquals((Object)("b" + b), (Object)fb);
            ++b;
        }
    }

    @Test
    public void testStorerCompressed() throws ExecException, Exception {
        String out = "target/out";
        int rows = 1000;
        Properties props = new Properties();
        props.setProperty("parquet.compression", "gzip");
        props.setProperty("parquet.page.size", "1000");
        PigServer pigServer = new PigServer(ExecType.LOCAL, props);
        Storage.Data data = Storage.resetData((PigServer)pigServer);
        ArrayList<Tuple> list = new ArrayList<Tuple>();
        for (int i = 0; i < rows; ++i) {
            list.add(Storage.tuple((Object[])new Object[]{"a" + i}));
        }
        data.set("in", "a:chararray", list);
        pigServer.setBatchOn();
        pigServer.registerQuery("A = LOAD 'in' USING mock.Storage();");
        pigServer.deleteFile(out);
        pigServer.registerQuery("Store A into '" + out + "' using " + ParquetStorer.class.getName() + "();");
        if (((ExecJob)pigServer.executeBatch().get(0)).getStatus() != ExecJob.JOB_STATUS.COMPLETED) {
            throw new RuntimeException("Job failed", ((ExecJob)pigServer.executeBatch().get(0)).getException());
        }
        pigServer.registerQuery("B = LOAD '" + out + "' USING " + ParquetLoader.class.getName() + "();");
        pigServer.registerQuery("Store B into 'out' using mock.Storage();");
        if (((ExecJob)pigServer.executeBatch().get(0)).getStatus() != ExecJob.JOB_STATUS.COMPLETED) {
            throw new RuntimeException("Job failed", ((ExecJob)pigServer.executeBatch().get(0)).getException());
        }
        List result = data.get("out");
        Assert.assertEquals((long)rows, (long)result.size());
        int i = 0;
        for (Tuple tuple : result) {
            Assert.assertEquals((Object)("a" + i), (Object)tuple.get(0));
            ++i;
        }
    }

    @Test
    public void testComplexSchema() throws ExecException, Exception {
        int i;
        String out = "target/out";
        PigServer pigServer = new PigServer(ExecType.LOCAL);
        Storage.Data data = Storage.resetData((PigServer)pigServer);
        ArrayList<Tuple> list = new ArrayList<Tuple>();
        for (i = 0; i < 1000; ++i) {
            list.add(Storage.tuple((Object[])new Object[]{"a" + i, Storage.bag((Tuple[])new Tuple[]{Storage.tuple((Object[])new Object[]{"o", "b"})})}));
        }
        for (i = 10; i < 2000; ++i) {
            list.add(Storage.tuple((Object[])new Object[]{"a" + i, Storage.bag((Tuple[])new Tuple[]{Storage.tuple((Object[])new Object[]{"o", "b"}), Storage.tuple((Object[])new Object[]{"o", "b"}), Storage.tuple((Object[])new Object[]{"o", "b"}), Storage.tuple((Object[])new Object[]{"o", "b"})})}));
        }
        for (i = 20; i < 3000; ++i) {
            list.add(Storage.tuple((Object[])new Object[]{"a" + i, Storage.bag((Tuple[])new Tuple[]{Storage.tuple((Object[])new Object[]{"o", "b"}), Storage.tuple((Object[])new Object[]{"o", null}), Storage.tuple((Object[])new Object[]{null, "b"}), Storage.tuple((Object[])new Object[]{null, null})})}));
        }
        for (i = 30; i < 4000; ++i) {
            list.add(Storage.tuple((Object[])new Object[]{"a" + i, null}));
        }
        Collections.shuffle((List)list);
        data.set("in", "a:chararray, b:{t:(c:chararray, d:chararray)}", list);
        pigServer.setBatchOn();
        pigServer.registerQuery("A = LOAD 'in' USING mock.Storage();");
        pigServer.deleteFile(out);
        pigServer.registerQuery("Store A into '" + out + "' using " + ParquetStorer.class.getName() + "();");
        if (((ExecJob)pigServer.executeBatch().get(0)).getStatus() != ExecJob.JOB_STATUS.COMPLETED) {
            throw new RuntimeException("Job failed", ((ExecJob)pigServer.executeBatch().get(0)).getException());
        }
        pigServer.registerQuery("B = LOAD '" + out + "' USING " + ParquetLoader.class.getName() + "();");
        pigServer.registerQuery("Store B into 'out' using mock.Storage();");
        if (((ExecJob)pigServer.executeBatch().get(0)).getStatus() != ExecJob.JOB_STATUS.COMPLETED) {
            throw new RuntimeException("Job failed", ((ExecJob)pigServer.executeBatch().get(0)).getException());
        }
        List result = data.get("out");
        Assert.assertEquals(list, (Object)result);
        Schema schema = data.getSchema("out");
        Assert.assertEquals((Object)"{a:chararray, b:{t:(c:chararray, d:chararray)}}".replaceAll(" ", ""), (Object)schema.toString().replaceAll(" ", ""));
        pigServer.registerQuery("C = LOAD '" + out + "' USING " + ParquetLoader.class.getName() + "('a:chararray');");
        pigServer.registerQuery("Store C into 'out2' using mock.Storage();");
        if (((ExecJob)pigServer.executeBatch().get(0)).getStatus() != ExecJob.JOB_STATUS.COMPLETED) {
            throw new RuntimeException("Job failed", ((ExecJob)pigServer.executeBatch().get(0)).getException());
        }
        Function<Tuple, Object> grabFirstColumn = new Function<Tuple, Object>(){

            public Object apply(Tuple input) {
                try {
                    return input.get(0);
                }
                catch (ExecException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        List result2 = data.get("out2");
        Object[] result2int = Collections2.transform((Collection)result2, (Function)grabFirstColumn).toArray();
        Object[] input2int = Collections2.transform(list, (Function)grabFirstColumn).toArray();
        Assert.assertArrayEquals((Object[])input2int, (Object[])result2int);
    }
}

