/*
 * Decompiled with CFR 0.152.
 */
package parquet.pig;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.executionengine.ExecJob;
import org.apache.pig.builtin.mock.Storage;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.junit.Assert;
import parquet.pig.ParquetLoader;
import parquet.pig.ParquetStorer;

public class PerfTest {
    private static final int COLUMN_COUNT = 50;
    private static final long ROW_COUNT = 100000L;
    private static StringBuilder results = new StringBuilder();

    public static void main(String[] args) throws Exception {
        StringBuilder schemaString = new StringBuilder("a0: chararray");
        for (int i = 1; i < 50; ++i) {
            schemaString.append(", a" + i + ": chararray");
        }
        String out = "target/PerfTest";
        PigServer pigServer = new PigServer(ExecType.LOCAL);
        Storage.Data data = Storage.resetData((PigServer)pigServer);
        ArrayList<Tuple> list = new ArrayList<Tuple>();
        int i = 0;
        while ((long)i < 100000L) {
            Tuple tuple = TupleFactory.getInstance().newTuple(50);
            for (int j = 0; j < 50; ++j) {
                tuple.set(j, (Object)("a" + i + "_" + j));
            }
            list.add(tuple);
            ++i;
        }
        data.set("in", schemaString.toString(), list);
        pigServer.setBatchOn();
        pigServer.registerQuery("A = LOAD 'in' USING mock.Storage();");
        pigServer.deleteFile(out);
        pigServer.registerQuery("Store A into '" + out + "' using " + ParquetStorer.class.getName() + "();");
        if (((ExecJob)pigServer.executeBatch().get(0)).getStatus() != ExecJob.JOB_STATUS.COMPLETED) {
            throw new RuntimeException("Job failed", ((ExecJob)pigServer.executeBatch().get(0)).getException());
        }
        PerfTest.load(out, 1);
        PerfTest.load(out, 2);
        PerfTest.load(out, 3);
        PerfTest.load(out, 4);
        PerfTest.load(out, 5);
        PerfTest.load(out, 10);
        PerfTest.load(out, 20);
        PerfTest.load(out, 50);
        System.out.println(results);
    }

    private static void load(String out, int colsToLoad) throws ExecException, IOException {
        long t0 = System.currentTimeMillis();
        StringBuilder schemaString = new StringBuilder("a0: chararray");
        for (int i = 1; i < colsToLoad; ++i) {
            schemaString.append(", a" + i + ": chararray");
        }
        PigServer pigServer = new PigServer(ExecType.LOCAL);
        pigServer.registerQuery("B = LOAD '" + out + "' USING " + ParquetLoader.class.getName() + "('" + schemaString + "');");
        pigServer.registerQuery("C = FOREACH (GROUP B ALL) GENERATE COUNT(B);");
        Iterator it = pigServer.openIterator("C");
        if (!it.hasNext()) {
            throw new RuntimeException("Job failed: no tuple to read");
        }
        Long count = (Long)((Tuple)it.next()).get(0);
        Assert.assertEquals((long)100000L, (long)count);
        long t1 = System.currentTimeMillis();
        results.append(t1 - t0 + " ms to read " + colsToLoad + " columns\n");
    }
}

