/*
 * Decompiled with CFR 0.152.
 */
package parquet.pig;

import java.util.HashMap;
import java.util.Map;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.NonSpillableDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.parser.ParserException;
import parquet.column.ColumnWriteStore;
import parquet.column.ParquetProperties;
import parquet.column.impl.ColumnWriteStoreImpl;
import parquet.column.page.PageReadStore;
import parquet.column.page.PageWriteStore;
import parquet.column.page.mem.MemPageStore;
import parquet.hadoop.api.ReadSupport;
import parquet.io.ColumnIOFactory;
import parquet.io.MessageColumnIO;
import parquet.io.RecordReader;
import parquet.io.api.RecordMaterializer;
import parquet.pig.PigMetaData;
import parquet.pig.PigSchemaConverter;
import parquet.pig.TupleReadSupport;
import parquet.pig.TupleWriteSupport;
import parquet.schema.MessageType;

public class TupleConsumerPerfTest {
    private static final int TOP_LEVEL_COLS = 1;

    public static void main(String[] args) throws Exception {
        String pigSchema = TupleConsumerPerfTest.pigSchema(false, false);
        String pigSchemaProjected = TupleConsumerPerfTest.pigSchema(true, false);
        String pigSchemaNoString = TupleConsumerPerfTest.pigSchema(true, true);
        MessageType schema = new PigSchemaConverter().convert(Utils.getSchemaFromString((String)pigSchema));
        MemPageStore memPageStore = new MemPageStore(0L);
        ColumnWriteStoreImpl columns = new ColumnWriteStoreImpl((PageWriteStore)memPageStore, 0x3200000, 0x3200000, 0x3200000, false, ParquetProperties.WriterVersion.PARQUET_1_0);
        TupleConsumerPerfTest.write(memPageStore, columns, schema, pigSchema);
        columns.flush();
        TupleConsumerPerfTest.read((PageReadStore)memPageStore, pigSchema, pigSchemaProjected, pigSchemaNoString);
        System.out.println(columns.memSize() + " bytes used total");
        System.out.println("max col size: " + columns.maxColMemSize() + " bytes");
    }

    private static String pigSchema(boolean projected, boolean noStrings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 1; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("i" + i + ":(");
            if (!noStrings) {
                for (int j = 0; j < (projected ? 2 : 4); ++j) {
                    if (j != 0) {
                        sb.append(", ");
                    }
                    sb.append("j" + j + ":chararray");
                }
                sb.append(", ");
            }
            for (int k = 0; k < (projected ? 2 : 4); ++k) {
                if (k != 0) {
                    sb.append(", ");
                }
                sb.append("k" + k + ":long");
            }
            for (int l = 0; l < (projected ? 1 : 2); ++l) {
                sb.append(", ");
                sb.append("l" + l + ":{t:(v:int)}");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    private static Tuple tuple() throws ExecException {
        TupleFactory tf = TupleFactory.getInstance();
        Tuple t = tf.newTuple(1);
        for (int i = 0; i < 1; ++i) {
            Tuple ti = tf.newTuple(10);
            for (int j = 0; j < 4; ++j) {
                ti.set(j, (Object)("foo" + i + "," + j));
            }
            for (int k = 0; k < 4; ++k) {
                ti.set(4 + k, (Object)k);
            }
            for (int l = 0; l < 2; ++l) {
                NonSpillableDataBag bag = new NonSpillableDataBag();
                for (int m = 0; m < 10; ++m) {
                    bag.add(tf.newTuple((Object)new Integer(m)));
                }
                ti.set(8 + l, (Object)bag);
            }
            t.set(i, (Object)ti);
        }
        return t;
    }

    private static void read(PageReadStore columns, String pigSchemaString, String pigSchemaProjected, String pigSchemaProjectedNoStrings) throws ParserException {
        TupleConsumerPerfTest.read(columns, pigSchemaString, "read all");
        TupleConsumerPerfTest.read(columns, pigSchemaProjected, "read projected");
        TupleConsumerPerfTest.read(columns, pigSchemaProjectedNoStrings, "read projected no Strings");
    }

    private static void read(PageReadStore columns, String pigSchemaString, String message) throws ParserException {
        System.out.println(message);
        MessageColumnIO columnIO = TupleConsumerPerfTest.newColumnFactory(pigSchemaString);
        TupleReadSupport tupleReadSupport = new TupleReadSupport();
        Map<String, String> pigMetaData = TupleConsumerPerfTest.pigMetaData(pigSchemaString);
        MessageType schema = new PigSchemaConverter().convert(Utils.getSchemaFromString((String)pigSchemaString));
        ReadSupport.ReadContext init = tupleReadSupport.init(null, pigMetaData, schema);
        RecordMaterializer recordConsumer = tupleReadSupport.prepareForRead(null, pigMetaData, schema, init);
        RecordReader recordReader = columnIO.getRecordReader(columns, recordConsumer);
        TupleConsumerPerfTest.read((RecordReader<Tuple>)recordReader, 10000, pigSchemaString);
        TupleConsumerPerfTest.read((RecordReader<Tuple>)recordReader, 10000, pigSchemaString);
        TupleConsumerPerfTest.read((RecordReader<Tuple>)recordReader, 10000, pigSchemaString);
        TupleConsumerPerfTest.read((RecordReader<Tuple>)recordReader, 10000, pigSchemaString);
        TupleConsumerPerfTest.read((RecordReader<Tuple>)recordReader, 10000, pigSchemaString);
        TupleConsumerPerfTest.read((RecordReader<Tuple>)recordReader, 100000, pigSchemaString);
        TupleConsumerPerfTest.read((RecordReader<Tuple>)recordReader, 1000000, pigSchemaString);
        System.out.println();
    }

    private static Map<String, String> pigMetaData(String pigSchemaString) {
        HashMap<String, String> map = new HashMap<String, String>();
        new PigMetaData(pigSchemaString).addToMetaData(map);
        return map;
    }

    private static void write(MemPageStore memPageStore, ColumnWriteStoreImpl columns, MessageType schema, String pigSchemaString) throws ExecException, ParserException {
        MessageColumnIO columnIO = TupleConsumerPerfTest.newColumnFactory(pigSchemaString);
        TupleWriteSupport tupleWriter = TupleWriteSupport.fromPigSchema((String)pigSchemaString);
        tupleWriter.init(null);
        tupleWriter.prepareForWrite(columnIO.getRecordWriter((ColumnWriteStore)columns));
        TupleConsumerPerfTest.write(memPageStore, tupleWriter, 10000);
        TupleConsumerPerfTest.write(memPageStore, tupleWriter, 10000);
        TupleConsumerPerfTest.write(memPageStore, tupleWriter, 10000);
        TupleConsumerPerfTest.write(memPageStore, tupleWriter, 10000);
        TupleConsumerPerfTest.write(memPageStore, tupleWriter, 10000);
        TupleConsumerPerfTest.write(memPageStore, tupleWriter, 100000);
        TupleConsumerPerfTest.write(memPageStore, tupleWriter, 1000000);
        System.out.println();
    }

    private static MessageColumnIO newColumnFactory(String pigSchemaString) throws ParserException {
        MessageType schema = new PigSchemaConverter().convert(Utils.getSchemaFromString((String)pigSchemaString));
        return new ColumnIOFactory().getColumnIO(schema);
    }

    private static void read(RecordReader<Tuple> recordReader, int count, String pigSchemaString) throws ParserException {
        long t0 = System.currentTimeMillis();
        Tuple tuple = null;
        for (int i = 0; i < count; ++i) {
            tuple = (Tuple)recordReader.read();
        }
        if (tuple == null) {
            throw new RuntimeException();
        }
        long t1 = System.currentTimeMillis();
        long t = t1 - t0;
        float err = 200.0f / (float)t;
        System.out.printf("read %,9d recs in %,5d ms at %,9d rec/s err: %3.2f%%\n", count, t, t == 0L ? 0L : (long)(count * 1000) / t, Float.valueOf(err));
    }

    private static void write(MemPageStore memPageStore, TupleWriteSupport tupleWriter, int count) throws ExecException {
        Tuple tu = TupleConsumerPerfTest.tuple();
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            tupleWriter.write(tu);
        }
        long t1 = System.currentTimeMillis();
        long t = t1 - t0;
        memPageStore.addRowCount((long)count);
        System.out.printf("written %,9d recs in %,5d ms at %,9d rec/s\n", count, t, t == 0L ? 0L : (long)(count * 1000) / t);
    }
}

