/*
 * Decompiled with CFR 0.152.
 */
package parquet.pig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.builtin.mock.Storage;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.parser.ParserException;
import org.junit.Assert;
import org.junit.Test;
import parquet.Log;
import parquet.example.data.Group;
import parquet.example.data.GroupWriter;
import parquet.example.data.simple.SimpleGroup;
import parquet.example.data.simple.convert.GroupRecordConverter;
import parquet.hadoop.api.InitContext;
import parquet.hadoop.api.ReadSupport;
import parquet.io.ConverterConsumer;
import parquet.io.RecordConsumerLoggingWrapper;
import parquet.io.api.RecordConsumer;
import parquet.io.api.RecordMaterializer;
import parquet.pig.PigMetaData;
import parquet.pig.PigSchemaConverter;
import parquet.pig.TupleReadSupport;
import parquet.pig.TupleWriteSupport;
import parquet.schema.GroupType;
import parquet.schema.MessageType;

public class TestTupleRecordConsumer {
    private static final Log logger = Log.getLog(TestTupleRecordConsumer.class);

    @Test
    public void testArtSchema() throws ExecException, ParserException {
        String pigSchemaString = "DocId:long, Links:(Backward:{(long)}, Forward:{(long)}), Name:{(Language:{(Code:chararray,Country:chararray)}, Url:chararray)}";
        SimpleGroup g = new SimpleGroup((GroupType)this.getMessageType(pigSchemaString));
        g.add("DocId", 1L);
        Group links = g.addGroup("Links");
        links.addGroup("Backward").addGroup("bag").add(0, 1L);
        links.addGroup("Forward").addGroup("bag").add(0, 1L);
        Group name = g.addGroup("Name").addGroup("bag");
        name.addGroup("Language").addGroup("bag").append("Code", "en").append("Country", "US");
        name.add("Url", "http://foo/bar");
        this.testFromGroups(pigSchemaString, Arrays.asList(g));
    }

    @Test
    public void testBags() throws ExecException, ParserException {
        String pigSchemaString = "a: {(b: chararray)}";
        SimpleGroup g = new SimpleGroup((GroupType)this.getMessageType(pigSchemaString));
        Group addGroup = g.addGroup("a");
        addGroup.addGroup("bag").append("b", "foo");
        addGroup.addGroup("bag").append("b", "bar");
        this.testFromGroups(pigSchemaString, Arrays.asList(g));
    }

    @Test
    public void testMaps() throws ExecException, ParserException {
        String pigSchemaString = "a: [(b: chararray)]";
        SimpleGroup g = new SimpleGroup((GroupType)this.getMessageType(pigSchemaString));
        Group map = g.addGroup("a");
        map.addGroup("map").append("key", "foo").addGroup("value").append("b", "foo");
        map.addGroup("map").append("key", "bar").addGroup("value").append("b", "bar");
        this.testFromGroups(pigSchemaString, Arrays.asList(g));
    }

    @Test
    public void testComplexSchema() throws Exception {
        String pigSchemaString = "a:chararray, b:{t:(c:chararray, d:chararray)}";
        Tuple t0 = Storage.tuple((Object[])new Object[]{"a0", Storage.bag((Tuple[])new Tuple[]{Storage.tuple((Object[])new Object[]{"o", "b"}), Storage.tuple((Object[])new Object[]{"o1", "b1"})})});
        Tuple t1 = Storage.tuple((Object[])new Object[]{"a1", Storage.bag((Tuple[])new Tuple[]{Storage.tuple((Object[])new Object[]{"o", "b"}), Storage.tuple((Object[])new Object[]{"o", "b"}), Storage.tuple((Object[])new Object[]{"o", "b"}), Storage.tuple((Object[])new Object[]{"o", "b"})})});
        Tuple t2 = Storage.tuple((Object[])new Object[]{"a2", Storage.bag((Tuple[])new Tuple[]{Storage.tuple((Object[])new Object[]{"o", "b"}), Storage.tuple((Object[])new Object[]{"o", null}), Storage.tuple((Object[])new Object[]{null, "b"}), Storage.tuple((Object[])new Object[]{null, null})})});
        Tuple t3 = Storage.tuple((Object[])new Object[]{"a3", null});
        this.testFromTuple(pigSchemaString, Arrays.asList(t0, t1, t2, t3));
    }

    @Test
    public void testMapSchema() throws Exception {
        String pigSchemaString = "a:chararray, b:[(c:chararray, d:chararray)]";
        Tuple t0 = Storage.tuple((Object[])new Object[]{"a0", new HashMap(){
            {
                this.put("foo", Storage.tuple((Object[])new Object[]{"o", "b"}));
            }
        }});
        Tuple t1 = Storage.tuple((Object[])new Object[]{"a1", new HashMap(){
            {
                this.put("foo", Storage.tuple((Object[])new Object[]{"o", "b"}));
                this.put("foo", Storage.tuple((Object[])new Object[]{"o", "b"}));
                this.put("foo", Storage.tuple((Object[])new Object[]{"o", "b"}));
                this.put("foo", Storage.tuple((Object[])new Object[]{"o", "b"}));
            }
        }});
        Tuple t2 = Storage.tuple((Object[])new Object[]{"a2", new HashMap(){
            {
                this.put("foo", Storage.tuple((Object[])new Object[]{"o", "b"}));
                this.put("foo", Storage.tuple((Object[])new Object[]{"o", null}));
                this.put("foo", Storage.tuple((Object[])new Object[]{null, "b"}));
                this.put("foo", Storage.tuple((Object[])new Object[]{null, null}));
            }
        }});
        Tuple t3 = Storage.tuple((Object[])new Object[]{"a3", null});
        this.testFromTuple(pigSchemaString, Arrays.asList(t0, t1, t2, t3));
    }

    private void testFromTuple(String pigSchemaString, List<Tuple> input) throws Exception {
        ArrayList<Object> tuples = new ArrayList<Object>();
        RecordMaterializer<Tuple> recordConsumer = this.newPigRecordConsumer(pigSchemaString);
        TupleWriteSupport tupleWriter = this.newTupleWriter(pigSchemaString, recordConsumer);
        for (Tuple tuple : input) {
            logger.debug((Object)tuple);
            tupleWriter.write(tuple);
            tuples.add(recordConsumer.getCurrentRecord());
        }
        Assert.assertEquals((long)input.size(), (long)tuples.size());
        for (int i = 0; i < input.size(); ++i) {
            Tuple in = input.get(i);
            Tuple out = (Tuple)tuples.get(i);
            Assert.assertEquals((Object)in.toString(), (Object)out.toString());
        }
    }

    private void testFromGroups(String pigSchemaString, List<Group> input) throws ParserException {
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        MessageType schema = this.getMessageType(pigSchemaString);
        RecordMaterializer<Tuple> pigRecordConsumer = this.newPigRecordConsumer(pigSchemaString);
        GroupWriter groupWriter = new GroupWriter((RecordConsumer)new RecordConsumerLoggingWrapper((RecordConsumer)new ConverterConsumer(pigRecordConsumer.getRootConverter(), schema)), (GroupType)schema);
        for (Group group : input) {
            groupWriter.write(group);
            Tuple tuple = (Tuple)pigRecordConsumer.getCurrentRecord();
            tuples.add(tuple);
            logger.debug((Object)("in: " + group + "\nout:" + tuple));
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        GroupRecordConverter recordConsumer = new GroupRecordConverter(schema);
        TupleWriteSupport tupleWriter = this.newTupleWriter(pigSchemaString, (RecordMaterializer)recordConsumer);
        for (Tuple t : tuples) {
            logger.debug((Object)t);
            tupleWriter.write(t);
            groups.add(recordConsumer.getCurrentRecord());
        }
        Assert.assertEquals((long)input.size(), (long)groups.size());
        for (int i = 0; i < input.size(); ++i) {
            Group in = input.get(i);
            logger.debug((Object)in);
            Group out = (Group)groups.get(i);
            Assert.assertEquals((Object)in.toString(), (Object)out.toString());
        }
    }

    private <T> TupleWriteSupport newTupleWriter(String pigSchemaString, RecordMaterializer<T> recordConsumer) throws ParserException {
        TupleWriteSupport tupleWriter = TupleWriteSupport.fromPigSchema((String)pigSchemaString);
        tupleWriter.init(null);
        tupleWriter.prepareForWrite((RecordConsumer)new ConverterConsumer(recordConsumer.getRootConverter(), tupleWriter.getParquetSchema()));
        return tupleWriter;
    }

    private Map<String, String> pigMetaData(String pigSchemaString) {
        HashMap<String, String> map = new HashMap<String, String>();
        new PigMetaData(pigSchemaString).addToMetaData(map);
        return map;
    }

    private RecordMaterializer<Tuple> newPigRecordConsumer(String pigSchemaString) throws ParserException {
        TupleReadSupport tupleReadSupport = new TupleReadSupport();
        Configuration configuration = new Configuration(false);
        MessageType parquetSchema = this.getMessageType(pigSchemaString);
        Map<String, String> pigMetaData = this.pigMetaData(pigSchemaString);
        HashMap<String, HashSet<String>> globalMetaData = new HashMap<String, HashSet<String>>();
        for (Map.Entry<String, String> entry : pigMetaData.entrySet()) {
            globalMetaData.put(entry.getKey(), new HashSet<String>(Arrays.asList(entry.getValue())));
        }
        configuration.set("parquet.pig.schema", pigSchemaString);
        ReadSupport.ReadContext init = tupleReadSupport.init(new InitContext(configuration, globalMetaData, parquetSchema));
        return tupleReadSupport.prepareForRead(configuration, pigMetaData, parquetSchema, init);
    }

    private MessageType getMessageType(String pigSchemaString) throws ParserException {
        Schema pigSchema = Utils.getSchemaFromString((String)pigSchemaString);
        return new PigSchemaConverter().convert(pigSchema);
    }
}

