/*
 * Decompiled with CFR 0.152.
 */
package parquet.pig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.ExecType;
import org.apache.pig.LoadPushDown;
import org.apache.pig.PigServer;
import org.apache.pig.builtin.mock.Storage;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.junit.Assert;
import org.junit.Test;
import parquet.pig.ParquetLoader;
import parquet.pig.ParquetStorer;
import parquet.pig.TupleReadSupport;

public class TestParquetLoader {
    @Test
    public void testSchema() throws Exception {
        String location = "garbage";
        ParquetLoader pLoader = new ParquetLoader("a:chararray, b:{t:(c:chararray, d:chararray)}, p:[(q:chararray, r:chararray)]");
        Job job = new Job();
        pLoader.getSchema(location, job);
        LoadPushDown.RequiredFieldList list = new LoadPushDown.RequiredFieldList();
        LoadPushDown.RequiredField field = new LoadPushDown.RequiredField("a", 0, null, 55);
        list.add(field);
        field = new LoadPushDown.RequiredField("b", 0, Arrays.asList(new LoadPushDown.RequiredField("t", 0, Arrays.asList(new LoadPushDown.RequiredField("d", 1, null, 55)), 110)), 120);
        list.add(field);
        pLoader.pushProjection(list);
        pLoader.setLocation(location, job);
        Assert.assertEquals((Object)"{a: chararray,b: {t: (d: chararray)}}", (Object)TupleReadSupport.getPigSchema((Configuration)job.getConfiguration()).toString());
    }

    @Test
    public void testProjectionPushdown() throws Exception {
        PigServer pigServer = new PigServer(ExecType.LOCAL);
        pigServer.setValidateEachStatement(true);
        String out = "target/out";
        int rows = 10;
        Storage.Data data = Storage.resetData((PigServer)pigServer);
        ArrayList<Tuple> list = new ArrayList<Tuple>();
        for (int i = 0; i < rows; ++i) {
            list.add(Storage.tuple((Object[])new Object[]{i, "a" + i, i * 2}));
        }
        data.set("in", "i:int, a:chararray, b:int", list);
        pigServer.setBatchOn();
        pigServer.registerQuery("A = LOAD 'in' USING mock.Storage();");
        pigServer.deleteFile(out);
        pigServer.registerQuery("Store A into '" + out + "' using " + ParquetStorer.class.getName() + "();");
        pigServer.executeBatch();
        ArrayList<Tuple> expectedList = new ArrayList<Tuple>();
        for (int i = 0; i < rows; ++i) {
            expectedList.add(Storage.tuple((Object[])new Object[]{"a" + i}));
        }
        pigServer.registerQuery("C = LOAD '" + out + "' using " + ParquetLoader.class.getName() + "();");
        pigServer.registerQuery("D = foreach C generate a;");
        pigServer.registerQuery("Store D into 'out' using mock.Storage();");
        pigServer.executeBatch();
        List actualList = data.get("out");
        pigServer.registerQuery("C = LOAD '" + out + "' using " + ParquetLoader.class.getName() + "('a:chararray, b:int');");
        Assert.assertEquals((Object)"{a: chararray,b: int}", (Object)pigServer.dumpSchema("C").toString());
        try {
            pigServer.registerQuery("D = foreach C generate i;");
            Assert.fail((String)"Frontend Exception expected");
        }
        catch (FrontendException fe) {
            // empty catch block
        }
        pigServer = new PigServer(ExecType.LOCAL);
        data = Storage.resetData((PigServer)pigServer);
        pigServer.setBatchOn();
        pigServer.registerQuery("C = LOAD '" + out + "' using " + ParquetLoader.class.getName() + "('a:chararray, b:int');");
        pigServer.registerQuery("D = foreach C generate a;");
        pigServer.registerQuery("Store D into 'out' using mock.Storage();");
        pigServer.executeBatch();
        actualList = data.get("out");
        Assert.assertEquals(expectedList, (Object)actualList);
    }

    @Test
    public void testNullPadding() throws Exception {
        PigServer pigServer = new PigServer(ExecType.LOCAL);
        pigServer.setValidateEachStatement(true);
        String out = "target/out";
        int rows = 10;
        Storage.Data data = Storage.resetData((PigServer)pigServer);
        ArrayList<Tuple> list = new ArrayList<Tuple>();
        for (int i = 0; i < rows; ++i) {
            list.add(Storage.tuple((Object[])new Object[]{i, "a" + i, i * 2}));
        }
        data.set("in", "i:int, a:chararray, b:int", list);
        pigServer.setBatchOn();
        pigServer.registerQuery("A = LOAD 'in' USING mock.Storage();");
        pigServer.deleteFile(out);
        pigServer.registerQuery("Store A into '" + out + "' using " + ParquetStorer.class.getName() + "();");
        pigServer.executeBatch();
        pigServer.registerQuery("C = LOAD '" + out + "' using " + ParquetLoader.class.getName() + "('i:int, a:chararray, b:int, n1:int, n2:chararray');");
        pigServer.registerQuery("STORE C into 'out' using mock.Storage();");
        pigServer.executeBatch();
        List actualList = data.get("out");
        Assert.assertEquals((long)rows, (long)actualList.size());
        for (Tuple t : actualList) {
            Assert.assertTrue((boolean)t.isNull(3));
            Assert.assertTrue((boolean)t.isNull(4));
        }
        pigServer.registerQuery("D = LOAD '" + out + "' using " + ParquetLoader.class.getName() + "('n1:int, a:chararray, n2:chararray, b:int');");
        pigServer.registerQuery("STORE D into 'out2' using mock.Storage();");
        pigServer.executeBatch();
        actualList = data.get("out2");
        Assert.assertEquals((long)rows, (long)actualList.size());
        for (Tuple t : actualList) {
            Assert.assertTrue((boolean)t.isNull(0));
            Assert.assertTrue((boolean)t.isNull(2));
        }
    }

    @Test
    public void testReqestedSchemaColumnPruning() throws Exception {
        PigServer pigServer = new PigServer(ExecType.LOCAL);
        pigServer.setValidateEachStatement(true);
        String out = "target/out";
        int rows = 10;
        Storage.Data data = Storage.resetData((PigServer)pigServer);
        ArrayList<Tuple> list = new ArrayList<Tuple>();
        for (int i = 0; i < rows; ++i) {
            list.add(Storage.tuple((Object[])new Object[]{i, "a" + i, i * 2}));
        }
        data.set("in", "i:int, a:chararray, b:int", list);
        pigServer.setBatchOn();
        pigServer.registerQuery("A = LOAD 'in' USING mock.Storage();");
        pigServer.deleteFile(out);
        pigServer.registerQuery("Store A into '" + out + "' using " + ParquetStorer.class.getName() + "();");
        pigServer.executeBatch();
        pigServer.registerQuery("C = LOAD '" + out + "' using " + ParquetLoader.class.getName() + "('i:int, a:chararray, b:int, n1:int, n2:chararray');");
        pigServer.registerQuery("G = foreach C generate n1,b,n2,i;");
        pigServer.registerQuery("STORE G into 'out' using mock.Storage();");
        pigServer.executeBatch();
        List actualList = data.get("out");
        Assert.assertEquals((long)rows, (long)actualList.size());
        for (Tuple t : actualList) {
            Assert.assertEquals((long)4L, (long)t.size());
            Assert.assertTrue((boolean)t.isNull(0));
            Assert.assertTrue((boolean)t.isNull(2));
        }
    }

    @Test
    public void testRead() {
    }
}

