/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.rle;

import java.io.IOException;
import java.nio.ByteBuffer;
import parquet.bytes.ByteBufferInputStream;
import parquet.bytes.BytesUtils;
import parquet.column.values.ValuesReader;
import parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import parquet.io.ParquetDecodingException;

public class RunLengthBitPackingHybridValuesReader
extends ValuesReader {
    private final int bitWidth;
    private RunLengthBitPackingHybridDecoder decoder;
    private int nextOffset;

    public RunLengthBitPackingHybridValuesReader(int bitWidth) {
        this.bitWidth = bitWidth;
    }

    @Override
    public void initFromPage(int valueCountL, ByteBuffer page, int offset) throws IOException {
        ByteBufferInputStream in = new ByteBufferInputStream(page.duplicate(), offset, page.limit() - offset);
        int length = BytesUtils.readIntLittleEndian(in);
        this.decoder = new RunLengthBitPackingHybridDecoder(this.bitWidth, in);
        this.nextOffset = offset + length + 4;
    }

    @Override
    public void initFromPage(int valueCount, byte[] page, int offset) throws IOException {
        this.initFromPage(valueCount, ByteBuffer.wrap(page), offset);
    }

    @Override
    public int getNextOffset() {
        return this.nextOffset;
    }

    @Override
    public int readInteger() {
        try {
            return this.decoder.readInt();
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public boolean readBoolean() {
        return this.readInteger() != 0;
    }

    @Override
    public void skip() {
        this.readInteger();
    }
}

