/*
 * Decompiled with CFR 0.152.
 */
package parquet.pig;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import parquet.Log;
import parquet.hadoop.api.InitContext;
import parquet.hadoop.api.ReadSupport;
import parquet.io.ParquetDecodingException;
import parquet.io.api.RecordMaterializer;
import parquet.pig.PigMetaData;
import parquet.pig.PigSchemaConverter;
import parquet.pig.SchemaConversionException;
import parquet.pig.convert.TupleRecordMaterializer;
import parquet.schema.IncompatibleSchemaModificationException;
import parquet.schema.MessageType;

public class TupleReadSupport
extends ReadSupport<Tuple> {
    static final String PARQUET_PIG_SCHEMA = "parquet.pig.schema";
    static final String PARQUET_PIG_ELEPHANT_BIRD_COMPATIBLE = "parquet.pig.elephantbird.compatible";
    private static final Log LOG = Log.getLog(TupleReadSupport.class);
    private static final PigSchemaConverter pigSchemaConverter = new PigSchemaConverter();

    static Schema getPigSchema(Configuration configuration) {
        return PigSchemaConverter.parsePigSchema(configuration.get(PARQUET_PIG_SCHEMA));
    }

    static Schema getPigSchemaFromMultipleFiles(MessageType fileSchema, Map<String, Set<String>> keyValueMetaData) {
        Set<String> pigSchemas = PigMetaData.getPigSchemas(keyValueMetaData);
        if (pigSchemas == null) {
            return pigSchemaConverter.convert(fileSchema);
        }
        Schema mergedPigSchema = null;
        for (String pigSchemaString : pigSchemas) {
            try {
                mergedPigSchema = TupleReadSupport.union(mergedPigSchema, PigSchemaConverter.parsePigSchema(pigSchemaString));
            }
            catch (FrontendException e) {
                throw new ParquetDecodingException("can not merge " + pigSchemaString + " into " + mergedPigSchema, e);
            }
        }
        return mergedPigSchema;
    }

    static Schema getPigSchemaFromFile(MessageType fileSchema, Map<String, String> keyValueMetaData) {
        PigMetaData pigMetaData = PigMetaData.fromMetaData(keyValueMetaData);
        if (pigMetaData == null) {
            return pigSchemaConverter.convert(fileSchema);
        }
        return PigSchemaConverter.parsePigSchema(pigMetaData.getPigSchema());
    }

    private static Schema union(Schema merged, Schema pigSchema) throws FrontendException {
        ArrayList<Schema.FieldSchema> fields = new ArrayList<Schema.FieldSchema>();
        if (merged == null) {
            return pigSchema;
        }
        for (Schema.FieldSchema fieldSchema : merged.getFields()) {
            Schema.FieldSchema newFieldSchema = pigSchema.getField(fieldSchema.alias);
            if (newFieldSchema == null) {
                fields.add(fieldSchema);
                continue;
            }
            fields.add(TupleReadSupport.union(fieldSchema, newFieldSchema));
        }
        for (Schema.FieldSchema newFieldSchema : pigSchema.getFields()) {
            Schema.FieldSchema oldFieldSchema = merged.getField(newFieldSchema.alias);
            if (oldFieldSchema != null) continue;
            fields.add(newFieldSchema);
        }
        return new Schema(fields);
    }

    private static Schema.FieldSchema union(Schema.FieldSchema mergedFieldSchema, Schema.FieldSchema newFieldSchema) {
        if (!mergedFieldSchema.alias.equals(newFieldSchema.alias) || mergedFieldSchema.type != newFieldSchema.type) {
            throw new IncompatibleSchemaModificationException("Incompatible Pig schema change: " + mergedFieldSchema + " can not accept");
        }
        try {
            return new Schema.FieldSchema(mergedFieldSchema.alias, TupleReadSupport.union(mergedFieldSchema.schema, newFieldSchema.schema), mergedFieldSchema.type);
        }
        catch (FrontendException e) {
            throw new SchemaConversionException(e);
        }
    }

    @Override
    public ReadSupport.ReadContext init(InitContext initContext) {
        Schema requestedPigSchema = TupleReadSupport.getPigSchema(initContext.getConfiguration());
        if (requestedPigSchema == null) {
            return new ReadSupport.ReadContext(initContext.getFileSchema());
        }
        MessageType parquetRequestedSchema = pigSchemaConverter.filter(initContext.getFileSchema(), requestedPigSchema);
        return new ReadSupport.ReadContext(parquetRequestedSchema);
    }

    @Override
    public RecordMaterializer<Tuple> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        MessageType requestedSchema = readContext.getRequestedSchema();
        Schema requestedPigSchema = TupleReadSupport.getPigSchema(configuration);
        if (requestedPigSchema == null) {
            throw new ParquetDecodingException("Missing Pig schema: ParquetLoader sets the schema in the job conf");
        }
        boolean elephantBirdCompatible = configuration.getBoolean(PARQUET_PIG_ELEPHANT_BIRD_COMPATIBLE, false);
        if (elephantBirdCompatible) {
            LOG.info("Numbers will default to 0 instead of NULL; Boolean will be converted to Int");
        }
        return new TupleRecordMaterializer(requestedSchema, requestedPigSchema, elephantBirdCompatible);
    }
}

