/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.statistics;

import parquet.column.statistics.Statistics;
import parquet.io.api.Binary;

public class BinaryStatistics
extends Statistics {
    private Binary max;
    private Binary min;

    @Override
    public void updateStats(Binary value) {
        if (this.isEmpty()) {
            this.initializeStats(value, value);
        } else {
            this.updateStats(value, value);
        }
    }

    @Override
    public void mergeStatisticsMinMax(Statistics stats) {
        BinaryStatistics binaryStats = (BinaryStatistics)stats;
        if (this.isEmpty()) {
            this.initializeStats(binaryStats.getMin(), binaryStats.getMax());
        } else {
            this.updateStats(binaryStats.getMin(), binaryStats.getMax());
        }
    }

    @Override
    public void setMinMaxFromBytes(byte[] minBytes, byte[] maxBytes) {
        this.max = Binary.fromByteArray(maxBytes);
        this.min = Binary.fromByteArray(minBytes);
        this.markAsNotEmpty();
    }

    @Override
    public byte[] getMaxBytes() {
        return this.max.getBytes();
    }

    @Override
    public byte[] getMinBytes() {
        return this.min.getBytes();
    }

    @Override
    public String toString() {
        if (!this.isEmpty()) {
            return String.format("min: %s, max: %s, num_nulls: %d", this.min.toStringUsingUTF8(), this.max.toStringUsingUTF8(), this.getNumNulls());
        }
        return "no stats for this column";
    }

    public void updateStats(Binary min_value, Binary max_value) {
        if (this.min.compareTo(min_value) > 0) {
            this.min = Binary.fromByteArray(min_value.getBytes());
        }
        if (this.max.compareTo(max_value) < 0) {
            this.max = Binary.fromByteArray(max_value.getBytes());
        }
    }

    public void initializeStats(Binary min_value, Binary max_value) {
        this.min = Binary.fromByteArray(min_value.getBytes());
        this.max = Binary.fromByteArray(max_value.getBytes());
        this.markAsNotEmpty();
    }

    public Binary getMax() {
        return this.max;
    }

    public Binary getMin() {
        return this.min;
    }

    public void setMinMax(Binary min, Binary max) {
        this.max = max;
        this.min = min;
        this.markAsNotEmpty();
    }
}

