/*
 * Decompiled with CFR 0.152.
 */
package parquet.column;

import parquet.bytes.ByteBufferAllocator;
import parquet.bytes.BytesUtils;
import parquet.bytes.HeapByteBufferAllocator;
import parquet.column.ColumnDescriptor;
import parquet.column.values.ValuesWriter;
import parquet.column.values.boundedint.DevNullValuesWriter;
import parquet.column.values.delta.DeltaBinaryPackingValuesWriter;
import parquet.column.values.deltastrings.DeltaByteArrayWriter;
import parquet.column.values.dictionary.DictionaryValuesWriter;
import parquet.column.values.plain.BooleanPlainValuesWriter;
import parquet.column.values.plain.FixedLenByteArrayPlainValuesWriter;
import parquet.column.values.plain.PlainValuesWriter;
import parquet.column.values.rle.RunLengthBitPackingHybridValuesWriter;

public class ParquetProperties {
    private final int dictionaryPageSizeThreshold;
    private final WriterVersion writerVersion;
    private final boolean enableDictionary;
    private ByteBufferAllocator allocator;

    public ParquetProperties(int dictPageSize, WriterVersion writerVersion, boolean enableDict) {
        this(dictPageSize, writerVersion, enableDict, new HeapByteBufferAllocator());
    }

    public ParquetProperties(int dictPageSize, WriterVersion writerVersion, boolean enableDict, ByteBufferAllocator allocator) {
        this.dictionaryPageSizeThreshold = dictPageSize;
        this.writerVersion = writerVersion;
        this.enableDictionary = enableDict;
        this.allocator = allocator;
    }

    public static ValuesWriter getColumnDescriptorValuesWriter(int maxLevel, int initialSizePerCol, ByteBufferAllocator allocator) {
        if (maxLevel == 0) {
            return new DevNullValuesWriter();
        }
        return new RunLengthBitPackingHybridValuesWriter(BytesUtils.getWidthFromMaxInt(maxLevel), initialSizePerCol, allocator != null ? allocator : new HeapByteBufferAllocator());
    }

    public ValuesWriter getValuesWriter(ColumnDescriptor path, int initialSizePerCol) {
        switch (path.getType()) {
            case BOOLEAN: {
                if (this.writerVersion == WriterVersion.PARQUET_1_0) {
                    return new BooleanPlainValuesWriter(this.allocator);
                }
                if (this.writerVersion != WriterVersion.PARQUET_2_0) break;
                return new RunLengthBitPackingHybridValuesWriter(1, initialSizePerCol, this.allocator);
            }
            case BINARY: {
                if (this.enableDictionary) {
                    return new DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter(this.dictionaryPageSizeThreshold, initialSizePerCol, this.allocator);
                }
                if (this.writerVersion == WriterVersion.PARQUET_1_0) {
                    return new PlainValuesWriter(initialSizePerCol, this.allocator);
                }
                if (this.writerVersion != WriterVersion.PARQUET_2_0) break;
                return new DeltaByteArrayWriter(initialSizePerCol, this.allocator);
            }
            case INT32: {
                if (this.enableDictionary) {
                    return new DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter(this.dictionaryPageSizeThreshold, initialSizePerCol, this.allocator);
                }
                if (this.writerVersion == WriterVersion.PARQUET_1_0) {
                    return new PlainValuesWriter(initialSizePerCol, this.allocator);
                }
                if (this.writerVersion != WriterVersion.PARQUET_2_0) break;
                return new DeltaBinaryPackingValuesWriter(initialSizePerCol, this.allocator);
            }
            case INT64: {
                if (this.enableDictionary) {
                    return new DictionaryValuesWriter.PlainLongDictionaryValuesWriter(this.dictionaryPageSizeThreshold, initialSizePerCol, this.allocator);
                }
                return new PlainValuesWriter(initialSizePerCol, this.allocator);
            }
            case INT96: {
                if (this.enableDictionary) {
                    return new DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter(this.dictionaryPageSizeThreshold, initialSizePerCol, 12, this.allocator);
                }
                return new FixedLenByteArrayPlainValuesWriter(12, initialSizePerCol, this.allocator);
            }
            case DOUBLE: {
                if (this.enableDictionary) {
                    return new DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter(this.dictionaryPageSizeThreshold, initialSizePerCol, this.allocator);
                }
                return new PlainValuesWriter(initialSizePerCol, this.allocator);
            }
            case FLOAT: {
                if (this.enableDictionary) {
                    return new DictionaryValuesWriter.PlainFloatDictionaryValuesWriter(this.dictionaryPageSizeThreshold, initialSizePerCol, this.allocator);
                }
                return new PlainValuesWriter(initialSizePerCol, this.allocator);
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return new FixedLenByteArrayPlainValuesWriter(path.getTypeLength(), initialSizePerCol, this.allocator);
            }
            default: {
                return new PlainValuesWriter(initialSizePerCol, this.allocator);
            }
        }
        return null;
    }

    public int getDictionaryPageSizeThreshold() {
        return this.dictionaryPageSizeThreshold;
    }

    public WriterVersion getWriterVersion() {
        return this.writerVersion;
    }

    public boolean isEnableDictionary() {
        return this.enableDictionary;
    }

    public static enum WriterVersion {
        PARQUET_1_0("v1"),
        PARQUET_2_0("v2");

        private final String shortName;

        private WriterVersion(String shortname) {
            this.shortName = shortname;
        }

        public static WriterVersion fromString(String name) {
            for (WriterVersion v : WriterVersion.values()) {
                if (!v.shortName.equals(name)) continue;
                return v;
            }
            return WriterVersion.valueOf(name);
        }
    }
}

